.TH XEphem 1X
.SH Name
XEphem \- an interactive astronomical ephemeris for X
.SH Syntax
\fBxephem [-prfb] [-install {yes|no|guess}]\fP
.SH Description
.na
.nh
.PP
.B XEphem
is an interactive astronomical ephemeris program for X Windows systems with
Motif. It provides many graphical views as well as quantitative heliocentric,
geocentric and topocentric information for Earth satellites, solar system
and celestial objects.

.B XEphem
contains extensive context-sensitive on-line help. Virtually none of
that help is duplicated here so go ahead and run
.B XEphem
to learn more.

The
.I Main window
of
.B XEphem
provides control and display of three basic services: observing circumstances,
looping, and access to additional tools and displays. Observing circumstances
includes location, date, time and atmospheric conditions (used for the
refraction model). Looping refers to the ability to set up
.B XEphem
so that it automatically increments time at a desired step size and
rate. Additional displays provide all of the graphical and quantitative
information available, and always refer to the circumstances defined in the
main menu. Tools provide access to plotting, searching, AAVSO, Seti@Home
and more.

.SH Options
.B -prfb
displays all the built-in default resources, then exits.

.B -install
controls whether
.B XEphem
will install a private colormap. Without this option
.B XEphem
will try to decide automatically whether it is necessary. To force
using a private colormap, use 
.I -install yes;
to prevent it use
.I -install no.
The default automatic behavior is equivalent to
.I -install guess.

.SH Menu Tour
.I File

This menu controls basic operation, including exiting. When 
.B XEphem
is first started it may beep. This means a message
has been put in the
.B messages
dialog, which can be displayed from this
menu. Other chores here include setting up network access;
a simple progress meter; controlling time and location information
remotely.

.I View

This menu offers several graphical displays if the Earth, Moon and several
planets; a user configurable table displaying; and Sky and Solar System
views.

.I Tools

This menu gives access to tools which can plot any 
.B XEphem
data items; save any data items to text files for easy export to other
programs; enter an arbitrary function to evaluate and solve using any 
.B XEphem
data items; access AAVSO online; monitor your Seti@Home client; show the
Night at a glance; and find close pairs of objects.

.I Data

This menu gives control over which objects 
.B XEphem
will work with.
Objects may be created on the fly, read from catalog files, deleted or
searched. A special category of objects known as
.I Field Stars
may be configured, which are very large catalogs of objects whose access
has been optimized. Up to three User objects may be assigned for especially
easy access in several other places throughout 
.B XEphem.
Also here is a tool which can update Earth satellite orbital elements from
the web.

.I Preferences

This menu offers several configuration choices. These will effect the
overall appearance or behavior of
.B XEphem.
These choices, as well as fonts and colors, can be changed
at runtime and saved to disk to become the new defaults.

.I Help

This menu offers overall information about
B .XEphem;
context sensitive help;
several worked examples;
references; version number and the Copyright statement.

.SH X Resources
.B XEphem
initial conditions are defined using
a resource file. By default the file is named XEphem located in a directory
also called XEphem in your $HOME directory. You will want to tune some of
these to your taste and circumstances; most may be left unchanged.

.SH Time zones
.B XEphem
will attempt to
obtain time zone information from the host operating system.
If this fails for some reason, time zone offset and name may also
be set manually at any time from the Main menu.

.SH Author
.PP
Elwood Downey, email ecdowney@ClearSkyInstitute.com.

.SH References
.PP
The latest information about
.B XEphem
is maintained at
.I http://www.clearskyinstitute.com/xephem
.PP
The online Help entry
.I on Credits
lists many of the references, individuals and organizations which have
contributed to
.B XEphem.
