/********************************************************************************
* Copyright (c) Des Herriott 1993, 1994
*               Erik Kunze   1995 - 1999
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Authors: Des Herriott
*          Erik Kunze
*******************************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#ifndef lint
static char rcsid[] = "$Id: resource.c,v 4.37 1999/01/12 17:34:54 erik Rel $";
#endif
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <stdio.h>
#include <stdlib.h>
#ifdef HAVE_STRINGS_H
# include <strings.h>
#endif
#include <ctype.h>
#include <unistd.h>
#include <sys/param.h>
#ifndef HAVE_GETHOSTNAME
# include <sys/utsname.h>
#endif
#include "debug.h"
#include "machine.h"
#include "util.h"
#ifdef AUDIO
#include "audio.h"
#endif
#ifdef XZX_PLUS3
#include "fdc.h"
#endif
#ifdef XZX_IF1
#include "if1.h"
#endif
#include "main.h"
#include "resource.h"
#define MAX_CHARS		80
#define MAX_DISP_LEN	256
#define MAX_STRING_LEN	1024
#define RESOURCE_FILE	".xzxrc"
#define NELEM(a)		(sizeof(a) / sizeof(a[0]))
#define ARG(x)			x, sizeof(x)
#define BOOL(x)			(x > 0 ? "true" : "false")
#define KEY(x)			XKeysymToString(x)
enum {
KM_JOY_UP,
KM_JOY_DOWN,
KM_JOY_LEFT,
KM_JOY_RIGHT,
KM_JOY_FIRE,
NUM_KEYMAPPINGS
};
static int getResource(XrmDatabase, const char *, const char *, char *,
unsigned int);
static int getString(XrmDatabase, const char *, const char *, char **);
static int getBool(XrmDatabase, const char *, const char *, int *);
static int getInteger(XrmDatabase, const char *, int, int *);
static void getFileDefaults(Display *, XrmDatabase *);
static void copyright(void);
static void usage(void);
static void version(void);
#ifdef DEBUG
static void printResources(void);
#endif
static void saveResources(void);
Config Conf;
static XrmOptionDescRec options[] = {
{ "-help",      "*help",          XrmoptionNoArg,  "True" },
{ "-version",   "*version",       XrmoptionNoArg,  "True" },
{ "-libDir",    "*libDir",        XrmoptionSepArg, NULL   },
{ "-quiet",     "*quiet",         XrmoptionSepArg, NULL   },
{ "-display",   "*display",       XrmoptionSepArg, NULL   },
{ "-geometry",  "*geometry",      XrmoptionSepArg, NULL   },
{ "-mono",      "*monocrome",     XrmoptionSepArg, NULL   },
{ "-private",   "*private",       XrmoptionSepArg, NULL   },
#ifdef HAVE_MITSHM
{ "-mitshm",    "*mitshm",        XrmoptionSepArg, NULL   },
#endif
{ "-xsync",     "*xsync",         XrmoptionSepArg, NULL   },
#ifdef DEBUG
{ "-debug",     "*debug",         XrmoptionSepArg, NULL   },
#endif
{ "-machine",   "*machine",       XrmoptionSepArg, NULL   },
{ "-speed",     "*speed",         XrmoptionSepArg, NULL   },
{ "-fast",      "*fast",          XrmoptionSepArg, NULL   },
{ "-scale",     "*scale",         XrmoptionSepArg, NULL   },
{ "-refresh",   "*refresh",       XrmoptionSepArg, NULL   },
{ "-cache",     "*cache",         XrmoptionSepArg, NULL   },
#ifdef SPEAKER_AUDIO
{ "-noise",     "*noise",         XrmoptionSepArg, NULL   },
#endif
{ "-joyUp",     "*joyUp",         XrmoptionSepArg, NULL   },
{ "-joyDown",   "*joyDown",       XrmoptionSepArg, NULL   },
{ "-joyLeft",   "*joyLeft",       XrmoptionSepArg, NULL   },
{ "-joyRight",  "*joyRight",      XrmoptionSepArg, NULL   },
{ "-joyFire",   "*joyFire",       XrmoptionSepArg, NULL   },
#ifdef JOY
{ "-joystick",  "*joystick",      XrmoptionSepArg, NULL   },
{ "-joyDev",    "*joyDev",        XrmoptionSepArg, NULL   },
{ "-tolerance", "*tolerance",     XrmoptionSepArg, NULL   },
{ "-autofire",  "*autofire",      XrmoptionSepArg, NULL   },
{ "-juggle",    "*juggle",        XrmoptionSepArg, NULL   },
#endif
#ifdef AUDIO
{ "-sound",     "*sound",         XrmoptionSepArg, NULL   },
#if defined(SPEAKER_AUDIO) || defined(AYCHIP_AUDIO)
{ "-audioDev",  "*audioDev",      XrmoptionSepArg, NULL   },
{ "-sample",    "*sample",        XrmoptionSepArg, NULL   },
#endif
#ifdef XBELL_AUDIO
{ "-volume",    "*volume",        XrmoptionSepArg, NULL   },
#endif
#endif
{ "-rom48",     "*rom48",         XrmoptionSepArg, NULL   },
{ "-issue",     "*issue",         XrmoptionSepArg, NULL   },
{ "-kbdlayout", "*kbdlayout",     XrmoptionSepArg, NULL   },
{ "-rom128",    "*rom128",        XrmoptionSepArg, NULL   },
#ifdef XZX_PLUS3
{ "-rompl3",    "*rompl3",        XrmoptionSepArg, NULL   },
{ "-fda",       "*fda",           XrmoptionSepArg, NULL   },
{ "-fdb",       "*fdb",           XrmoptionSepArg, NULL   },
#endif
#ifdef XZX_PENTAGON
{ "-pentRom",   "*pentRom",       XrmoptionSepArg, NULL   },
#endif
#ifdef XZX_SCORPION
{ "-scorRom",   "*scorRom",       XrmoptionSepArg, NULL   },
#endif
#ifdef XZX_IF1
{ "-if1",       "*if1",           XrmoptionSepArg, NULL   },
{ "-if1Rom",    "*if1Rom",        XrmoptionSepArg, NULL   },
{ "-crlf",      "*crlf",          XrmoptionSepArg, NULL   },
{ "-strcr",     "*strcr",         XrmoptionSepArg, NULL   },
{ "-m1",        "*m1",	          XrmoptionSepArg, NULL   },
#if IF1_DRIVES > 1
{ "-m2",        "*m2",	          XrmoptionSepArg, NULL   },
#endif
#if IF1_DRIVES > 2
{ "-m3",        "*m3",	          XrmoptionSepArg, NULL   },
#endif
#if IF1_DRIVES > 3
{ "-m4",        "*m4",	          XrmoptionSepArg, NULL   },
#endif
#if IF1_DRIVES > 4
{ "-m5",        "*m5",	          XrmoptionSepArg, NULL   },
#endif
#if IF1_DRIVES > 5
{ "-m6",        "*m6",	          XrmoptionSepArg, NULL   },
#endif
#if IF1_DRIVES > 6
{ "-m7",        "*m7",	          XrmoptionSepArg, NULL   },
#endif
#if IF1_DRIVES > 7
{ "-m8",        "*m8",	          XrmoptionSepArg, NULL   },
#endif
#endif
#ifdef XZX_MF
{ "-mf",        "*mf",            XrmoptionSepArg, NULL   },
{ "-mf128Rom",  "*mf128Rom",      XrmoptionSepArg, NULL   },
#ifdef XZX_PLUS3
{ "-mf3Rom",    "*mf3Rom",        XrmoptionSepArg, NULL   },
#endif
#endif
#ifdef XZX_KMOUSE
{ "-kmouse",    "*kmouse",        XrmoptionSepArg, NULL   },
{ "-grab",      "*grab",          XrmoptionSepArg, NULL   },
#endif
};
static struct {
char *res_name;
char *def_keysym;
} mapTab[NUM_KEYMAPPINGS] = {
{ "joyUp",     "q"     },
{ "joyDown",   "a"     },
{ "joyLeft",   "o"     },
{ "joyRight",  "p"     },
{ "joyFire",   "space" },
};
static char *mach2str[] = {
"48",
"48",
"128",
#ifdef XZX_PLUS3
"3",
#endif
#ifdef XZX_PENTAGON
"Pentagon",
#endif
#ifdef XZX_SCORPION
"Scorpion",
#endif
};
static char *myName  = "xzx";
static char *myClass = "Xzx";
static int
getResource(XrmDatabase db, const char *resource, const char *fallBack,
char *result, unsigned int size)
{
int	 i, len;
char strName[80], strClass[80], *strType[10];
XrmValue rmValue;
(void)sprintf(strName, "%s.%s", myName, resource);
(void)sprintf(strClass, "%s.%c%s",
myClass, isupper(*resource) ?
toupper(*resource) : *resource, resource + 1);
if (XrmGetResource(db, strName, strClass, strType, &rmValue) == True)
{
if (!rmValue.addr)
{
len = 0;
}
else
{
len = rmValue.size < size - 1 ? rmValue.size : size - 1;
(void)strncpy(result, rmValue.addr, (size_t)len);
}
result[len] = '\0';
for (i = 0; i < NELEM(options); i++)
{
if (options[i].argKind == XrmoptionIsArg
&& (!strcmp(result, options[i].option)
|| !strcmp(result, options[i].specifier)))
{
(void)strncpy(result, "true", size);
result[size - 1] = '\0';
break;
}
}
return 1;
}
if (fallBack)
{
(void)strncpy(result, fallBack, size - 1);
result[size - 1] = '\0';
}
else
{
result[0] = '\0';
}
return 0;
}
static int
getString(XrmDatabase db, const char *resource, const char *fallBack,
char **result)
{
char *src, *dst, buf[MAX_STRING_LEN];
int inDB;
inDB = getResource(db, resource, fallBack, buf, sizeof(buf));
src = dst = buf;
while ((*src & 0x7f) == *src && !isgraph(*src) && *src)
{
src++;
}
while ((*src & 0x7f) != *src || isgraph(*src))
{
*dst++ = *src++;
}
*dst = '\0';
*result = Strdup(buf, "getString");
return inDB;
}
static int
getBool(XrmDatabase db, const char *resource, const char *fallBack, int *result)
{
char resValue[MAX_CHARS];
int inDB;
inDB = getResource(db, resource, fallBack, ARG(resValue));
*result = (!strncasecmp(resValue, "true", 4)
|| !strncasecmp(resValue, "on", 2)
|| !strncasecmp(resValue, "yes", 3));
return inDB;
}
static int
getInteger(XrmDatabase db, const char *resource, int fallBack, int *result)
{
char resValue[MAX_CHARS];
int inDB;
if (!(inDB = getResource(db, resource, NULL, ARG(resValue)))
|| sscanf(resValue, "%d", result) <= 0)
*result = fallBack;
return inDB;
}
static void
getFileDefaults(Display *dpy, XrmDatabase *rDBptr)
{
int len;
char *ptr;
char path[MAXPATHLEN];
XrmDatabase	tmpDB;
#ifndef HAVE_GETHOSTNAME
struct utsname un;
#endif
char *lang = getenv("LANG");
char *home = getenv("HOME");
(void)sprintf(path, "%s/%s", LIBDIR, myClass);
*rDBptr = XrmGetFileDatabase(path);
#ifdef VMS
tmpDB = XrmGetFileDatabase("SYS$LOGIN:decw$xdefaults.dat");
XrmMergeDatabases(tmpDB, rDBptr);
tmpDB = XrmGetFileDatabase("DECW$USER_DEFAULTS:xzx.dat");
XrmMergeDatabases(tmpDB, rDBptr);
#else
if (lang)
{
(void)sprintf(path, "%s/%s/app-defaults/%s", USRLIBDIR, lang, myClass);
if (access(path, F_OK) == -1)
{
(void)sprintf(path, "%s/app-defaults/%s", USRLIBDIR, myClass);
}
}
else
{
(void)sprintf(path, "%s/app-defaults/%s", USRLIBDIR, myClass);
}
tmpDB = XrmGetFileDatabase(path);
XrmMergeDatabases(tmpDB, rDBptr);
if ((ptr = getenv("XUSERFILESEARCHPATH")))
{
(void)sprintf(path, "%s/%s", ptr, myClass);
tmpDB = XrmGetFileDatabase(path);
XrmMergeDatabases(tmpDB, rDBptr);
}
else if ((ptr = getenv("XAPPLRESDIR")))
{
if (lang)
{
(void)sprintf(path, "%s/%s/%s", ptr, lang, myClass);
if (access(path, F_OK) == -1)
{
(void)sprintf(path, "%s/%s", ptr, myClass);
}
}
else
{
(void)sprintf(path, "%s/%s", ptr, myClass);
}
tmpDB = XrmGetFileDatabase(path);
XrmMergeDatabases(tmpDB, rDBptr);
}
else if (home)
{
if (lang)
{
(void)sprintf(path, "%s/app-defaults/%s/%s", home, lang, myClass);
if (access(path, F_OK) == -1)
{
(void)sprintf(path, "%s/app-defaults/%s", home, myClass);
}
}
else
{
(void)sprintf(path, "%s/app-defaults/%s", home, myClass);
}
tmpDB = XrmGetFileDatabase(path);
XrmMergeDatabases(tmpDB, rDBptr);
}
if ((ptr = XResourceManagerString(dpy)))
{
tmpDB = XrmGetStringDatabase(ptr);
XrmMergeDatabases(tmpDB, rDBptr);
}
else if (home)
{
(void)sprintf(path, "%s/.Xdefaults", home);
tmpDB = XrmGetFileDatabase(path);
XrmMergeDatabases(tmpDB, rDBptr);
}
if ((ptr = getenv("XENVIRONMENT")))
{
tmpDB = XrmGetFileDatabase(ptr);
XrmMergeDatabases(tmpDB, rDBptr);
}
else if (home)
{
(void)sprintf(path, "%s/.Xdefaults-", home);
len = strlen(path);
#ifndef HAVE_GETHOSTNAME
(void)uname(&un);
(void)strncpy(&path[len], un.sysname, sizeof(path - len));
#else
(void)gethostname(&path[len], sizeof path - len);
path[sizeof path - 1] = '\0';
#endif
tmpDB = XrmGetFileDatabase(path);
XrmMergeDatabases(tmpDB, rDBptr);
}
#endif
}
Display *
GetResources(int *argcp, char **argvp)
{
int	 i;
char *ptr;
char resValue[MAX_CHARS];
char displayName[MAX_DISP_LEN];
XrmDatabase argDB, rDB;
Display *display;
XrmInitialize();
argDB = 0;
XrmParseCommand(&argDB, options, NELEM(options), myName, argcp, argvp);
for (i = 1; i < *argcp; i++)
{
if (argvp[i][0] == '-')
{
(void)fprintf(stderr, "Unknown option '%s'\n", argvp[i]);
(void)fprintf(stderr, "Type: %s -help to see a list of options\n",
ProgName);
Quit(1);
}
}
if (getResource(argDB, "help", NULL, ARG(resValue)))
{
usage();
Quit(1);
}
copyright();
if (getResource(argDB, "version", NULL, ARG(resValue)))
{
version();
Quit(1);
}
if (!getString(argDB, "display", NULL, &ptr) || !*ptr)
{
free(ptr);
#ifdef VMS
if ((ptr = getenv("DECW$DISPLAY")))
#else
if ((ptr = getenv("DISPLAY")))
#endif
{
(void)strncpy(displayName, ptr, MAX_DISP_LEN);
displayName[MAX_DISP_LEN - 1] = '\0';
}
else
{
#ifdef VMS
(void)strcpy(displayName, "::0.0");
(void)sprintf(displayName, "%s::0.0", host);
#else
(void)strcpy(displayName, ":0.0");
#endif
}
display = XOpenDisplay(displayName);
}
else
{
display = XOpenDisplay(ptr);
free(ptr);
}
if (!display)
{
Msg(M_PERR, "couldn't open display <%s>", displayName);
return NULL;
}
getFileDefaults(display, &rDB);
XrmMergeDatabases(argDB, &rDB);
#ifdef DEBUG
(void)getInteger(rDB, "debug", 0, (int *)&GETCFG(debug));
#endif
ptr = (char *)Malloc(strlen(LIBDIR) + 3, "GetResources");
(void)sprintf(ptr, ".:%s", LIBDIR);
(void)getString(rDB, "libDir", ptr, &GETCFG(libDir));
free(ptr);
(void)getBool(rDB, "quiet", "false", &GETCFG(quiet));
(void)getString(rDB, "geometry", "", &GETCFG(geometry));
(void)getBool(rDB, "monocrome", "false", &GETCFG(mono));
(void)getBool(rDB, "private", "false", &GETCFG(private));
#ifdef HAVE_MITSHM
(void)getBool(rDB, "mitshm", "true", &GETCFG(mitshm));
#endif
(void)getBool(rDB, "xsync", "false", &GETCFG(xsync));
(void)getString(rDB, "machine", "48", &GETCFG(_machine.s));
for (i = 0; i < NELEM(mach2str); i++)
{
if (!strcasecmp(GETCFG(_machine.s), mach2str[i]))
{
free(GETCFG(_machine.s));
SETCFG(machine, i);
goto found_machine;
}
}
Msg(M_WARN, "invalid emulation mode %s, using 48", GETCFG(_machine.s));
free(GETCFG(_machine.s));
SETCFG(machine, SP_48_3);
found_machine:
(void)getInteger(rDB, "speed", 100, &GETCFG(speed));
if (GETCFG(speed) < 0 || GETCFG(speed) > 200)
{
Msg(M_WARN, "speed value out of range, setting to default 100%");
SETCFG(speed, 100);
}
(void)getBool(rDB, "fast", "false", &GETCFG(fast));
(void)getInteger(rDB, "scale", 1, &GETCFG(scale));
if (GETCFG(scale) < 1 || GETCFG(scale) > 3)
{
Msg(M_WARN, "scale factor out of range, setting to default 1");
SETCFG(scale, 1);
}
(void)getInteger(rDB, "refresh", 3, &GETCFG(refresh));
if (GETCFG(refresh) < 1 || GETCFG(refresh) > 50)
{
Msg(M_WARN, "refresh rate out of range, setting to default 3");
SETCFG(refresh, 3);
}
(void)getBool(rDB, "cache", "true", &GETCFG(cache));
#ifdef SPEAKER_AUDIO
(void)getBool(rDB, "noise", "false", &GETCFG(noise));
#endif
#ifdef JOY
(void)getBool(rDB, "joystick", "false", &GETCFG(joyActive));
(void)getString(rDB, "joyDev", "/dev/js0", &GETCFG(joyDevice));
(void)getInteger(rDB, "tolerance", 20, &GETCFG(joyTolerance));
if (GETCFG(joyTolerance) < 1 || GETCFG(joyTolerance) > 500)
{
Msg(M_WARN, "joystick tolerance out of range, setting to default 20");
SETCFG(joyTolerance, 20);
}
(void)getInteger(rDB, "autofire", 25, &GETCFG(joyAutofire));
if (GETCFG(joyAutofire) < 1 || GETCFG(joyAutofire) > 50)
{
Msg(M_WARN, "autofire speed out of range, setting to default 25");
SETCFG(joyAutofire, 25);
}
(void)getInteger(rDB, "juggle", 25, &GETCFG(joyJuggle));
if (GETCFG(joyJuggle) < 1 || GETCFG(joyJuggle) > 50)
{
Msg(M_WARN, "juggle speed out of range, setting to default 25");
SETCFG(joyJuggle, 25);
}
#endif
for (i = KM_JOY_UP; i <= KM_JOY_FIRE; i++)
{
(void)getString(rDB, mapTab[i].res_name, mapTab[i].def_keysym, &ptr);
SETCFG(joyKeys[i], XStringToKeysym(ptr));
if (GETCFG(joyKeys[i]) == NoSymbol)
{
Msg(M_WARN, "unknown keysym <%s> found, using <%s>", ptr,
mapTab[i].def_keysym);
SETCFG(joyKeys[i], XStringToKeysym(mapTab[i].def_keysym));
}
free(ptr);
}
#ifdef AUDIO
(void)getBool(rDB, "sound", "false", &GETCFG(audioActive));
#if defined(SPEAKER_AUDIO) || defined(AYCHIP_AUDIO)
#ifdef OSS_AUDIO
(void)getString(rDB, "audioDev", "/dev/dsp", &GETCFG(audioDevice));
#else
(void)getString(rDB, "audioDev", "/dev/audio", &GETCFG(audioDevice));
#endif
(void)getInteger(rDB, "sample", 8000, &GETCFG(audioSample));
if (GETCFG(audioSample) < 8000 || GETCFG(audioSample) > 48000)
{
Msg(M_WARN, "audio sample rate out of range, setting to default 8000");
SETCFG(audioSample, 8000);
}
#endif
#ifdef XBELL_AUDIO
(void)getInteger(rDB, "volume", 50, &GETCFG(audioVolume));
if (GETCFG(audioVolume) > 100 || GETCFG(audioVolume) < 0)
{
Msg(M_WARN, "audio volume out of range, setting to default 50");
SETCFG(audioVolume, 50);
}
#endif
#endif
(void)getString(rDB, "rom48", "spectrum.rom", &GETCFG(sp48Rom));
(void)getInteger(rDB, "issue", 3, &GETCFG(issue));
if (GETCFG(issue) != 2 && GETCFG(issue) != 3)
{
Msg(M_WARN, "invalid issue type %d, using 3", GETCFG(issue));
SETCFG(issue, 3);
}
if (GETCFG(issue) == 2 && GETCFG(machine) == SP_48_3)
{
SETCFG(machine, SP_48_2);
}
(void)getString(rDB, "kbdlayout", "keyboard.scr", &GETCFG(kbdlayout));
(void)getString(rDB, "rom128", "128.rom", &GETCFG(sp128Rom));
#ifdef XZX_PLUS3
(void)getString(rDB, "rompl3", "plus3.rom", &GETCFG(plus3Rom));
(void)getString(rDB, "fda", "diska.dsk", &GETCFG(disks[0]));
(void)getString(rDB, "fdb", "diskb.dsk", &GETCFG(disks[1]));
#endif
#ifdef XZX_PENTAGON
(void)getString(rDB, "pentRom", "pentagon.rom", &GETCFG(pentRom));
#endif
#ifdef XZX_SCORPION
(void)getString(rDB, "scorRom", "scorpion.rom", &GETCFG(scorRom));
#endif
#ifdef XZX_IF1
(void)getBool(rDB, "if1", "true", &GETCFG(if1Active));
(void)getBool(rDB, "crlf", "false", &GETCFG(if1TranslateNl));
(void)getBool(rDB, "strcr", "false", &GETCFG(if1StripNl));
(void)getString(rDB, "if1Rom", "if1.rom", &GETCFG(if1Rom));
for (i = 0; i < IF1_DRIVES; i++)
{
char resname[3]; char resvalue[10];
(void)sprintf(resname, "m%d", i + 1);
(void)sprintf(resvalue, "cart%d.mdr", i + 1);
(void)getString(rDB, resname, resvalue, &GETCFG(if1Carts[i]));
}
#endif
#ifdef XZX_MF
(void)getBool(rDB, "mf", "false", &GETCFG(mfActive));
(void)getString(rDB, "mf128Rom", "mf128.rom", &GETCFG(mf128Rom));
#ifdef XZX_PLUS3
(void)getString(rDB, "mf3Rom", "mf3.rom", &GETCFG(mf3Rom));
#endif
#endif
#ifdef XZX_KMOUSE
(void)getBool(rDB, "kmouse", "false", &GETCFG(kmouseActive));
#ifdef XZX_PLUS3
if (GETCFG(kmouseActive) && GETCFG(machine) <= SP_3)
#else
if (GETCFG(kmouseActive) && GETCFG(machine) <= SP_128)
#endif
{
Msg(M_INFO, "Kempston Mouse not supported by the %s, disabling",
mach2str[GETCFG(machine)]);
SETCFG(kmouseActive, 0);
}
(void)getBool(rDB, "grab", "false", &GETCFG(kmouseGrab));
#endif
#ifdef DEBUG
if (GETCFG(debug) & D_X11)
{
printResources();
}
#endif
OnQuit(saveResources);
XrmDestroyDatabase(rDB);
return display;
}
static void
copyright(void)
{
(void)fprintf(stderr,
"XZX is copyright (c) 1993,1994 Des Herriott\n"
"                 (c) 1995-1999 Erik Kunze\n"
"XZX comes with no warranty; see the file COPYRIGHT for details.\n\n"
"If you use XZX regulary please send a picture postcard to:\n"
"    Erik Kunze, Nebelhornstrasse 30, D-82223 Eichenau, Germany\n\n");
}
static void
usage(void)
{
(void)fprintf(stderr, "Usage: %s [options] [snapshot file]\n", ProgName);
(void)fprintf(stderr, "Available options:\n"
"  -help                 display this message\n"
"  -version              display version number and compile-time options\n"
"  -libDir <path>        specify library search path\n"
"  -quiet <bool>         suppress all non-error messages\n"
"  -display <display>    specify X display\n"
"  -geometry <geospec>   specify window position\n"
"  -mono <bool>          use only black and white\n"
"  -private <bool>       use a private colormap\n"
#ifdef HAVE_MITSHM
"  -mitshm <bool>        enable MIT-SHM\n"
#endif
"  -xsync <bool>         use XSync screen refresh method\n"
#ifdef DEBUG
"  -debug <n>            specify the debug level\n"
#endif
"  -machine <type>       emulate the specified Spectrum type\n"
"  -speed <n>            maximum speed of emulated Spectrum\n"
"  -fast <bool>          run in FAST mode\n"
"  -scale <n>            Spectrum to X screen scaling factor\n"
"  -refresh <n>          refresh screen every <n> frames\n"
"  -cache <bool>         cache screen changes\n"
#ifdef SPEAKER_AUDIO
"  -noise <bool>         produce noise while loading from tape\n"
#endif
"  -joyUp <keysym>       define key for joystick up\n"
"  -joyDown <keysym>     define key for joystick down\n"
"  -joyLeft <keysym>     define key for joystick left\n"
"  -joyRight <keysym>    define key for joystick right\n"
"  -joyFire <keysym>     define key for joystick fire\n"
#ifdef JOY
"  -joystick <bool>      enable/disable analogue joystick\n"
"  -joyDev <path>        specify joystick device\n"
"  -tolerance <int>      specify displacement tolerance\n"
"  -autofire <int>       specify autofire speed\n"
"  -juggle <int>         specify juggle speed\n"
#endif
#ifdef AUDIO
"  -sound <bool>         enable/disable sound\n"
#if defined(SPEAKER_AUDIO) || defined(AYCHIP_AUDIO)
"  -audioDev <path>      specify the audio device file name\n"
"  -sample <n>           specify audio sample rate (Hz)\n"
#endif
#ifdef XBELL_AUDIO
"  -volume <n>           specify audio volume as a percentage\n"
#endif
#endif
"  -rom48 <fname>        specify the file to use as 48K ROM image\n"
"  -issue [2|3]          emulate specified issue on 48K Spectrums\n"
"  -kbdlayout <fname>    specify the file with keybord layout to use\n"
"  -rom128 <fname>       specify the file to use as 128K ROM image\n"
#ifdef XZX_PLUS3
"  -rompl3 <fname>       specify the file to use as +3 ROM image\n"
"  -fd{ab} <fname>       link the specified file to virtual disk drives\n"
#endif
#ifdef XZX_PENTAGON
"  -pentRom <fname>      specify the file to use as Pentagon ROM image\n"
#endif
#ifdef XZX_SCORPION
"  -scorRom <fname>      specify the file to use as Scorpion ROM image\n"
#endif
#ifdef XZX_IF1
"  -if1 <bool>           enable Interface I\n"
"  -if1Rom <path>        specify the file to use as Interface I ROM image\n"
"  -crlf <bool>          enable CR/LF translation on RS232 input\n"
"  -strcr <bool>         strip CR on RS232 output\n"
"  -m{n} <path>          link the specified file to virtual microdrives\n"
#endif
#ifdef XZX_MF
"  -mf <bool>            enable Multiface\n"
"  -mf128Rom <path>      specify the file to use as Multiface 128 ROM image\n"
#ifdef XZX_PLUS3
"  -mf3Rom <path>        specify the file to use as Multiface 3 ROM image\n"
#endif
#endif
#ifdef XZX_KMOUSE
"  -kmouse <bool>        enable Kempston Mouse\n"
"  -grab <bool>          grab X pointer\n"
#endif
"\n"
#ifdef XZX_IF1
"Microdrive emulation reads and writes .MDR files.\n"
#endif
"Tape emulation reads .TAP and .TZX files and writes .TAP files.\n"
#ifdef XZX_PLUS3
"Disk emulation reads and writes .DSK files.\n"
#endif
"XZX reads and writes .SNA, .Z80, .SLT and .DAT format snapshots.\n");
}
static void
version(void)
{
(void)fprintf(stderr, "This is %s", Version);
(void)fprintf(stderr, " with the following compile time options:\n"
" *  XZX is built for a"
#ifndef WORDS_BIGENDIAN
" little-endian architecture.\n"
#else
" big-endian architecture.\n"
#endif
#ifdef HAVE_MITSHM
" *  MIT-SHM image transfer is possible.\n"
#endif
#ifdef JOY
" *  Analogue joystick emulation is possible.\n"
#endif
#ifdef SPEAKER_AUDIO
" *  Speaker audio emulation is enabled.\n"
#endif
#ifdef AYCHIP_AUDIO
" *  AY-8912 audio emulation is enabled.\n"
#endif
#ifdef XBELL_AUDIO
" *  BEEP emulation via X server bell is enabled.\n"
#endif
#ifdef XZX_PLUS3
" *  Spectrum +3 emulation is enabled.\n"
#endif
#ifdef XZX_PENTAGON
" *  Pentagon emulation is enabled.\n"
#endif
#ifdef XZX_SCORPION
" *  Scorpion emulation is enabled.\n"
#endif
#ifdef XZX_IF1
" *  Interface 1, microdrive & RS232 emulation are enabled.\n"
#endif
#ifdef XZX_MF
" *  Multiface emulation is enabled.\n"
#endif
#ifdef XZX_KMOUSE
" *  Kempston Mouse emulation is enabled.\n"
#endif
#ifdef PSEUDO_IO
" *  Character input/output is emulated via ports.\n"
#endif
#ifdef DEBUG
" *  Debugging is possible.\n"
#endif
);
}
#ifdef DEBUG
static void
printResources(void)
{
#ifdef XZX_IF1
int i;
#endif
Msg(M_DEBUG, "libDir        : %s", GETCFG(libDir));
Msg(M_DEBUG, "quiet         : %s", BOOL(GETCFG(quiet)));
Msg(M_DEBUG, "geometry      : %s", GETCFG(geometry));
Msg(M_DEBUG, "mono          : %s", BOOL(GETCFG(mono)));
Msg(M_DEBUG, "private       : %s", BOOL(GETCFG(private)));
#ifdef HAVE_MITSHM
Msg(M_DEBUG, "mitshm        : %s", BOOL(GETCFG(mitshm)));
#endif
Msg(M_DEBUG, "xsync         : %s", BOOL(GETCFG(xsync)));
#ifdef DEBUG
Msg(M_DEBUG, "debug         : %u", GETCFG(debug));
#endif
Msg(M_DEBUG, "machine       : %s", mach2str[GETCFG(machine)]);
Msg(M_DEBUG, "speed         : %d", GETCFG(speed));
Msg(M_DEBUG, "fast          : %s", BOOL(GETCFG(fast)));
Msg(M_DEBUG, "scale         : %d", GETCFG(scale));
Msg(M_DEBUG, "refresh       : %d", GETCFG(refresh));
Msg(M_DEBUG, "cache         : %s", BOOL(GETCFG(cache)));
#ifdef SPEAKER_AUDIO
Msg(M_DEBUG, "noise         : %s", BOOL(GETCFG(noise)));
#endif
Msg(M_DEBUG, "joyUp         : %s", KEY(GETCFG(joyUp)));
Msg(M_DEBUG, "joyDown       : %s", KEY(GETCFG(joyDown)));
Msg(M_DEBUG, "joyLeft       : %s", KEY(GETCFG(joyLeft)));
Msg(M_DEBUG, "joyRight      : %s", KEY(GETCFG(joyRight)));
Msg(M_DEBUG, "joyFire       : %s", KEY(GETCFG(joyFire)));
#ifdef JOY
Msg(M_DEBUG, "joystick      : %s", BOOL(GETCFG(joyActive)));
Msg(M_DEBUG, "joyDev        : %s", GETCFG(joyDevice));
Msg(M_DEBUG, "joyTolerance  : %d", GETCFG(joyTolerance));
Msg(M_DEBUG, "joyAutofire   : %d", GETCFG(joyAutofire));
Msg(M_DEBUG, "joyJuggle     : %d", GETCFG(joyJuggle));
#endif
#ifdef AUDIO
Msg(M_DEBUG, "sound         : %s", BOOL(GETCFG(audioActive)));
#if defined(SPEAKER_AUDIO) || defined(AYCHIP_AUDIO)
Msg(M_DEBUG, "audioDev      : %s", GETCFG(audioDevice));
Msg(M_DEBUG, "sample        : %u", GETCFG(audioSample));
#endif
#ifdef XBELL_AUDIO
Msg(M_DEBUG, "volume        : %d", GETCFG(audioVolume));
#endif
#endif
Msg(M_DEBUG, "rom48         : %s", GETCFG(sp48Rom));
Msg(M_DEBUG, "issue         : %d", GETCFG(issue));
Msg(M_DEBUG, "kbdlayout     : %s", GETCFG(kbdlayout));
Msg(M_DEBUG, "rom128        : %s", GETCFG(sp128Rom));
#ifdef XZX_PLUS3
Msg(M_DEBUG, "rompl3        : %s", GETCFG(plus3Rom));
Msg(M_DEBUG, "fda           : %s", GETCFG(disks[0]));
Msg(M_DEBUG, "fdb           : %s", GETCFG(disks[1]));
#endif
#ifdef XZX_PENTAGON
Msg(M_DEBUG, "pentRom       : %s", GETCFG(pentRom));
#endif
#ifdef XZX_SCORPION
Msg(M_DEBUG, "scorRom       : %s", GETCFG(scorRom));
#endif
#ifdef XZX_IF1
Msg(M_DEBUG, "if1           : %s", BOOL(GETCFG(if1Active)));
Msg(M_DEBUG, "if1Rom        : %s", GETCFG(if1Rom));
Msg(M_DEBUG, "crlf          : %s", BOOL(GETCFG(if1TranslateNl)));
Msg(M_DEBUG, "strcr         : %s", BOOL(GETCFG(if1StripNl)));
for (i = 0; i < IF1_DRIVES; i++)
{
Msg(M_DEBUG, "m%d            : %s", i,  GETCFG(if1Carts[i]));
}
#endif
#ifdef XZX_MF
Msg(M_DEBUG, "mf            : %s", BOOL(GETCFG(mfActive)));
Msg(M_DEBUG, "mf128Rom      : %s", GETCFG(mf128Rom));
#ifdef XZX_PLUS3
Msg(M_DEBUG, "mf3Rom        : %s", GETCFG(mf3Rom));
#endif
#endif
#ifdef XZX_KMOUSE
Msg(M_DEBUG, "kmouse        : %s", BOOL(GETCFG(kmouseActive)));
Msg(M_DEBUG, "grab          : %s", BOOL(GETCFG(kmouseGrab)));
#endif
}
#endif
static void
saveResources(void)
{
FILE *fp;
char path[MAXPATHLEN];
char *home = getenv("HOME");
#if defined(XZX_IF1) || defined(XZX_PLUS3)
int i;
char *file;
#endif
if (!home)
{
Msg(M_WARN, "environment variable HOME is not set");
return;
}
(void)sprintf(path, "%s/%s", home, RESOURCE_FILE);
if (!(fp = Fopen(path, "wb")))
{
Msg(M_PERR, "couldn't open <%s> for writing", path);
return;
}
(void)fprintf(fp,
"! XZX Preferences File\n"
"! Version: " VERSION " (" HOST ")\n"
"! This is a generated file!  Do not edit.\n\n");
(void)fprintf(fp, "Xzx*libDir    : %s\n", GETCFG(libDir));
(void)fprintf(fp, "Xzx*quiet     : %s\n", BOOL(GETCFG(quiet)));
(void)fprintf(fp, "Xzx*monocrome : %s\n", BOOL(GETCFG(mono)));
(void)fprintf(fp, "Xzx*private   : %s\n", BOOL(GETCFG(private)));
#ifdef HAVE_MITSHM
(void)fprintf(fp, "Xzx*mitshm    : %s\n", BOOL(GETCFG(mitshm)));
#endif
(void)fprintf(fp, "Xzx*xsync     : %s\n", BOOL(GETCFG(xsync)));
#ifdef DEBUG
(void)fprintf(fp, "Xzx*debug     : %u\n", GETCFG(debug));
#endif
(void)fprintf(fp, "Xzx*machine   : %s\n", mach2str[GETCFG(machine)]);
(void)fprintf(fp, "Xzx*speed     : %d\n", GETCFG(speed));
(void)fprintf(fp, "Xzx*fast      : %s\n", BOOL(GETCFG(fast)));
(void)fprintf(fp, "Xzx*scale     : %d\n", GETCFG(scale));
(void)fprintf(fp, "Xzx*refresh   : %d\n", GETCFG(refresh));
(void)fprintf(fp, "Xzx*cache     : %s\n", BOOL(GETCFG(cache)));
#ifdef SPEAKER_AUDIO
(void)fprintf(fp, "Xzx*noise     : %s\n", BOOL(GETCFG(noise)));
#endif
(void)fprintf(fp, "Xzx*joyUp     : %s\n", KEY(GETCFG(joyUp)));
(void)fprintf(fp, "Xzx*joyDown   : %s\n", KEY(GETCFG(joyDown)));
(void)fprintf(fp, "Xzx*joyLeft   : %s\n", KEY(GETCFG(joyLeft)));
(void)fprintf(fp, "Xzx*joyRight  : %s\n", KEY(GETCFG(joyRight)));
(void)fprintf(fp, "Xzx*joyFire   : %s\n", KEY(GETCFG(joyFire)));
#ifdef JOY
(void)fprintf(fp, "Xzx*joystick  : %s\n", BOOL(GETCFG(joyActive)));
(void)fprintf(fp, "Xzx*joyDev    : %s\n", GETCFG(joyDevice));
(void)fprintf(fp, "Xzx*tolerance : %d\n", GETCFG(joyTolerance));
(void)fprintf(fp, "Xzx*autofire  : %d\n", GETCFG(joyAutofire));
(void)fprintf(fp, "Xzx*juggle    : %d\n", GETCFG(joyJuggle));
#endif
#ifdef AUDIO
(void)fprintf(fp, "Xzx*sound     : %s\n", BOOL(GETCFG(audioActive)));
#if defined(SPEAKER_AUDIO) || defined(AYCHIP_AUDIO)
(void)fprintf(fp, "Xzx*audioDev  : %s\n", GETCFG(audioDevice));
(void)fprintf(fp, "Xzx*sample    : %u\n", GETCFG(audioSample));
#endif
#ifdef XBELL_AUDIO
(void)fprintf(fp, "Xzx*volume    : %d\n", GETCFG(audioVolume));
#endif
#endif
(void)fprintf(fp, "Xzx*rom48     : %s\n", GETCFG(sp48Rom));
(void)fprintf(fp, "Xzx*issue     : %d\n", GETCFG(issue));
(void)fprintf(fp, "Xzx*kbdlayout : %s\n", GETCFG(kbdlayout));
(void)fprintf(fp, "Xzx*rom128    : %s\n", GETCFG(sp128Rom));
#ifdef XZX_PLUS3
(void)fprintf(fp, "Xzx*rompl3    : %s\n", GETCFG(plus3Rom));
for (i = 0; i < NELEM(Conf.disks); i++)
{
if ((file = FdcDiskName(i)))
{
(void)fprintf(fp, "Xzx*fd%c       : %s\n", (char)('a' + i), file);
}
}
#endif
#ifdef XZX_PENTAGON
(void)fprintf(fp, "Xzx*pentRom   : %s\n", GETCFG(pentRom));
#endif
#ifdef XZX_SCORPION
(void)fprintf(fp, "Xzx*scorRom   : %s\n", GETCFG(scorRom));
#endif
#ifdef XZX_IF1
(void)fprintf(fp, "Xzx*if1       : %s\n", BOOL(GETCFG(if1Active)));
(void)fprintf(fp, "Xzx*if1Rom    : %s\n", GETCFG(if1Rom));
(void)fprintf(fp, "Xzx*crlf      : %s\n", BOOL(GETCFG(if1TranslateNl)));
(void)fprintf(fp, "Xzx*strcr     : %s\n", BOOL(GETCFG(if1StripNl)));
for (i = 0; i < IF1_DRIVES; i++)
{
if ((file = If1CartName(i)))
{
(void)fprintf(fp, "Xzx*m%d        : %s\n", i, file);
}
}
#endif
#ifdef XZX_MF
(void)fprintf(fp, "Xzx*mf        : %s\n", BOOL(GETCFG(mfActive)));
(void)fprintf(fp, "Xzx*mf128Rom  : %s\n", GETCFG(mf128Rom));
#ifdef XZX_PLUS3
(void)fprintf(fp, "Xzx*mf3Rom    : %s\n", GETCFG(mf3Rom));
#endif
#endif
#ifdef XZX_KMOUSE
(void)fprintf(fp, "Xzx*kmouse    : %s\n", BOOL(GETCFG(kmouseActive)));
(void)fprintf(fp, "Xzx*grab      : %s\n", BOOL(GETCFG(kmouseGrab)));
#endif
(void)fprintf(fp, "\n! EOF\n");
(void)fclose(fp);
}
