/********************************************************************************
* Copyright (c) Des Herriott 1993, 1994
*               Erik Kunze   1995 - 1999
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Authors: Des Herriott
*          Erik Kunze
*******************************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#ifndef lint
static char rcsid[] = "$Id: screen.c,v 4.38 1999/04/08 09:51:11 erik Rel $";
#endif
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#ifdef HAVE_MITSHM
#include <sys/ipc.h>
#include <sys/shm.h>
#include <X11/extensions/XShm.h>
#if defined(nec_ews) && !defined(__STDC__)
void *shmat(int, void*, int);
#endif
#endif
#ifdef OFFIX_DND
#include <OffiX/DragAndDropTypes.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "debug.h"
#include "resource.h"
#include "mem.h"
#include "io.h"
#include "util.h"
#include "dialog.h"
#include "keyboard.h"
#ifdef XZX_KMOUSE
#include "kmouse.h"
#endif
#include "machine.h"
#include "main.h"
#include "sbar.h"
#include "tables.h"
#ifdef OFFIX_DND
#include "snapshot.h"
#endif
#include "screen.h"
#include "xzx.icon"
#define BORDER_8x1		(1 * BORDER_PIXELS / sizeof(uns32) * sizeof(uns8))
#define SCREEN_8x1		(1 * X_PIXELS / sizeof(uns32) * sizeof(uns8))
#define HSIZE_8x1		(1 * BORDER_8x1 + SCREEN_8x1 + BORDER_8x1)
#define BORDER_8x2		(2 * BORDER_PIXELS / sizeof(uns32) * sizeof(uns8))
#define SCREEN_8x2		(2 * X_PIXELS / sizeof(uns32) * sizeof(uns8))
#define HSIZE_8x2		(2 * HSIZE_8x1)
#define BORDER_8x3		(3 * BORDER_PIXELS / sizeof(uns32) * sizeof(uns8))
#define SCREEN_8x3		(3 * X_PIXELS / sizeof(uns32) * sizeof(uns8))
#define HSIZE_8x3		(3 * HSIZE_8x1)
#define BORDER_16x1		(1 * BORDER_PIXELS / sizeof(uns32) * sizeof(uns16))
#define SCREEN_16x1		(1 * X_PIXELS / sizeof(uns32) * sizeof(uns16))
#define HSIZE_16x1		(1 * BORDER_16x1 + SCREEN_16x1 + BORDER_16x1)
#define BORDER_16x2		(2 * BORDER_PIXELS / sizeof(uns32) * sizeof(uns16))
#define SCREEN_16x2		(2 * X_PIXELS / sizeof(uns32) * sizeof(uns16))
#define HSIZE_16x2		(2 * HSIZE_16x1)
#define BORDER_16x3		(3 * BORDER_PIXELS / sizeof(uns32) * sizeof(uns16))
#define SCREEN_16x3		(3 * X_PIXELS / sizeof(uns32) * sizeof(uns16))
#define HSIZE_16x3		(3 * HSIZE_16x1)
#define BORDER_24x1		(1 * BORDER_PIXELS / sizeof(uns32) * 3)
#define SCREEN_24x1		(1 * X_PIXELS / sizeof(uns32) * 3)
#define HSIZE_24x1		(1 * BORDER_24x1 + SCREEN_24x1 + BORDER_24x1)
#define BORDER_24x2		(2 * BORDER_PIXELS / sizeof(uns32) * 3)
#define SCREEN_24x2		(2 * X_PIXELS / sizeof(uns32) * 3)
#define HSIZE_24x2		(2 * HSIZE_24x1)
#define BORDER_24x3		(3 * BORDER_PIXELS / sizeof(uns32) * 3)
#define SCREEN_24x3		(3 * X_PIXELS / sizeof(uns32) * 3)
#define HSIZE_24x3		(3 * HSIZE_24x1)
#define BORDER_32x1		(1 * BORDER_PIXELS / sizeof(uns32) * sizeof(uns32))
#define SCREEN_32x1		(1 * X_PIXELS / sizeof(uns32) * sizeof(uns32))
#define HSIZE_32x1		(1 * BORDER_32x1 + SCREEN_32x1 + BORDER_32x1)
#define BORDER_32x2		(2 * BORDER_PIXELS / sizeof(uns32) * sizeof(uns32))
#define SCREEN_32x2		(2 * X_PIXELS / sizeof(uns32) * sizeof(uns32))
#define HSIZE_32x2		(2 * HSIZE_32x1)
#define BORDER_32x3		(3 * BORDER_PIXELS / sizeof(uns32) * sizeof(uns32))
#define SCREEN_32x3		(3 * X_PIXELS / sizeof(uns32) * sizeof(uns32))
#define HSIZE_32x3		(3 * HSIZE_32x1)
typedef struct { uns32 l[ 1]; }	_C8x1;
typedef struct { uns32 l[ 2]; }	_C8x2;
typedef struct { uns32 l[ 3]; }	_C8x3;
typedef struct { uns32 l[ 2]; }	_C16x1;
typedef struct { uns32 l[ 4]; }	_C16x2;
typedef struct { uns32 l[ 6]; }	_C16x3;
typedef struct { uns32 l[ 3]; }	_C24x1;
typedef struct { uns32 l[ 6]; }	_C24x2;
typedef struct { uns32 l[ 9]; }	_C24x3;
typedef struct { uns32 l[ 4]; }	_C32x1;
typedef struct { uns32 l[ 8]; }	_C32x2;
typedef struct { uns32 l[12]; }	_C32x3;
#define	EXPAND_BOX_X(x)	{ \
if ((x) < xMin) xMin = (x);						\
if ((x) > xMax) xMax = (x);						\
}
#define	EXPAND_BOX_Y(y)	{ \
if ((y) < yMin) yMin = (y);						\
if ((y) > yMax) yMax = (y);						\
}
#define MINIMIZE_BOX()	{ \
xMax = 0;										\
yMax = 0;										\
xMin = COLS - 1;								\
yMin = Y_PIXELS - 1;							\
}
#define UPDATE_IMAGE(x,y,w,h) \
putImage(Dpy, mainWin, gc, xim,						\
x, y, x, y, w, h, False);
#ifdef WORDS_BIGENDIAN
#define WRITE24BIT(p,b1,b2,b3) \
*(p)++ = (b3); *(p)++ = (b2); *(p)++ = (b1);
#else
#define WRITE24BIT(p,b1,b2,b3) \
*(p)++ = (b1); *(p)++ = (b2); *(p)++ = (b3);
#endif
#define NELEM(a)		(sizeof(a) / sizeof(a[0]))
#ifdef DEBUG
#define DEB(x)			{ if (GETCFG(debug) & D_X11) { x } }
#else
#define DEB(x)
#endif
static void quitX(void);
static void notifyWm(int *, char **);
static void calcWinPosition(int *, int *);
static void initColors(void);
static void destroyColors(void);
static void initImage(void);
static void destroyImage(void);
#ifdef HAVE_MITSHM
static int catchAttachError(Display *, XErrorEvent *);
#endif
static void initTables(void);
static void destroyTables(void);
static void processConfigure(XEvent *);
static void scrLine8x1(short);
static void scrLine8x2(short);
static void scrLine8x3(short);
static void scrLine16x1(short);
static void scrLine16x2(short);
static void scrLine16x3(short);
static void scrLine24x1(short);
static void scrLine24x2(short);
static void scrLine24x3(short);
static void scrLine32x1(short);
static void scrLine32x2(short);
static void scrLine32x3(short);
Display *Dpy;
void (*UpdateLine)(short);
static Screen *screen;
static Window root, mainWin;
static unsigned long white, black;
static Visual *visual;
static unsigned int depth;
static int bytesPerPixel, bitsPerPixel;
static Colormap cmap = (Colormap)0;
static GC gc = (GC)0;
static XImage *xim = (XImage *)0;
static void (*putImage)();
#ifdef HAVE_MITSHM
static XShmSegmentInfo xshminfo;
static int attachError;
static int (*oldErrorHandler)(Display *, XErrorEvent *);
#endif
static Atom deleteAtom;
#ifdef OFFIX_DND
static Atom dndProtocol;
static Atom dndSelection;
#endif
static unsigned int hsize, vsize;
static struct { unsigned short x, y; } sizes[3];
static uns32 *xImagePtr;
static void *pix2color[16];
static unsigned long border;
static int borderChanged = 0;
static int borderUpdate;
static uns32 screenChanged[Y_PIXELS];
static int screenUpdate;
static int xMin, xMax, yMin, yMax;
static void (*updateLine[][3])(short) = {
{ scrLine8x1,  scrLine8x2,  scrLine8x3  },
{ scrLine16x1, scrLine16x2, scrLine16x3 },
{ scrLine24x1, scrLine24x2, scrLine24x3 },
{ scrLine32x1, scrLine32x2, scrLine32x3 }
};
static unsigned short rgbVals[NCOLORS][3] = {
{ 0x0000, 0x0000, 0x0000 },
{ 0x0000, 0x0000, 0xbfff },
{ 0xbfff, 0x0000, 0x0000 },
{ 0xbfff, 0x0000, 0xbfff },
{ 0x0000, 0xbfff, 0x0000 },
{ 0x0000, 0xbfff, 0xbfff },
{ 0xbfff, 0xbfff, 0x0000 },
{ 0xbfff, 0xbfff, 0xbfff },
{ 0x0000, 0x0000, 0x0000 },
{ 0x0000, 0x0000, 0xffff },
{ 0xffff, 0x0000, 0x0000 },
{ 0xffff, 0x0000, 0xffff },
{ 0x0000, 0xffff, 0x0000 },
{ 0x0000, 0xffff, 0xffff },
{ 0xffff, 0xffff, 0x0000 },
{ 0xffff, 0xffff, 0xffff },
};
static unsigned long colors[NCOLORS];
static unsigned long ink[FLASH];
static unsigned long paper[FLASH];
static int flashPhase = 0;
void
InitX(int *argcp, char **argvp)
{
int xpos, ypos, i;
if (!(Dpy = GetResources(argcp, argvp)))
{
Msg(M_FATAL, "couldn't connect to X display");
}
OnQuit(quitX);
screen = DefaultScreenOfDisplay(Dpy);
root = RootWindowOfScreen(screen);
white = WhitePixelOfScreen(screen);
black = BlackPixelOfScreen(screen);
for (i = GETCFG(scale); i > 1; i--)
{
if (DisplayWidth(Dpy, XScreenNumberOfScreen(screen)) >
i * (BORDER_PIXELS + X_PIXELS + BORDER_PIXELS)
&& DisplayHeight(Dpy, XScreenNumberOfScreen(screen)) >
i * (BORDER_PIXELS + Y_PIXELS + BORDER_PIXELS))
{
break;
}
}
SETCFG(scale, i);
hsize = i * (BORDER_PIXELS + X_PIXELS + BORDER_PIXELS);
vsize = i * (BORDER_PIXELS + Y_PIXELS + BORDER_PIXELS);
(void)memset(pix2color, 0, sizeof(pix2color));
{
int visuals[] = { PseudoColor, TrueColor, StaticGray };
int depths[] = { 8, 16, 32, 15, 24 };
XVisualInfo visualinfo;
int j;
for (i = 0; i < NELEM(depths); i++)
{
for (j = 0; j < NELEM(visuals); j++)
{
if (XMatchVisualInfo(Dpy, DefaultScreen(Dpy), depths[i],
visuals[j], &visualinfo))
{
DEB(Msg(M_DEBUG, "visual        : %s",
visuals[j] == PseudoColor ? "PseudoColor" :
visuals[j] == TrueColor   ? "TrueColor" :
"StaticGray");
Msg(M_DEBUG, "colorDepth    : %d",
visualinfo.depth););
goto found_visual;
}
}
}
Msg(M_FATAL, "couldn't detect supported visual");
found_visual:
visual = visualinfo.visual;
depth = (unsigned int)visualinfo.depth;
initColors();
}
{
XPixmapFormatValues *pixmaps;
int formats;
pixmaps = XListPixmapFormats(Dpy, &formats);
for (i = 0; i < formats; i++)
{
if (pixmaps[i].depth == depth)
{
if (pixmaps[i].bits_per_pixel == 8
|| pixmaps[i].bits_per_pixel == 16
|| pixmaps[i].bits_per_pixel == 24
|| pixmaps[i].bits_per_pixel == 32)
{
DEB(Msg(M_DEBUG, "bitsPerPixel  : %d",
pixmaps[i].bits_per_pixel););
goto found_pixmap;
}
}
}
Msg(M_FATAL, "couldn't detect supported pixmap format");
found_pixmap:
bitsPerPixel = pixmaps[i].bits_per_pixel;
XFree(pixmaps);
initImage();
}
DEB(Msg(M_DEBUG, "bitmapBitOrder: %s first",
BitmapBitOrder(Dpy) == LSBFirst ? "LSB" : "MSB");
Msg(M_DEBUG, "imageByteOrder: %s first",
ImageByteOrder(Dpy) == LSBFirst ? "LSB" : "MSB"););
switch (depth)
{
case 8:
bytesPerPixel = 1;
break;
case 15:
case 16:
bytesPerPixel = 2;
break;
case 24:
bytesPerPixel = xim->bits_per_pixel == 24 ? 3 : 4;
break;
case 32:
bytesPerPixel = 4;
break;
}
initTables();
{
XSetWindowAttributes attr;
unsigned long mask;
attr.event_mask = KeyPressMask | KeyReleaseMask |
ExposureMask | EnterWindowMask |
LeaveWindowMask | StructureNotifyMask;
attr.colormap = cmap;
attr.border_pixel = 0;
mask = CWEventMask | CWColormap | CWBorderPixel;
calcWinPosition(&xpos, &ypos);
mainWin = XCreateWindow(Dpy, root, xpos, ypos, hsize, vsize,
0, (signed int)depth, InputOutput, visual,
mask, &attr);
gc = XCreateGC(Dpy, mainWin, 0, NULL);
(void)XSetGraphicsExposures(Dpy, gc, False);
}
SbarCreate(mainWin);
for (i = 0; i < 3; i++)
{
sizes[i].x = (i + 1) * (BORDER_PIXELS + X_PIXELS + BORDER_PIXELS);
sizes[i].y = (i + 1) * (BORDER_PIXELS + Y_PIXELS + BORDER_PIXELS);
}
notifyWm(argcp, argvp);
(void)XMapRaised(Dpy, mainWin);
#ifdef XZX_KMOUSE
KmouseInit(mainWin);
#endif
}
static void
quitX(void)
{
destroyTables();
destroyImage();
destroyColors();
if (gc)
{
XFreeGC(Dpy, gc);
}
(void)XAutoRepeatOn(Dpy);
(void)XCloseDisplay(Dpy);
}
static void
notifyWm(int *argcnt, char **argvec)
{
XTextProperty appName, iconName;
Pixmap iconPix;
XSizeHints xsh;
XWMHints xwmh;
XClassHint xch;
if (!XStringListToTextProperty((char **)&Version, 1, &appName)
|| !XStringListToTextProperty((char **)&Version, 1, &iconName))
{
Msg(M_PERR, "XStringListToTextProperty failed");
return;
}
iconPix = XCreatePixmapFromBitmapData(Dpy, root, (char *)xzx_bits,
xzx_width, xzx_height,
black, white,
depth);
xsh.flags = PMinSize | PMaxSize | PResizeInc | PAspect | PBaseSize |
(strlen(GETCFG(geometry)) > 0 ? USPosition : PPosition);
xsh.min_width  = sizes[0].x;
xsh.min_height = sizes[0].y;
xsh.max_width = sizes[2].x;
xsh.max_height = sizes[2].y;
xsh.width_inc = BORDER_PIXELS + X_PIXELS + BORDER_PIXELS;
xsh.height_inc = BORDER_PIXELS + Y_PIXELS + BORDER_PIXELS;
xsh.min_aspect.x = BORDER_PIXELS + X_PIXELS + BORDER_PIXELS;
xsh.min_aspect.y = BORDER_PIXELS + Y_PIXELS + BORDER_PIXELS;;
xsh.max_aspect.x = BORDER_PIXELS + X_PIXELS + BORDER_PIXELS;
xsh.max_aspect.y = BORDER_PIXELS + Y_PIXELS + BORDER_PIXELS;;
xsh.base_width = 0;
xsh.base_height = 0;
xwmh.initial_state = NormalState;
xwmh.input = True;
xwmh.icon_pixmap = iconPix;
xwmh.flags = StateHint | IconPixmapHint | InputHint;
xch.res_name = (char *)"xzx";
xch.res_class = (char *)"Xzx";
XSetWMProperties(Dpy, mainWin, &appName, &iconName, argvec, *argcnt,
&xsh, &xwmh, &xch);
(void)XFree(appName.value);
(void)XFree(iconName.value);
deleteAtom = XInternAtom(Dpy, "WM_DELETE_WINDOW", False);
(void)XSetWMProtocols(Dpy, mainWin, &deleteAtom, 1);
#ifdef OFFIX_DND
dndProtocol  = XInternAtom(Dpy, "_DND_PROTOCOL", False);
dndSelection = XInternAtom(Dpy, "_DND_SELECTION", False);
#endif
}
static void
calcWinPosition(int *x, int *y)
{
int tmpX, tmpY;
unsigned int w, h;
int mask;
*x = 0;
*y = 0;
if (!GETCFG(geometry)[0])
{
return;
}
mask = XParseGeometry(GETCFG(geometry), &tmpX, &tmpY, &w, &h);
if (!mask)
{
Msg(M_WARN, "invalid geometry specification <%s>", GETCFG(geometry));
SETCFG(geometry[0], '\0');
return;
}
if (mask & XValue)
{
*x = (mask & XNegative) ?
DisplayWidth(Dpy, XScreenNumberOfScreen(screen)) + tmpX - hsize :
tmpX;
}
if (mask & YValue)
{
*y = (mask & YNegative) ?
DisplayHeight(Dpy, XScreenNumberOfScreen(screen)) + tmpY - vsize :
tmpY;
}
}
static void
initColors(void)
{
XColor xc;
int i;
if (visual != DefaultVisualOfScreen(screen)
|| depth != DefaultDepthOfScreen(screen))
{
again:
Msg(M_WARN, "forcing private colormap");
SETCFG(private, 1);
}
if (GETCFG(private))
{
cmap = XCreateColormap(Dpy, root, visual, AllocNone);
}
else
{
cmap = DefaultColormapOfScreen(screen);
}
if (GETCFG(mono))
{
xc.flags = DoRed | DoGreen | DoBlue;
xc.red   = rgbVals[BLACK][0];
xc.green = rgbVals[BLACK][1];
xc.blue  = rgbVals[BLACK][2];
if (!XAllocColor(Dpy, cmap, &xc))
{
i = BLACK;
goto error;
}
for (i = 0; i < (NCOLORS / 4); i++)
{
colors[i] = colors[i + (NCOLORS / 2)] = xc.pixel;
}
xc.red   = rgbVals[BRIGHT_WHITE][0];
xc.green = rgbVals[BRIGHT_WHITE][1];
xc.blue  = rgbVals[BRIGHT_WHITE][2];
if (!XAllocColor(Dpy, cmap, &xc))
{
(void)XFreeColors(Dpy, cmap, colors, 1, 0);
i = BRIGHT_WHITE;
goto error;
}
for (; i < (NCOLORS / 2); i++)
{
colors[i] = colors[i + (NCOLORS / 2)] = xc.pixel;
}
}
else
{
xc.flags = DoRed | DoGreen | DoBlue;
for (i = 0; i < NCOLORS; i++)
{
xc.red   = rgbVals[i][0];
xc.green = rgbVals[i][1];
xc.blue  = rgbVals[i][2];
if (!XAllocColor(Dpy, cmap, &xc))
{
if (i)
{
(void)XFreeColors(Dpy, cmap, colors, i - 1, 0);
}
error:
assert(!GETCFG(private));
Msg(M_ERR, "couldn't allocate color %d", i);
goto again;
}
colors[i] = xc.pixel;
}
}
}
static void
destroyColors(void)
{
if (cmap)
{
if (GETCFG(mono))
{
(void)XFreeColors(Dpy, cmap, &colors[0], 1, 0);
(void)XFreeColors(Dpy, cmap, &colors[NCOLORS / 4], 1, 0);
}
else
{
(void)XFreeColors(Dpy, cmap, colors, NCOLORS, 0);
}
if (cmap != DefaultColormapOfScreen(screen))
{
XFreeColormap(Dpy, cmap);
}
}
}
static void
initImage(void)
{
#ifdef HAVE_MITSHM
if (GETCFG(mitshm))
{
int x, y, z;
if (XQueryExtension(Dpy, "MIT-SHM", &x, &y, &z))
{
(void)XShmQueryVersion(Dpy, &x, &y, (Bool *)&GETCFG(mitshm));
}
else
{
SETCFG(mitshm, 0);
}
}
if (GETCFG(mitshm))
{
int rc;
xim = XShmCreateImage(Dpy, visual, depth, ZPixmap, NULL, &xshminfo,
hsize, vsize);
if (!xim)
{
goto error;
}
xshminfo.shmid = shmget(IPC_PRIVATE, xim->bytes_per_line * xim->height,
IPC_CREAT | 0777);
if (xshminfo.shmid == -1)
{
goto error;
}
xshminfo.shmaddr = xim->data = shmat(xshminfo.shmid, 0, 0);
if (!xshminfo.shmaddr)
{
goto error;
}
xshminfo.readOnly = False;
attachError = 0;
oldErrorHandler = XSetErrorHandler(catchAttachError);
rc = XShmAttach(Dpy, &xshminfo);
XSync(Dpy, False);
(void)XSetErrorHandler(oldErrorHandler);
if (rc && !attachError)
{
(void)shmctl(xshminfo.shmid, IPC_RMID, 0);
putImage = (void (*)())XShmPutImage;
goto quit;
}
error:
Msg(M_ERR, "couldn't create MIT-SHM image");
if (xim)
{
if (!attachError)
{
(void)XShmDetach(Dpy, &xshminfo);
}
XDestroyImage(xim);
if (xshminfo.shmaddr)
{
(void)shmdt(xshminfo.shmaddr);
}
if (xshminfo.shmid != -1)
{
(void)shmctl(xshminfo.shmid, IPC_RMID, 0);
}
}
SETCFG(mitshm, 0);
}
#endif
xim = XCreateImage(Dpy, visual, depth, ZPixmap, 0, NULL, hsize, vsize, 8, 0);
if (!xim)
{
Msg(M_FATAL, "couldn't create X image");
}
xim->data = Malloc((size_t)(xim->bytes_per_line * xim->height), "initImage");
putImage = (void (*)())XPutImage;
quit:
xImagePtr = (uns32 *)xim->data;
}
static void
destroyImage(void)
{
if (xim)
{
#ifdef HAVE_MITSHM
if (GETCFG(mitshm))
{
(void)XShmDetach(Dpy, &xshminfo);
XDestroyImage(xim);
(void)shmdt(xshminfo.shmaddr);
}
else
#endif
{
XDestroyImage(xim);
}
}
}
#ifdef HAVE_MITSHM
static int
catchAttachError(Display *disp, XErrorEvent *ev)
{
if (ev->error_code == BadAccess)
{
attachError = 1;
return 0;
}
return (oldErrorHandler(disp, ev));
}
#endif
static void
initTables(void)
{
int i, j, k, l;
UpdateLine = updateLine[bytesPerPixel - 1][GETCFG(scale) - 1];
if (GETCFG(mono))
{
unsigned long fg, bg;
for (i = 0; i < 2; i ++)
{
for (j = 0; j < 8; j++)
{
for (k = 0; k < 8; k++)
{
if (j > k)
{
fg = colors[BLACK];
bg = colors[WHITE];
}
else if (j < k)
{
fg = colors[WHITE];
bg = colors[BLACK];
}
else
{
if (j < GREEN || (j > WHITE && j < BRIGHT_GREEN))
{
fg = bg = colors[BLACK];
}
else
{
fg = bg = colors[WHITE];
}
}
ink  [(i << 6) + (j << 3) + k] = fg;
paper[(i << 6) + (j << 3) + k] = bg;
}
}
}
}
else
{
for (i = 0; i < 2; i ++)
{
for (j = 0; j < 8; j++)
{
for (k = 0; k < 8; k++)
{
ink  [(i << 6) + (j << 3) + k] = colors[k + (i << 3)];
paper[(i << 6) + (j << 3) + k] = colors[j + (i << 3)];
}
}
}
}
for (i = 0; i < 16; i++)
{
pix2color[i] = Malloc((size_t)(128 * 4 * bytesPerPixel * GETCFG(scale)),
"initTables");
}
switch(bytesPerPixel)
{
case 1:
{
uns8 c, *p;
for (i = 0; i < 16; i++)
{
p = (uns8 *)pix2color[i];
for (j = 0; j < FLASH; j++)
{
for (k = 0x08; k > 0; k >>= 1)
{
c = (uns8)(i & k ? ink[j] : paper[j]);
for (l = 0; l < GETCFG(scale); l++)
{
*p++ = c;
}
}
}
}
}
break;
case 2:
{
uns16 c, *p;
for (i = 0; i < 16; i++)
{
p = (uns16 *)pix2color[i];
for (j = 0; j < FLASH; j++)
{
for (k = 0x08; k > 0; k >>= 1)
{
c = (uns16)(i & k ? ink[j] : paper[j]);
for (l = 0; l < GETCFG(scale); l++)
{
*p++ = c;
}
}
}
}
}
break;
case 3:
{
uns32 c;
uns8 *p;
for (i = 0; i < 16; i++)
{
p = (uns8 *)pix2color[i];
for (j = 0; j < FLASH; j++)
{
for (k = 0x08; k > 0; k >>= 1)
{
c = (uns32)(i & k ? ink[j] : paper[j]);
for (l = 0; l < GETCFG(scale); l++)
{
WRITE24BIT(p,
c & 0x0000ff,
(c & 0x00ff00) >> 8,
(c & 0xff0000) >> 16);
}
}
}
}
}
break;
case 4:
{
uns32 c, *p;
for (i = 0; i < 16; i++)
{
p = (uns32 *)pix2color[i];
for (j = 0; j < FLASH; j++)
{
for (k = 0x08; k > 0; k >>= 1)
{
c = (uns32)(i & k ? ink[j] : paper[j]);
for (l = 0; l < GETCFG(scale); l++)
{
*p++ = c;
}
}
}
}
}
break;
}
borderUpdate = 0;
screenUpdate = 0;
MINIMIZE_BOX();
}
static void
destroyTables(void)
{
int i;
for (i = 0; i < 16; i++)
{
if (pix2color[i])
{
free(pix2color[i]);
}
}
}
void
ProcessEvents(void)
{
XEvent xev;
while (XEventsQueued(Dpy, QueuedAfterReading))
{
(void)XNextEvent(Dpy, &xev);
#ifdef DEBUG
if (GETCFG(debug) & D_X11)
{
static const char *eventNames[] = {
"",                 "",                "KeyPress",
"KeyRelease",       "ButtonPress",     "ButtonRelease",
"MotionNotify",     "EnterNotify",     "LeaveNotify",
"FocusIn",          "FocusOut",        "KeymapNotify",
"Expose",           "GraphicsExpose",  "NoExpose",
"VisibilityNotify", "CreateNotify",    "DestroyNotify",
"UnmapNotify",      "MapNotify",       "MapRequest",
"ReparentNotify",   "ConfigureNotify", "ConfigureRequest",
"GravityNotify",    "ResizeRequest",   "CirculateNotify",
"CirculateRequest", "PropertyNotify",  "SelectionClear",
"SelectionRequest", "SelectionNotify", "ColormapNotify",
"ClientMessage",    "MappingNotify"
};
assert(xev.type < NELEM(eventNames));
Msg(M_DEBUG, "got X event %s", eventNames[xev.type]);
}
#endif
switch(xev.type)
{
case Expose:
if (!xev.xexpose.count)
{
EXPAND_BOX_X(0);
EXPAND_BOX_X(COLS - 1);
EXPAND_BOX_Y(0);
EXPAND_BOX_Y(Y_PIXELS - 1);
borderUpdate++;
screenUpdate++;
ScreenRefresh();
}
break;
case ConfigureNotify:
processConfigure(&xev);
break;
case EnterNotify:
if (xev.xcrossing.detail != NotifyInferior && !InDialog)
{
(void)XAutoRepeatOff(Dpy);
XSync(Dpy, False);
}
break;
case LeaveNotify:
if (xev.xcrossing.detail != NotifyInferior && !InDialog)
{
(void)XAutoRepeatOn(Dpy);
KbdReset();
XSync(Dpy, False);
}
break;
case KeyPress:
if (InDialog)
{
(void)XLookupString((XKeyEvent *)&xev, NULL, 0, &KeyDialog,
NULL);
}
else
{
KbdKeypress(&xev);
}
break;
case KeyRelease:
if (!InDialog)
{
KbdKeyrelease(&xev);
}
break;
#ifdef XZX_KMOUSE
case MotionNotify:
KmouseMove(&xev);
break;
case ButtonPress:
case ButtonRelease:
KmouseButton(&xev);
break;
#endif
case ClientMessage:
if (xev.xclient.format == 32
&& xev.xclient.data.l[0] == (long)deleteAtom)
{
Quit(0);
}
#ifdef OFFIX_DND
else if (xev.xclient.message_type == dndProtocol &&
xev.xclient.data.l[0] == DndFile)
{
Atom dummy_a;
int dummy_f;
unsigned long dummy_s, dummy_r;
unsigned char *data;
(void)XGetWindowProperty(Dpy, root, dndSelection,
0L, 100000L,
False, AnyPropertyType,
&dummy_a, &dummy_f,
&dummy_s, &dummy_r,
&data);
(void)ReadSnapshot((char *)data);
XFree(data);
}
#endif
break;
}
}
}
static void
processConfigure(XEvent *xev)
{
int newScale;
if (xev->xconfigure.width == sizes[2].x
&& xev->xconfigure.height == sizes[2].y)
{
newScale = 3;
}
else if (xev->xconfigure.width == sizes[1].x
&& xev->xconfigure.height == sizes[1].y)
{
newScale = 2;
}
else if (xev->xconfigure.width == sizes[0].x
&& xev->xconfigure.height == sizes[0].y)
{
newScale = 1;
}
else
{
XResizeWindow(Dpy, mainWin,
sizes[GETCFG(scale) - 1].x, sizes[GETCFG(scale) - 1].y);
return;
}
if (newScale != GETCFG(scale))
{
DEB(Msg(M_DEBUG, "changing scale from %d to %d", GETCFG(scale),
newScale););
destroyImage();
destroyTables();
SETCFG(scale, newScale);
hsize = newScale * (BORDER_PIXELS + X_PIXELS + BORDER_PIXELS);
vsize = newScale * (BORDER_PIXELS + Y_PIXELS + BORDER_PIXELS);
initImage();
initTables();
borderChanged = VISIBLE_LINES;
borderUpdate++;
ForceScreenRefresh();
if (InDialog)
{
ScreenRefresh();
}
}
}
void
ScreenWrite(uns16 addr, uns8 val)
{
screenChanged[Pix2Line[addr]] |= 1U << (addr & 0x001f);
}
void
AttrWrite(uns16 addr, uns8 val)
{
uns32 changed, *lcp;
int i;
changed = 1U << (addr & 0x001f);
lcp = &screenChanged[(addr & 0x03e0) >> 2];
for (i = 8; i; i--)
{
*lcp++ |= changed;
}
}
void
ForceScreenRefresh(void)
{
(void)memset(screenChanged, 0xff, sizeof(screenChanged));
}
void
DoFlashing(void)
{
uns8 *mem;
uns32 changed, *lcp;
int i, j;
flashPhase = !flashPhase;
mem = &RealMemory[ScreenSelect][ATTR_OFFSET];
lcp = screenChanged;
changed = 0;
for (i = 24; i; i--)
{
for (j = 32; j; j--)
{
changed >>= 1;
if (*mem++ & FLASH)
{
changed |= 1U << 31;
}
}
if (changed)
{
for (j = 8; j; j--)
{
*lcp++ |= changed;
}
changed = 0;
}
else
{
lcp += 8;
}
}
}
void
SetBorderColor(uns8 color)
{
border = colors[color];
borderChanged = VISIBLE_LINES;
}
#define MEMSET(a,b,c)	(void)memset((void *)(a), (int)(b), (size_t)(c))
#define MEMCPY(a,b,c)	(void)memcpy((void *)(a), (void *)(b), (size_t)(c))
static void
scrLine8x1(short line)
{
#if !defined(LIBC_MEMSET_HSIZE_8x1) || !defined(LIBC_MEMSET_BORDER_8x1)
uns32 bc;
#endif
uns32 *bp;
_C8x1 *sp;
uns8 *pixPtr, *attrPtr, attr;
uns32 changed;
short i;
if (line < Machine->topBorder - BORDER_LINES
|| line >= Machine->topBorder + Y_PIXELS + BORDER_LINES)
{
return;
}
if (line == Machine->topBorder - BORDER_LINES)
{
xImagePtr = (uns32 *)xim->data;
}
if (borderChanged)
{
borderChanged--;
if ((uns8)border != *(uns8 *)xImagePtr)
{
borderUpdate++;
bp = xImagePtr;
#if !defined(LIBC_MEMSET_HSIZE_8x1) || !defined(LIBC_MEMSET_BORDER_8x1)
bc = border | (border << 8) | (border << 16) | (border << 24);
#endif
if (line < Machine->topBorder
|| line >= Machine->topBorder + Y_PIXELS)
{
#ifdef LIBC_MEMSET_HSIZE_8x1
MEMSET(bp, border, HSIZE_8x1 * sizeof(uns32));
#else
for (i = HSIZE_8x1; i > 0; i--)
{
*bp++ = bc;
}
#endif
xImagePtr += HSIZE_8x1;
return;
}
else
{
#ifdef LIBC_MEMSET_BORDER_8x1
MEMSET(bp, border, BORDER_8x1 * sizeof(uns32));
bp += BORDER_8x1 + SCREEN_8x1;
MEMSET(bp, border, BORDER_8x1 * sizeof(uns32));
#else
for (i = BORDER_8x1; i > 0; i--)
{
*bp++ = bc;
}
bp += SCREEN_8x1;
for (i = BORDER_8x1; i > 0; i--)
{
*bp++ = bc;
}
#endif
goto drawScreenLine;
}
}
}
if (line >= Machine->topBorder && line < Machine->topBorder + Y_PIXELS)
{
drawScreenLine:
if ((changed = screenChanged[line -= Machine->topBorder]))
{
screenChanged[line] = 0;
EXPAND_BOX_Y(line);
screenUpdate++;
sp = (_C8x1 *)(xImagePtr + BORDER_8x1);
pixPtr = &RealMemory[ScreenSelect][Line2Pix[line]];
attrPtr = &RealMemory[ScreenSelect][Line2Attr[line]];
for (i = 0; i < COLS; i++, pixPtr++, attrPtr++, changed >>= 1)
{
if (changed & 0x1)
{
EXPAND_BOX_X(i);
attr = ((*attrPtr & FLASH) && flashPhase) ?
Reverse[*attrPtr & ~FLASH] : *attrPtr & ~FLASH;
#ifdef LIBC_MEMCPY_C8x1
MEMCPY(sp++,
(_C8x1 *)pix2color[*pixPtr >> 4] + attr,
sizeof(_C8x1));
MEMCPY(sp++,
(_C8x1 *)pix2color[*pixPtr & 0x0f] + attr,
sizeof(_C8x1));
#else
*sp++ = *((_C8x1 *)pix2color[*pixPtr >> 4] + attr);
*sp++ = *((_C8x1 *)pix2color[*pixPtr & 0x0f] + attr);
#endif
}
else
{
sp += 2;
}
}
}
}
xImagePtr += HSIZE_8x1;
}
static void
scrLine8x2(short line)
{
#if !defined(LIBC_MEMSET_HSIZE_8x2) || !defined(LIBC_MEMSET_BORDER_8x2)
uns32 bc;
#endif
uns32 *bp;
_C8x2 *sp, *sp2;
uns8 *pixPtr, *attrPtr, attr;
uns32 changed;
short i, j;
if (line < (Machine->topBorder - BORDER_LINES)
|| line >= Machine->topBorder + Y_PIXELS + BORDER_LINES)
{
return;
}
if (line == Machine->topBorder - BORDER_LINES)
{
xImagePtr = (uns32 *)xim->data;
}
if (borderChanged)
{
borderChanged--;
if ((uns8)border != *(uns8 *)xImagePtr)
{
borderUpdate++;
bp = xImagePtr;
#if !defined(LIBC_MEMSET_HSIZE_8x2) || !defined(LIBC_MEMSET_BORDER_8x2)
bc = border | (border << 8) | (border << 16) | (border << 24);
#endif
if (line < Machine->topBorder
|| line >= Machine->topBorder + Y_PIXELS)
{
#ifdef LIBC_MEMSET_HSIZE_8x2
MEMSET(bp, border, 2 * HSIZE_8x2 * sizeof(uns32));
#else
for (i = 2 * HSIZE_8x2; i > 0; i--)
{
*bp++ = bc;
}
#endif
xImagePtr += 2 * HSIZE_8x2;
return;
}
else
{
for (j = 2; j > 0; j--)
{
#ifdef LIBC_MEMSET_BORDER_8x2
MEMSET(bp, border, BORDER_8x2 * sizeof(uns32));
bp += BORDER_8x2 + SCREEN_8x2;
MEMSET(bp, border, BORDER_8x2 * sizeof(uns32));
bp += BORDER_8x2;
#else
for (i = BORDER_8x2; i > 0; i--)
{
*bp++ = bc;
}
bp += SCREEN_8x2;
for (i = BORDER_8x2; i > 0; i--)
{
*bp++ = bc;
}
#endif
}
goto drawScreenLine;
}
}
}
if (line >= Machine->topBorder && line < Machine->topBorder + Y_PIXELS)
{
drawScreenLine:
if ((changed = screenChanged[line -= Machine->topBorder]))
{
screenChanged[line] = 0;
EXPAND_BOX_Y(line);
screenUpdate++;
sp = (_C8x2 *)(xImagePtr + BORDER_8x2);
sp2 = (_C8x2 *)(xImagePtr + BORDER_8x2 + HSIZE_8x2);
pixPtr = &RealMemory[ScreenSelect][Line2Pix[line]];
attrPtr = &RealMemory[ScreenSelect][Line2Attr[line]];
for (i = 0; i < COLS; i++, pixPtr++, attrPtr++, changed >>= 1)
{
if (changed & 0x1)
{
EXPAND_BOX_X(i);
attr = ((*attrPtr & FLASH) && flashPhase) ?
Reverse[*attrPtr & ~FLASH] : *attrPtr & ~FLASH;
#ifdef LIBC_MEMCPY_C8x2
MEMCPY(sp++,
(_C8x2 *)pix2color[*pixPtr >> 4] + attr,
sizeof(_C8x2));
MEMCPY(sp2++,
(_C8x2 *)pix2color[*pixPtr >> 4] + attr,
sizeof(_C8x2));
MEMCPY(sp++,
(_C8x2 *)pix2color[*pixPtr & 0x0f] + attr,
sizeof(_C8x2));
MEMCPY(sp2++,
(_C8x2 *)pix2color[*pixPtr & 0x0f] + attr,
sizeof(_C8x2));
#else
*sp2++ = *sp++ =
*((_C8x2 *)pix2color[*pixPtr >> 4] + attr);
*sp2++ = *sp++ =
*((_C8x2 *)pix2color[*pixPtr & 0x0f] + attr);
#endif
}
else
{
sp += 2;
sp2 += 2;
}
}
}
}
xImagePtr += 2 * HSIZE_8x2;
}
static void
scrLine8x3(short line)
{
#if !defined(LIBC_MEMSET_HSIZE_8x3) || !defined(LIBC_MEMSET_BORDER_8x3)
uns32 bc;
#endif
uns32 *bp;
_C8x3 *sp, *sp2, *sp3;
uns8 *pixPtr, *attrPtr, attr;
uns32 changed;
short i, j;
if (line < (Machine->topBorder - BORDER_LINES)
|| line >= Machine->topBorder + Y_PIXELS + BORDER_LINES)
{
return;
}
if (line == Machine->topBorder - BORDER_LINES)
{
xImagePtr = (uns32 *)xim->data;
}
if (borderChanged)
{
borderChanged--;
if ((uns8)border != *(uns8 *)xImagePtr)
{
borderUpdate++;
bp = xImagePtr;
#if !defined(LIBC_MEMSET_HSIZE_8x3) || !defined(LIBC_MEMSET_BORDER_8x3)
bc = border | (border << 8) | (border << 16) | (border << 24);
#endif
if (line < Machine->topBorder
|| line >= Machine->topBorder + Y_PIXELS)
{
#ifdef LIBC_MEMSET_HSIZE_8x3
MEMSET(bp, border, 3 * HSIZE_8x3 * sizeof(uns32));
#else
for (i = 3 * HSIZE_8x3; i > 0; i--)
{
*bp++ = bc;
}
#endif
xImagePtr += 3 * HSIZE_8x3;
return;
}
else
{
for (j = 3; j > 0; j--)
{
#ifdef LIBC_MEMSET_BORDER_8x3
MEMSET(bp, border, BORDER_8x3 * sizeof(uns32));
bp += BORDER_8x3 + SCREEN_8x3;
MEMSET(bp, border, BORDER_8x3 * sizeof(uns32));
bp += BORDER_8x3;
#else
for (i = BORDER_8x3; i > 0; i--)
{
*bp++ = bc;
}
bp += SCREEN_8x3;
for (i = BORDER_8x3; i > 0; i--)
{
*bp++ = bc;
}
#endif
}
goto drawScreenLine;
}
}
}
if (line >= Machine->topBorder && line < Machine->topBorder + Y_PIXELS)
{
drawScreenLine:
if ((changed = screenChanged[line -= Machine->topBorder]))
{
screenChanged[line] = 0;
EXPAND_BOX_Y(line);
screenUpdate++;
sp = (_C8x3 *)(xImagePtr + BORDER_8x3);
sp2 = (_C8x3 *)(xImagePtr + BORDER_8x3 + HSIZE_8x3);
sp3 = (_C8x3 *)(xImagePtr + BORDER_8x3 + 2 * HSIZE_8x3);
pixPtr = &RealMemory[ScreenSelect][Line2Pix[line]];
attrPtr = &RealMemory[ScreenSelect][Line2Attr[line]];
for (i = 0; i < COLS; i++, pixPtr++, attrPtr++, changed >>= 1)
{
if (changed & 0x1)
{
EXPAND_BOX_X(i);
attr = ((*attrPtr & FLASH) && flashPhase) ?
Reverse[*attrPtr & ~FLASH] : *attrPtr & ~FLASH;
#ifdef LIBC_MEMCPY_C8x3
MEMCPY(sp++,
(_C8x3 *)pix2color[*pixPtr >> 4] + attr,
sizeof(_C8x3));
MEMCPY(sp2++,
(_C8x3 *)pix2color[*pixPtr >> 4] + attr,
sizeof(_C8x3));
MEMCPY(sp3++,
(_C8x3 *)pix2color[*pixPtr >> 4] + attr,
sizeof(_C8x3));
MEMCPY(sp++,
(_C8x3 *)pix2color[*pixPtr & 0x0f] + attr,
sizeof(_C8x3));
MEMCPY(sp2++,
(_C8x3 *)pix2color[*pixPtr & 0x0f] + attr,
sizeof(_C8x3));
MEMCPY(sp3++,
(_C8x3 *)pix2color[*pixPtr & 0x0f] + attr,
sizeof(_C8x3));
#else
*sp3++ = *sp2++ = *sp++ =
*((_C8x3 *)pix2color[*pixPtr >> 4] + attr);
*sp3++ = *sp2++ = *sp++ =
*((_C8x3 *)pix2color[*pixPtr & 0x0f] + attr);
#endif
}
else
{
sp += 2;
sp2 += 2;
sp3 += 2;
}
}
}
}
xImagePtr += 3 * HSIZE_8x3;
}
static void
scrLine16x1(short line)
{
uns32 bc;
uns32 *bp;
_C16x1 *sp;
uns8 *pixPtr, *attrPtr, attr;
uns32 changed;
short i;
if (line < (Machine->topBorder - BORDER_LINES)
|| line >= Machine->topBorder + Y_PIXELS + BORDER_LINES)
{
return;
}
if (line == Machine->topBorder - BORDER_LINES)
{
xImagePtr = (uns32 *)xim->data;
}
if (borderChanged)
{
borderChanged--;
if ((uns16)border != *(uns16 *)xImagePtr)
{
borderUpdate++;
bp = xImagePtr;
bc = border | (border << 16);
if (line < Machine->topBorder
|| line >= Machine->topBorder + Y_PIXELS)
{
for (i = HSIZE_16x1; i > 0; i--)
{
*bp++ = bc;
}
xImagePtr += HSIZE_16x1;
return;
}
else
{
for (i = BORDER_16x1; i > 0; i--)
{
*bp++ = bc;
}
bp += SCREEN_16x1;
for (i = BORDER_16x1; i > 0; i--)
{
*bp++ = bc;
}
goto drawScreenLine;
}
}
}
if (line >= Machine->topBorder && line < (Machine->topBorder + Y_PIXELS))
{
drawScreenLine:
if ((changed = screenChanged[line -= Machine->topBorder]))
{
screenChanged[line] = 0;
EXPAND_BOX_Y(line);
screenUpdate++;
sp = (_C16x1 *)(xImagePtr + BORDER_16x1);
pixPtr = &RealMemory[ScreenSelect][Line2Pix[line]];
attrPtr = &RealMemory[ScreenSelect][Line2Attr[line]];
for (i = 0; i < COLS; i++, pixPtr++, attrPtr++, changed >>= 1)
{
if (changed & 0x1)
{
EXPAND_BOX_X(i);
attr = ((*attrPtr & FLASH) && flashPhase) ?
Reverse[*attrPtr & ~FLASH] : *attrPtr & ~FLASH;
#ifdef LIBC_MEMCPY_C16x1
MEMCPY(sp++,
(_C16x1 *)pix2color[*pixPtr >> 4] + attr,
sizeof(_C16x1));
MEMCPY(sp++,
(_C16x1 *)pix2color[*pixPtr & 0x0f] + attr,
sizeof(_C16x1));
#else
*sp++ = *((_C16x1 *)pix2color[*pixPtr >> 4] + attr);
*sp++ = *((_C16x1 *)pix2color[*pixPtr & 0x0f] + attr);
#endif
}
else
{
sp += 2;
}
}
}
}
xImagePtr += HSIZE_16x1;
}
static void
scrLine16x2(short line)
{
uns32 bc;
uns32 *bp;
_C16x2 *sp, *sp2;
uns8 *pixPtr, *attrPtr, attr;
uns32 changed;
short i, j;
if (line < (Machine->topBorder - BORDER_LINES)
|| line >= Machine->topBorder + Y_PIXELS + BORDER_LINES)
{
return;
}
if (line == Machine->topBorder - BORDER_LINES)
{
xImagePtr = (uns32 *)xim->data;
}
if (borderChanged)
{
borderChanged--;
if ((uns16)border != *(uns16 *)xImagePtr)
{
borderUpdate++;
bp = xImagePtr;
bc = border | (border << 16);
if (line < Machine->topBorder
|| line >= Machine->topBorder + Y_PIXELS)
{
for (i = 2 * HSIZE_16x2; i > 0; i--)
{
*bp++ = bc;
}
xImagePtr += 2 * HSIZE_16x2;
return;
}
else
{
for (j = 2; j > 0; j--)
{
for (i = BORDER_16x2; i > 0; i--)
{
*bp++ = bc;
}
bp += SCREEN_16x2;
for (i = BORDER_16x2; i > 0; i--)
{
*bp++ = bc;
}
}
goto drawScreenLine;
}
}
}
if (line >= Machine->topBorder && line < (Machine->topBorder + Y_PIXELS))
{
drawScreenLine:
if ((changed = screenChanged[line -= Machine->topBorder]))
{
screenChanged[line] = 0;
EXPAND_BOX_Y(line);
screenUpdate++;
sp = (_C16x2 *)(xImagePtr + BORDER_16x2);
sp2 = (_C16x2 *)(xImagePtr + BORDER_16x2 + HSIZE_16x2);
pixPtr = &RealMemory[ScreenSelect][Line2Pix[line]];
attrPtr = &RealMemory[ScreenSelect][Line2Attr[line]];
for (i = 0; i < COLS; i++, pixPtr++, attrPtr++, changed >>= 1)
{
if (changed & 0x1)
{
EXPAND_BOX_X(i);
attr = ((*attrPtr & FLASH) && flashPhase) ?
Reverse[*attrPtr & ~FLASH] : *attrPtr & ~FLASH;
#ifdef LIBC_MEMCPY_C16x2
MEMCPY(sp++,
(_C16x2 *)pix2color[*pixPtr >> 4] + attr,
sizeof(_C16x2));
MEMCPY(sp2++,
(_C16x2 *)pix2color[*pixPtr >> 4] + attr,
sizeof(_C16x2));
MEMCPY(sp++,
(_C16x2 *)pix2color[*pixPtr & 0x0f] + attr,
sizeof(_C16x2));
MEMCPY(sp2++,
(_C16x2 *)pix2color[*pixPtr & 0x0f] + attr,
sizeof(_C16x2));
#else
*sp2++ = *sp++ =
*((_C16x2 *)pix2color[*pixPtr >> 4] + attr);
*sp2++ = *sp++ =
*((_C16x2 *)pix2color[*pixPtr & 0x0f] + attr);
#endif
}
else
{
sp += 2;
sp2 += 2;
}
}
}
}
xImagePtr += 2 * HSIZE_16x2;
}
static void
scrLine16x3(short line)
{
uns32 bc;
uns32 *bp;
_C16x3 *sp, *sp2, *sp3;
uns8 *pixPtr, *attrPtr, attr;
uns32 changed;
short i, j;
if (line < (Machine->topBorder - BORDER_LINES)
|| line >= Machine->topBorder + Y_PIXELS + BORDER_LINES)
{
return;
}
if (line == Machine->topBorder - BORDER_LINES)
{
xImagePtr = (uns32 *)xim->data;
}
if (borderChanged)
{
borderChanged--;
if ((uns16)border != *(uns16 *)xImagePtr)
{
borderUpdate++;
bp = xImagePtr;
bc = border | (border << 16);
if (line < Machine->topBorder
|| line >= Machine->topBorder + Y_PIXELS)
{
for (i = 3 * HSIZE_16x3; i > 0; i--)
{
*bp++ = bc;
}
xImagePtr += 3 * HSIZE_16x3;
return;
}
else
{
for (j = 3; j > 0; j--)
{
for (i = BORDER_16x3; i > 0; i--)
{
*bp++ = bc;
}
bp += SCREEN_16x3;
for (i = BORDER_16x3; i > 0; i--)
{
*bp++ = bc;
}
}
goto drawScreenLine;
}
}
}
if (line >= Machine->topBorder && line < (Machine->topBorder + Y_PIXELS))
{
drawScreenLine:
if ((changed = screenChanged[line -= Machine->topBorder]))
{
screenChanged[line] = 0;
EXPAND_BOX_Y(line);
screenUpdate++;
sp = (_C16x3 *)(xImagePtr + BORDER_16x3);
sp2 = (_C16x3 *)(xImagePtr + BORDER_16x3 + HSIZE_16x3);
sp3 = (_C16x3 *)(xImagePtr + BORDER_16x3 + 2 * HSIZE_16x3);
pixPtr = &RealMemory[ScreenSelect][Line2Pix[line]];
attrPtr = &RealMemory[ScreenSelect][Line2Attr[line]];
for (i = 0; i < COLS; i++, pixPtr++, attrPtr++, changed >>= 1)
{
if (changed & 0x1)
{
EXPAND_BOX_X(i);
attr = ((*attrPtr & FLASH) && flashPhase) ?
Reverse[*attrPtr & ~FLASH] : *attrPtr & ~FLASH;
#ifdef LIBC_MEMCPY_C16x3
MEMCPY(sp++,
(_C16x3 *)pix2color[*pixPtr >> 4] + attr,
sizeof(_C16x3));
MEMCPY(sp2++,
(_C16x3 *)pix2color[*pixPtr >> 4] + attr,
sizeof(_C16x3));
MEMCPY(sp3++,
(_C16x3 *)pix2color[*pixPtr >> 4] + attr,
sizeof(_C16x3));
MEMCPY(sp++,
(_C16x3 *)pix2color[*pixPtr & 0x0f] + attr,
sizeof(_C16x3));
MEMCPY(sp2++,
(_C16x3 *)pix2color[*pixPtr & 0x0f] + attr,
sizeof(_C16x3));
MEMCPY(sp3++,
(_C16x3 *)pix2color[*pixPtr & 0x0f] + attr,
sizeof(_C16x3));
#else
*sp3++ = *sp2++ = *sp++ =
*((_C16x3 *)pix2color[*pixPtr >> 4] + attr);
*sp3++ = *sp2++ = *sp++ =
*((_C16x3 *)pix2color[*pixPtr & 0x0f] + attr);
#endif
}
else
{
sp += 2;
sp2 += 2;
sp3 += 2;
}
}
}
}
xImagePtr += 3 * HSIZE_16x3;
}
static void
scrLine24x1(short line)
{
uns8 b1, b2, b3, *bp;
_C24x1 *sp;
uns8 *pixPtr, *attrPtr, attr;
uns32 changed;
short i;
if (line < (Machine->topBorder - BORDER_LINES)
|| line >= Machine->topBorder + Y_PIXELS + BORDER_LINES)
{
return;
}
if (line == Machine->topBorder - BORDER_LINES)
{
xImagePtr = (uns32 *)xim->data;
}
if (borderChanged)
{
borderChanged--;
if (border != (*xImagePtr & 0x00ffffff))
{
borderUpdate++;
bp = (uns8 *)xImagePtr;
b1 = border & 0x0000ff;
b2 = (border & 0x00ff00) >> 8;
b3 = (border & 0xff0000) >> 16;
if (line < Machine->topBorder
|| line >= Machine->topBorder + Y_PIXELS)
{
for (i = HSIZE_24x1 ; i > 0; i--)
{
WRITE24BIT(bp, b1, b2, b3);
}
xImagePtr += HSIZE_24x1;
return;
}
else
{
for (i = BORDER_24x1; i > 0; i--)
{
WRITE24BIT(bp, b1, b2, b3);
}
bp += SCREEN_24x1;
for (i = BORDER_24x1; i > 0; i--)
{
WRITE24BIT(bp, b1, b2, b3);
}
goto drawScreenLine;
}
}
}
if (line >= Machine->topBorder && line < (Machine->topBorder + Y_PIXELS))
{
drawScreenLine:
if ((changed = screenChanged[line -= Machine->topBorder]))
{
screenChanged[line] = 0;
EXPAND_BOX_Y(line);
screenUpdate++;
sp = (_C24x1 *)(xImagePtr + BORDER_24x1);
pixPtr = &RealMemory[ScreenSelect][Line2Pix[line]];
attrPtr = &RealMemory[ScreenSelect][Line2Attr[line]];
for (i = 0; i < COLS; i++, pixPtr++, attrPtr++, changed >>= 1)
{
if (changed & 0x1)
{
EXPAND_BOX_X(i);
attr = ((*attrPtr & FLASH) && flashPhase) ?
Reverse[*attrPtr & ~FLASH] : *attrPtr & ~FLASH;
#ifdef LIBC_MEMCPY_C24x1
MEMCPY(sp++,
(_C24x1 *)pix2color[*pixPtr >> 4] + attr,
sizeof(_C24x1));
MEMCPY(sp++,
(_C24x1 *)pix2color[*pixPtr & 0x0f] + attr,
sizeof(_C24x1));
#else
*sp++ = *((_C24x1 *)pix2color[*pixPtr >> 4] + attr);
*sp++ = *((_C24x1 *)pix2color[*pixPtr & 0x0f] + attr);
#endif
}
else
{
sp += 2;
}
}
}
}
xImagePtr += HSIZE_24x1;
}
static void
scrLine24x2(short line)
{
uns8 b1, b2, b3, *bp;
_C24x2 *sp, *sp2;
uns8 *pixPtr, *attrPtr, attr;
uns32 changed;
short i, j;
if (line < (Machine->topBorder - BORDER_LINES)
|| line >= Machine->topBorder + Y_PIXELS + BORDER_LINES)
{
return;
}
if (line == Machine->topBorder - BORDER_LINES)
{
xImagePtr = (uns32 *)xim->data;
}
if (borderChanged)
{
borderChanged--;
if (border != (*xImagePtr & 0x00ffffff))
{
borderUpdate++;
bp = (uns8 *)xImagePtr;
b1 = border & 0x0000ff;
b2 = (border & 0x00ff00) >> 8;
b3 = (border & 0xff0000) >> 16;
if (line < Machine->topBorder
|| line >= Machine->topBorder + Y_PIXELS)
{
for (i = 2 * HSIZE_24x2; i > 0; i--)
{
WRITE24BIT(bp, b1, b2, b3);
}
xImagePtr += 2 * HSIZE_24x2;
return;
}
else
{
for (j = 2; j > 0; j--)
{
for (i = BORDER_24x2; i > 0; i--)
{
WRITE24BIT(bp, b1, b2, b3);
}
bp += SCREEN_24x2;
for (i = BORDER_24x2; i > 0; i--)
{
WRITE24BIT(bp, b1, b2, b3);
}
}
goto drawScreenLine;
}
}
}
if (line >= Machine->topBorder && line < (Machine->topBorder + Y_PIXELS))
{
drawScreenLine:
if ((changed = screenChanged[line -= Machine->topBorder]))
{
screenChanged[line] = 0;
EXPAND_BOX_Y(line);
screenUpdate++;
sp = (_C24x2 *)(xImagePtr + BORDER_24x2);
sp2 = (_C24x2 *)(xImagePtr + BORDER_24x2 + HSIZE_24x2);
pixPtr = &RealMemory[ScreenSelect][Line2Pix[line]];
attrPtr = &RealMemory[ScreenSelect][Line2Attr[line]];
for (i = 0; i < COLS; i++, pixPtr++, attrPtr++, changed >>= 1)
{
if (changed & 0x1)
{
EXPAND_BOX_X(i);
attr = ((*attrPtr & FLASH) && flashPhase) ?
Reverse[*attrPtr & ~FLASH] : *attrPtr & ~FLASH;
#ifdef LIBC_MEMCPY_C24x2
MEMCPY(sp++,
(_C24x2 *)pix2color[*pixPtr >> 4] + attr,
sizeof(_C24x2));
MEMCPY(sp2++,
(_C24x2 *)pix2color[*pixPtr >> 4] + attr,
sizeof(_C24x2));
MEMCPY(sp++,
(_C24x2 *)pix2color[*pixPtr & 0x0f] + attr,
sizeof(_C24x2));
MEMCPY(sp2++,
(_C24x2 *)pix2color[*pixPtr & 0x0f] + attr,
sizeof(_C24x2));
#else
*sp2++ = *sp++ =
*((_C24x2 *)pix2color[*pixPtr >> 4] + attr);
*sp2++ = *sp++ =
*((_C24x2 *)pix2color[*pixPtr & 0x0f] + attr);
#endif
}
else
{
sp += 2;
sp2 += 2;
}
}
}
}
xImagePtr += 2 * HSIZE_24x2;
}
static void
scrLine24x3(short line)
{
uns8 b1, b2, b3, *bp;
_C24x3 *sp, *sp2, *sp3;
uns8 *pixPtr, *attrPtr, attr;
uns32 changed;
short i, j;
if (line < (Machine->topBorder - BORDER_LINES)
|| line >= Machine->topBorder + Y_PIXELS + BORDER_LINES)
{
return;
}
if (line == Machine->topBorder - BORDER_LINES)
{
xImagePtr = (uns32 *)xim->data;
}
if (borderChanged)
{
borderChanged--;
if (border != (*xImagePtr & 0x00ffffff))
{
borderUpdate++;
b1 = border & 0x0000ff;
b2 = (border & 0x00ff00) >> 8;
b3 = (border & 0xff0000) >> 16;
bp = (uns8 *)xImagePtr;
if (line < Machine->topBorder
|| line >= Machine->topBorder + Y_PIXELS)
{
for (i = 3 * HSIZE_24x3; i > 0; i--)
{
WRITE24BIT(bp, b1, b2, b3);
}
xImagePtr += 3 * HSIZE_24x3;
return;
}
else
{
for (j = 3; j > 0; j--)
{
for (i = BORDER_24x3; i > 0; i--)
{
WRITE24BIT(bp, b1, b2, b3);
}
bp += SCREEN_24x3;
for (i = BORDER_24x3; i > 0; i--)
{
WRITE24BIT(bp, b1, b2, b3);
}
}
goto drawScreenLine;
}
}
}
if (line >= Machine->topBorder && line < (Machine->topBorder + Y_PIXELS))
{
drawScreenLine:
if ((changed = screenChanged[line -= Machine->topBorder]))
{
screenChanged[line] = 0;
EXPAND_BOX_Y(line);
screenUpdate++;
sp = (_C24x3 *)(xImagePtr + BORDER_24x3);
sp2 = (_C24x3 *)(xImagePtr + BORDER_24x3 + HSIZE_24x3);
sp3 = (_C24x3 *)(xImagePtr + BORDER_24x3 + 2 * HSIZE_24x3);
pixPtr = &RealMemory[ScreenSelect][Line2Pix[line]];
attrPtr = &RealMemory[ScreenSelect][Line2Attr[line]];
for (i = 0; i < COLS; i++, pixPtr++, attrPtr++, changed >>= 1)
{
if (changed & 0x1)
{
EXPAND_BOX_X(i);
attr = ((*attrPtr & FLASH) && flashPhase) ?
Reverse[*attrPtr & ~FLASH] : *attrPtr & ~FLASH;
#ifdef LIBC_MEMCPY_C24x3
MEMCPY(sp++,
(_C24x3 *)pix2color[*pixPtr >> 4] + attr,
sizeof(_C24x3));
MEMCPY(sp2++,
(_C24x3 *)pix2color[*pixPtr >> 4] + attr,
sizeof(_C24x3));
MEMCPY(sp3++,
(_C24x3 *)pix2color[*pixPtr >> 4] + attr,
sizeof(_C24x3));
MEMCPY(sp++,
(_C24x3 *)pix2color[*pixPtr & 0x0f] + attr,
sizeof(_C24x3));
MEMCPY(sp2++,
(_C24x3 *)pix2color[*pixPtr & 0x0f] + attr,
sizeof(_C24x3));
MEMCPY(sp3++,
(_C24x3 *)pix2color[*pixPtr & 0x0f] + attr,
sizeof(_C24x3));
#else
*sp3++ = *sp2++ = *sp++ =
*((_C24x3 *)pix2color[*pixPtr >> 4] + attr);
*sp3++ = *sp2++ = *sp++ =
*((_C24x3 *)pix2color[*pixPtr & 0x0f] + attr);
#endif
}
else
{
sp += 2;
sp2 += 2;
sp3 += 2;
}
}
}
}
xImagePtr += 3 * HSIZE_24x3;
}
static void
scrLine32x1(short line)
{
uns32 *bp;
_C32x1 *sp;
uns8 *pixPtr, *attrPtr, attr;
uns32 changed;
short i;
if (line < (Machine->topBorder - BORDER_LINES)
|| line >= Machine->topBorder + Y_PIXELS + BORDER_LINES)
{
return;
}
if (line == Machine->topBorder - BORDER_LINES)
{
xImagePtr = (uns32 *)xim->data;
}
if (borderChanged)
{
borderChanged--;
if (border != *xImagePtr)
{
borderUpdate++;
bp = xImagePtr;
if (line < Machine->topBorder
|| line >= Machine->topBorder + Y_PIXELS)
{
for (i = HSIZE_32x1; i > 0; i--)
{
*bp++ = (uns32)border;
}
xImagePtr += HSIZE_32x1;
return;
}
else
{
for (i = BORDER_32x1; i > 0; i--)
{
*bp++ = (uns32)border;
}
bp += SCREEN_32x1;
for (i = BORDER_32x1; i > 0; i--)
{
*bp++ = (uns32)border;
}
goto drawScreenLine;
}
}
}
if (line >= Machine->topBorder && line < (Machine->topBorder + Y_PIXELS))
{
drawScreenLine:
if ((changed = screenChanged[line -= Machine->topBorder]))
{
screenChanged[line] = 0;
EXPAND_BOX_Y(line);
screenUpdate++;
sp = (_C32x1 *)(xImagePtr + BORDER_32x1);
pixPtr = &RealMemory[ScreenSelect][Line2Pix[line]];
attrPtr = &RealMemory[ScreenSelect][Line2Attr[line]];
for (i = 0; i < COLS; i++, pixPtr++, attrPtr++, changed >>= 1)
{
if (changed & 0x1)
{
EXPAND_BOX_X(i);
attr = ((*attrPtr & FLASH) && flashPhase) ?
Reverse[*attrPtr & ~FLASH] : *attrPtr & ~FLASH;
#ifdef LIBC_MEMCPY_C32x1
MEMCPY(sp++,
(_C32x1 *)pix2color[*pixPtr >> 4] + attr,
sizeof(_C32x1));
MEMCPY(sp++,
(_C32x1 *)pix2color[*pixPtr & 0x0f] + attr,
sizeof(_C32x1));
#else
*sp++ = *((_C32x1 *)pix2color[*pixPtr >> 4] + attr);
*sp++ = *((_C32x1 *)pix2color[*pixPtr & 0x0f] + attr);
#endif
}
else
{
sp += 2;
}
}
}
}
xImagePtr += HSIZE_32x1;
}
static void
scrLine32x2(short line)
{
uns32 *bp;
_C32x2 *sp, *sp2;
uns8 *pixPtr, *attrPtr, attr;
uns32 changed;
short i, j;
if (line < (Machine->topBorder - BORDER_LINES)
|| line >= Machine->topBorder + Y_PIXELS + BORDER_LINES)
{
return;
}
if (line == Machine->topBorder - BORDER_LINES)
{
xImagePtr = (uns32 *)xim->data;
}
if (borderChanged)
{
borderChanged--;
if (border != *xImagePtr)
{
borderUpdate++;
bp = xImagePtr;
if (line < Machine->topBorder
|| line >= Machine->topBorder + Y_PIXELS)
{
for (i = 2 * HSIZE_32x2; i > 0; i--)
{
*bp++ = (uns32)border;
}
xImagePtr += 2 * HSIZE_32x2;
return;
}
else
{
for (j = 2; j > 0; j--)
{
for (i = BORDER_32x2; i > 0; i--)
{
*bp++ = (uns32)border;
}
bp += SCREEN_32x2;
for (i = BORDER_32x2; i > 0; i--)
{
*bp++ = (uns32)border;
}
}
goto drawScreenLine;
}
}
}
if (line >= Machine->topBorder && line < (Machine->topBorder + Y_PIXELS))
{
drawScreenLine:
if ((changed = screenChanged[line -= Machine->topBorder]))
{
screenChanged[line] = 0;
EXPAND_BOX_Y(line);
screenUpdate++;
sp = (_C32x2 *)(xImagePtr + BORDER_32x2);
sp2 = (_C32x2 *)(xImagePtr + BORDER_32x2 + HSIZE_32x2);
pixPtr = &RealMemory[ScreenSelect][Line2Pix[line]];
attrPtr = &RealMemory[ScreenSelect][Line2Attr[line]];
for (i = 0; i < COLS; i++, pixPtr++, attrPtr++, changed >>= 1)
{
if (changed & 0x1)
{
EXPAND_BOX_X(i);
attr = ((*attrPtr & FLASH) && flashPhase) ?
Reverse[*attrPtr & ~FLASH] : *attrPtr & ~FLASH;
#ifdef LIBC_MEMCPY_C32x2
MEMCPY(sp++,
(_C32x2 *)pix2color[*pixPtr >> 4] + attr,
sizeof(_C32x2));
MEMCPY(sp2++,
(_C32x2 *)pix2color[*pixPtr >> 4] + attr,
sizeof(_C32x2));
MEMCPY(sp++,
(_C32x2 *)pix2color[*pixPtr & 0x0f] + attr,
sizeof(_C32x2));
MEMCPY(sp2++,
(_C32x2 *)pix2color[*pixPtr & 0x0f] + attr,
sizeof(_C32x2));
#else
*sp2++ = *sp++ =
*((_C32x2 *)pix2color[*pixPtr >> 4] + attr);
*sp2++ = *sp++ =
*((_C32x2 *)pix2color[*pixPtr & 0x0f] + attr);
#endif
}
else
{
sp += 2;
sp2 += 2;
}
}
}
}
xImagePtr += 2 * HSIZE_32x2;
}
static void
scrLine32x3(short line)
{
uns32 *bp;
_C32x3 *sp, *sp2, *sp3;
uns8 *pixPtr, *attrPtr, attr;
uns32 changed;
short i, j;
if (line < (Machine->topBorder - BORDER_LINES)
|| line >= Machine->topBorder + Y_PIXELS + BORDER_LINES)
{
return;
}
if (line == Machine->topBorder - BORDER_LINES)
{
xImagePtr = (uns32 *)xim->data;
}
if (borderChanged)
{
borderChanged--;
if (border != *xImagePtr)
{
borderUpdate++;
bp = xImagePtr;
if (line < Machine->topBorder
|| line >= Machine->topBorder + Y_PIXELS)
{
for (i = 3 * HSIZE_32x3; i > 0; i--)
{
*bp++ = (uns32)border;
}
xImagePtr += 3 * HSIZE_32x3;
return;
}
else
{
for (j = 3; j > 0; j--)
{
for (i = BORDER_32x3; i > 0; i--)
{
*bp++ = (uns32)border;
}
bp += SCREEN_32x3;
for (i = BORDER_32x3; i > 0; i--)
{
*bp++ = (uns32)border;
}
}
goto drawScreenLine;
}
}
}
if (line >= Machine->topBorder && line < (Machine->topBorder + Y_PIXELS))
{
drawScreenLine:
if ((changed = screenChanged[line -= Machine->topBorder]))
{
screenChanged[line] = 0;
EXPAND_BOX_Y(line);
screenUpdate++;
sp = (_C32x3 *)(xImagePtr + BORDER_32x3);
sp2 = (_C32x3 *)(xImagePtr + BORDER_32x3 + HSIZE_32x3);
sp3 = (_C32x3 *)(xImagePtr + BORDER_32x3 + 2 * HSIZE_32x3);
pixPtr = &RealMemory[ScreenSelect][Line2Pix[line]];
attrPtr = &RealMemory[ScreenSelect][Line2Attr[line]];
for (i = 0; i < COLS; i++, pixPtr++, attrPtr++, changed >>= 1)
{
if (changed & 0x1)
{
EXPAND_BOX_X(i);
attr = ((*attrPtr & FLASH) && flashPhase) ?
Reverse[*attrPtr & ~FLASH] : *attrPtr & ~FLASH;
#ifdef LIBC_MEMCPY_C32x3
MEMCPY(sp++,
(_C32x3 *)pix2color[*pixPtr >> 4] + attr,
sizeof(_C32x3));
MEMCPY(sp2++,
(_C32x3 *)pix2color[*pixPtr >> 4] + attr,
sizeof(_C32x3));
MEMCPY(sp3++,
(_C32x3 *)pix2color[*pixPtr >> 4] + attr,
sizeof(_C32x3));
MEMCPY(sp++,
(_C32x3 *)pix2color[*pixPtr & 0x0f] + attr,
sizeof(_C32x3));
MEMCPY(sp2++,
(_C32x3 *)pix2color[*pixPtr & 0x0f] + attr,
sizeof(_C32x3));
MEMCPY(sp3++,
(_C32x3 *)pix2color[*pixPtr & 0x0f] + attr,
sizeof(_C32x3));
#else
*sp3++ = *sp2++ = *sp++ =
*((_C32x3 *)pix2color[*pixPtr >> 4] + attr);
*sp3++ = *sp2++ = *sp++ =
*((_C32x3 *)pix2color[*pixPtr & 0x0f] + attr);
#endif
}
else
{
sp += 2;
sp2 += 2;
sp3 += 2;
}
}
}
}
xImagePtr += 3 * HSIZE_32x3;
}
void
ScreenRefresh(void)
{
int borderWidth, middleHeight;
int flush = 0;
if (InDialog)
{
short i;
uns32 *saveXImagePtr = xImagePtr;
int saveScreenSelect = ScreenSelect;
ScreenSelect = OSD;
for (i = Machine->topBorder - BORDER_PIXELS;
i < Machine->topBorder + Y_PIXELS + BORDER_PIXELS; i++)
{
UpdateLine(i);
}
xImagePtr = saveXImagePtr;
ScreenSelect = saveScreenSelect;
}
if (!GETCFG(cache))
{
if (borderUpdate || screenUpdate)
{
borderUpdate = screenUpdate = 0;
UPDATE_IMAGE(0, 0, hsize, vsize);
flush++;
}
}
else
{
if (borderUpdate)
{
borderUpdate = 0;
borderWidth = BORDER_PIXELS * GETCFG(scale);
middleHeight = Y_PIXELS * GETCFG(scale);
UPDATE_IMAGE(0,
0,
hsize,
borderWidth);
UPDATE_IMAGE(0,
borderWidth,
borderWidth,
middleHeight);
UPDATE_IMAGE((BORDER_PIXELS + X_PIXELS) * GETCFG(scale),
borderWidth,
borderWidth,
middleHeight);
UPDATE_IMAGE(0,
(BORDER_LINES + Y_PIXELS) * GETCFG(scale),
hsize,
borderWidth);
flush++;
}
if (screenUpdate)
{
screenUpdate = 0;
UPDATE_IMAGE((BORDER_PIXELS + xMin * 8) * GETCFG(scale),
(BORDER_LINES + yMin) * GETCFG(scale),
(xMax - xMin + 1) * 8 * GETCFG(scale),
(yMax - yMin + 1) * GETCFG(scale));
MINIMIZE_BOX();
flush++;
}
}
if (flush)
{
if (GETCFG(xsync))
{
XSync(Dpy, False);
}
else
{
(void)XFlush(Dpy);
}
}
}
