/********************************************************************************
* Copyright (c) Des Herriott 1993, 1994
*               Erik Kunze   1995 - 1998
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Authors: Des Herriott
*          Erik Kunze
*******************************************************************************/
#if !defined(NO_RCSID) && !defined(lint)
static char z80_xxops_c[] = "$Id: z80_xxops.c,v 4.9 1998/11/21 17:33:12 erik Rel $";
#endif
#define ADD_XX(reg) \
{																		\
uns32 temp32 = XX + (reg);											\
uns8 idx = ((HL & 0x0800) >> 9) |									\
(((reg) & 0x0800) >> 10) |								\
((temp32 & 0x0800) >> 11);								\
XX = (uns16)temp32;													\
F = (F & (S_FLAG | Z_FLAG | V_FLAG)) |								\
(HXX & (B5_FLAG | B3_FLAG)) |									\
halfCarryTbl[idx] |												\
(temp32 & 0x10000 ? C_FLAG : 0);								\
}
case 0x09:
TSTATES += 15;
ADD_XX(BC);
break;
case 0x19:
TSTATES += 15;
ADD_XX(DE);
break;
case 0x21:
TSTATES += 14;
LXX = Z80_RDMEM(PC++);
HXX = Z80_RDMEM(PC++);
break;
case 0x22:
TSTATES += 20;
{
uns16 t16 = Z80_RDMEM(PC++);
t16 |= Z80_RDMEM(PC++) << 8;
Z80_WRMEM(t16++, LXX);
Z80_WRMEM(t16, HXX);
}
break;
case 0x23:
TSTATES += 10;
XX++;
break;
case 0x24:
TSTATES += 8;
INC(HXX);
break;
case 0x25:
TSTATES += 8;
DEC(HXX);
break;
case 0x26:
TSTATES += 11;
HXX = Z80_RDMEM(PC++);
break;
case 0x29:
TSTATES += 15;
ADD_XX(XX);
break;
case 0x2A:
TSTATES += 20;
{
uns16 t16 = Z80_RDMEM(PC++);
t16 |= Z80_RDMEM(PC++) << 8;
LXX = Z80_RDMEM(t16++);
HXX = Z80_RDMEM(t16);
}
break;
case 0x2B:
TSTATES += 10;
XX--;
break;
case 0x2C:
TSTATES += 8;
INC(LXX);
break;
case 0x2D:
TSTATES += 8;
DEC(LXX);
break;
case 0x2E:
TSTATES += 11;
LXX = Z80_RDMEM(PC++);
break;
case 0x34:
TSTATES += 23;
{
uns16 t16 = XX + (sgn8)Z80_RDMEM(PC++);
uns8 t8 = Z80_RDMEM(t16);
INC(t8);
Z80_WRMEM(t16, t8);
}
break;
case 0x35:
TSTATES += 23;
{
uns16 t16 = XX + (sgn8)Z80_RDMEM(PC++);
uns8 t8 = Z80_RDMEM(t16);
DEC(t8);
Z80_WRMEM(t16, t8);
}
break;
case 0x36:
TSTATES += 19;
{
uns16 t16 = XX + (sgn8)Z80_RDMEM(PC++);
Z80_WRMEM(t16, Z80_RDMEM(PC++));
}
break;
case 0x39:
TSTATES += 15;
ADD_XX(SP);
break;
case 0x44:
TSTATES += 8;
B = HXX;
break;
case 0x45:
TSTATES += 8;
B = LXX;
break;
case 0x46:
TSTATES += 19;
B = Z80_RDMEM(XX + (sgn8)Z80_RDMEM(PC++));
break;
case 0x4C:
TSTATES += 8;
C = HXX;
break;
case 0x4D:
TSTATES += 8;
C = LXX;
break;
case 0x4E:
TSTATES += 19;
C = Z80_RDMEM(XX + (sgn8)Z80_RDMEM(PC++));
break;
case 0x54:
TSTATES += 8;
D = HXX;
break;
case 0x55:
TSTATES += 8;
D = LXX;
break;
case 0x56:
TSTATES += 19;
D = Z80_RDMEM(XX + (sgn8)Z80_RDMEM(PC++));
break;
case 0x5C:
TSTATES += 8;
E = HXX;
break;
case 0x5D:
TSTATES += 8;
E = LXX;
break;
case 0x5E:
TSTATES += 19;
E = Z80_RDMEM(XX + (sgn8)Z80_RDMEM(PC++));
break;
case 0x60:
TSTATES += 8;
HXX = B;
break;
case 0x61:
TSTATES += 8;
HXX = C;
break;
case 0x62:
TSTATES += 8;
HXX = D;
break;
case 0x63:
TSTATES += 8;
HXX = E;
break;
case 0x64:
TSTATES += 8;
break;
case 0x65:
TSTATES += 8;
HXX = LXX;
break;
case 0x66:
TSTATES += 19;
H = Z80_RDMEM(XX + (sgn8)Z80_RDMEM(PC++));
break;
case 0x67:
TSTATES += 8;
HXX = A;
break;
case 0x68:
TSTATES += 8;
LXX = B;
break;
case 0x69:
TSTATES += 8;
LXX = C;
break;
case 0x6A:
TSTATES += 8;
LXX = D;
break;
case 0x6B:
TSTATES += 8;
LXX = E;
break;
case 0x6C:
TSTATES += 8;
LXX = HXX;
break;
case 0x6D:
TSTATES += 8;
break;
case 0x6E:
TSTATES += 19;
L = Z80_RDMEM(XX + (sgn8)Z80_RDMEM(PC++));
break;
case 0x6F:
TSTATES += 8;
LXX = A;
break;
case 0x70:
TSTATES += 19;
Z80_WRMEM(XX + (sgn8)Z80_RDMEM(PC++), B);
break;
case 0x71:
TSTATES += 19;
Z80_WRMEM(XX + (sgn8)Z80_RDMEM(PC++), C);
break;
case 0x72:
TSTATES += 19;
Z80_WRMEM(XX + (sgn8)Z80_RDMEM(PC++), D);
break;
case 0x73:
TSTATES += 19;
Z80_WRMEM(XX + (sgn8)Z80_RDMEM(PC++), E);
break;
case 0x74:
TSTATES += 19;
Z80_WRMEM(XX + (sgn8)Z80_RDMEM(PC++), H);
break;
case 0x75:
TSTATES += 19;
Z80_WRMEM(XX + (sgn8)Z80_RDMEM(PC++), L);
break;
case 0x77:
TSTATES += 19;
Z80_WRMEM(XX + (sgn8)Z80_RDMEM(PC++), A);
break;
case 0x7C:
TSTATES += 8;
A = HXX;
break;
case 0x7D:
TSTATES += 8;
A = LXX;
break;
case 0x7E:
TSTATES += 19;
A = Z80_RDMEM(XX + (sgn8)Z80_RDMEM(PC++));
break;
case 0x84:
TSTATES += 8;
ADD(HXX);
break;
case 0x85:
TSTATES += 8;
ADD(LXX);
break;
case 0x86:
TSTATES += 19;
{
uns8 t8 = Z80_RDMEM(XX + (sgn8)Z80_RDMEM(PC++));
ADD(t8);
}
break;
case 0x8C:
TSTATES += 8;
ADC(HXX);
break;
case 0x8D:
TSTATES += 8;
ADC(LXX);
break;
case 0x8E:
TSTATES += 19;
{
uns8 t8 = Z80_RDMEM(XX + (sgn8)Z80_RDMEM(PC++));
ADC(t8);
}
break;
case 0x94:
TSTATES += 8;
SUB(HXX);
break;
case 0x95:
TSTATES += 8;
SUB(LXX);
break;
case 0x96:
TSTATES += 19;
{
uns8 t8 = Z80_RDMEM(XX + (sgn8)Z80_RDMEM(PC++));
SUB(t8);
}
break;
case 0x9C:
TSTATES += 8;
SBC(HXX);
break;
case 0x9D:
TSTATES += 8;
SBC(LXX);
break;
case 0x9E:
TSTATES += 19;
{
uns8 t8 = Z80_RDMEM(XX + (sgn8)Z80_RDMEM(PC++));
SBC(t8);
}
break;
case 0xA4:
TSTATES += 8;
AND(HXX);
break;
case 0xA5:
TSTATES += 8;
AND(LXX);
break;
case 0xA6:
TSTATES += 19;
{
uns8 t8 = Z80_RDMEM(XX + (sgn8)Z80_RDMEM(PC++));
AND(t8);
}
break;
case 0xAC:
TSTATES += 8;
XOR(HXX);
break;
case 0xAD:
TSTATES += 8;
XOR(LXX);
break;
case 0xAE:
TSTATES += 19;
{
uns8 t8 = Z80_RDMEM(XX + (sgn8)Z80_RDMEM(PC++));
XOR(t8);
}
break;
case 0xB4:
TSTATES += 8;
OR(HXX);
break;
case 0xB5:
TSTATES += 8;
OR(LXX);
break;
case 0xB6:
TSTATES += 19;
{
uns8 t8 = Z80_RDMEM(XX + (sgn8)Z80_RDMEM(PC++));
OR(t8);
}
break;
case 0xBC:
TSTATES += 8;
CMP(HXX);
break;
case 0xBD:
TSTATES += 8;
CMP(LXX);
break;
case 0xBE:
TSTATES += 19;
{
uns8 t8 = Z80_RDMEM(XX + (sgn8)Z80_RDMEM(PC++));
CMP(t8);
}
break;
case 0xCB:
{
uns16 tXX = XX + (sgn8)Z80_RDMEM(PC++);
op = Z80_RDOP2(PC++);
switch(op)
{
#			include "z80_xxcbops.c"
}
}
break;
case 0xE1:
TSTATES += 14;
POP(HXX, LXX);
break;
case 0xE3:
TSTATES += 23;
{
uns8 t8 = Z80_RDMEM(SP); Z80_WRMEM(SP, LXX); LXX = t8;
t8 = Z80_RDMEM(SP + 1); Z80_WRMEM(SP + 1, HXX); HXX = t8;
}
break;
case 0xE5:
TSTATES += 15;
PUSH(HXX, LXX);
break;
case 0xE9:
TSTATES += 8;
PC = XX;
break;
case 0xF9:
TSTATES += 10;
SP = XX;
break;
case 0xDD:
case 0xFD:
TSTATES += 4;
DEC_R();
PC--;
break;
default:
TSTATES += 4;
DEC_R();
PC--;
#ifdef DEBUG
if(GETCFG(debug) & D_ILLOPS)
{
Msg(M_DEBUG, "unimplemented instruction %02X %02X at <%04x>",
Z80_RDMEM(PC - 1), Z80_RDMEM(PC), PC - 1);
}
#endif
break;
#undef ADD_XX
