# Support code that may be used in debian/rules
# Alastair McKinstry <mckinstry@debian.org>
# 2025-06-13

include /usr/share/dpkg/buildflags.mk
include /usr/share/dpkg/architecture.mk

# WARNING: THIS CODE IS EXPERIMENTAL AND IN HIGH FLUX

# This will set:
#	FC_DEFAULT : the default compiler flavor
#	FC_OPTIONAL : a space seperated list of compiler flavors present except FC_DEFAULT

# FC_DEFAULT is /etc/alternatives/f95 unless FC is specified in the environment

# FC flavors: shortnames for Fortran compilers, currently in Trixie:
#  gfortran flang flangext lfortran flang18 flangext18 flang19 flangext19

# FC=f77 as a default in Make. The fortran-support.mk  sets FC_DEFAULT as a proper compiler flavor
# but get_fmoddir(f77) not properly defined, so don't call with FC=f77
# as a hack, f77 is presumed to be gfortran


# Matches dh-golang convention
#ifndef BUILDDIR
# BUILDDIR:=_build
#endif
#ifndef DESTDIR
# DESTDIR:=debian/tmp
#endif

ifeq ($(origin F77),default)
  F77:=$(shell basename $(shell readlink /etc/alternatives/f77))
endif
ifeq ($(origin FC),environment)
  FC_DEFAULT:=$(FC)
endif
ifeq ($(origin FC),default)
  FC_DEFAULT:=$(shell basename $(shell readlink /etc/alternatives/f95))
endif

FC_OPTIONAL=$(shell dh_fortran get_fc_optional)

# Functions: take flavor as parameter


# TODO: This should strip arch from eg aarch64-linux-gnu-gfortran-14
_ARCH:=$(shell echo $(FC)| sed -r 's%(.*)-(.*)%\1 %' )
_SUFF:=$(shell echo $(FC)| sed -r 's%(.*)-(.*)%\2 %' )
ifeq ($(_ARCH),$(_SUFF))
  _ARCH:=${DEB_HOST_MULTIARCH}
else
  FC:=$(_SUFF)
endif
fort_root = /usr/lib/$(strip $(_ARCH))/fortran

# Install in this directory
get_fmoddir = $(shell dh_fortran get_fmoddir)

# Compatible modules for include search. Directories may not be present
get_fmoddirs = $(if $(filter $1,gfortran),  -I$(call fort_root,$1)/gfortran-mod-15 -I$(call fort_root,$1)/flangext-mod-15, \
			   $(if $(filter $1,f77), -I$(call fort_root,$1)/gfortran-mod-15 -I$(call fort_root,$1)/flangext-mod-15, \
			   $(if $(filter $1,gfortran-14), -I$(call fort_root,$1)/gfortran-mod-15 -I$(call fort_root,$1)/flangext-mod-15, \
			   $(if $(filter $1,gfortran-15), -I$(call fort_root,$1)/gfortran-mod-15 -I$(call fort_root,$1)/flangext-mod-16, \
		   $(if $(filter $1, flang),	-I$(call fort_root,$1)/flang-mod-19, \
		   $(if $(filter $1, flang-new-17),	-I$(call fort_root,$1)/flang-mod-17, \
		   $(if $(filter $1, flang-new-18),	-I$(call fort_root,$1)/flang-mod-18, \
		   $(if $(filter $1, flang-new-19),	-I$(call fort_root,$1)/flang-mod-19, \
		   $(if $(filter $1, flang-new-20),	-I$(call fort_root,$1)/flang-mod-20, \
		   $(if $(filter $1, flangext), -I$(call fort_root,$1)/flangext-mod-18 -I$(call fort_root,$1)/gfortran-mod-15, \
		   $(if $(filter $1, flang-to-external-fc-18), -I$(call fort_root,$1)/flangext-mod-15 -I$(call fort_root,$1)/gfortran-mod-15, \
		   $(if $(filter $1, lfortran), -I$(call fort_root,$1)/lfortran-mod-0, \
						-I$(call fort_root,$1)/$1 ))))))))))))


_to_label=$(shell echo  "$1" | sed -e 's/\(.*\)/\U\1/' -e 's/\-//')
_to_vendor=$(shell echo  "$1" | sed -e 's/[0-9\-].*//' )

### Support code for configure/build.
### Assuming dh_X_fortran_TEMPLATE is defined, use that to build / configure
### Must succeed on FC_DEFAULT, may fail on FC_OPTIONAL compilers
### (for capturing details in logs )

# Potentially add others if $FC is set (eg ifx, Arm)

# TODO: improve on "-f debian/rules"
define dh_fortran_RECURSE =
 dh_$(1)_fortran_$(2)_nofail:
	@echo DEBUGF RECURSE into dh_$(1)_fortran_$(2)
	@($(MAKE) -f debian/rules dh_$(1)_fortran_$(2) || echo " FAILURE IGNORED")
	@echo DEBUGF LEAVING dh_$(1)_fortran_$(2)_nofail
endef

# This will iterate over targets and recursively call make but to always succeed
define foreach_fc_dot =
  $(foreach f, $(FC_DEFAULT) $(FC_OPTIONAL), $(eval $(call dh_$(1)_fortran_TEMPLATE,$(f))))
  $(foreach f, $(FC_OPTIONAL) , $(eval $(call dh_fortran_RECURSE,$(1),$(f))))
endef

define foreach_fc_execute_before =
  $(eval $(call foreach_fc_dot,$(1)))
  execute_before_dh_auto_$(1): $(foreach FC_FLAVOR, $(FC_DEFAULT), dh_$(1)_fortran_$(FC_FLAVOR)) $(foreach FC_FLAVOR, $(FC_OPTIONAL), dh_$(1)_fortran_$(FC_FLAVOR)_nofail)
endef

define foreach_fc_execute_after =
  $(eval $(call foreach_fc_dot,$(1)))
  execute_after_dh_auto_$(1): $(foreach FC_FLAVOR, $(FC_DEFAULT), dh_$(1)_fortran_$(FC_FLAVOR)) $(foreach FC_FLAVOR, $(FC_OPTIONAL), dh_$(1)_fortran_$(FC_FLAVOR)_nofail)
endef

#define dh_clean_fortran_TEMPLATE =
#  dh_clean_fortran_$(1):
#	rm -rf $(BUILDDIR)-$(1) $(DESTDIR)-$(1)
#endef
#$(eval $(call foreach_fc_execute_before,clean))
#
#define dh_build_fortran_TEMPLATE =
#  dh_build_fortran_$(1):
#		dh_auto_build --builddirectory=${BUILDDIR}-$(1)
#endef
#$(eval $(call foreach_fc_execute_before,build))

# Default. TODO: This works for cmake. Produce other version?

define dh_configure_fortran_TEMPLATE =
  dh_configure_fortran_$(1):
	FFLAGS=`dh_fortran get_fc_flags --fc $(1)`  \
	LDFLAGS=`dh_fortran get_ld_flags --fc $(1)`  \
	dh_auto_configure --builddirectory=${BUILDDIR}-$(1)  -- \
			${BUILD_FLAGS} \
			-DCMAKE_Fortran_COMPILER=$(1) 
endef

define dh_test_fortran_TEMPLATE =
  dh_test_fortran_$(1):
ifeq (,$(filter nocheck,$(DEB_BUILD_OPTIONS)))
		(LD_LIBRARY_PATH=$(BUILDDIR)-$(1)/lib dh_auto_test --builddirectory=$(BUILDDIR)-$(1) || true)
endif
endef
