/*
 ----------------------------------------------------------------------------
 |    Copyright (C) 1999   Raytheon Systems Company                         |
 ----------------------------------------------------------------------------
 */

#include     <HE5_HdfEosDef.h>
#include     "string.h"

/*
 * In this example we will open an HDF-EOS file and try to read 
 * a  metadata into buffer. User can read any Metadata dataset
 * (similar to StructMetadata written to "HDFEOS INFORMATION" group
 * The we will write that metadata into stdout and into input he5file
 * with a different name.
 */


int main()
{
  herr_t          status = FAIL;

  hid_t           gdfid = FAIL;
  char            MetadataName[32]="";
  char            *metabuf;
  long            bufferSize;
  long            strbufsize = 0;
  char           *metadatanames = NULL;
  long            nmeta;
  char           *coremeta=NULL;
  /*
   * We first open the HDF-EOS grid file, "Grid.h5".  This file
   * already exist and we wish to read from it, we use the H5F_ACC_RDWR access
   * code in the open statement.  The HE5_GDopen routine returns the grid file
   * id, gdfid, which is used to identify the file in subsequent routines.
   */ 
  //strcpy(MetadataName, "StructMetadata");
  strcpy(MetadataName, "iso_19139_dataset_xml");
  /*
  gdfid = HE5_GDopen("Grid.h5", H5F_ACC_RDWR);
  */
  /* before running this test sample copy SMAP_L2_SM_P_WithLrageMetadataInHdfeosInformation.he5 
     to
     temp_SMAP_L2_SM_P_WithLrageMetadataInHdfeosInformation.he5 and change its permissions 
     to make it writable.
  */
  gdfid = HE5_GDopen("temp_SMAP_L2_SM_P_WithLrageMetadataInHdfeosInformation.he5", H5F_ACC_RDWR);
  
  if (gdfid != FAIL)
    {
      nmeta = HE5_EHinqmetadatas(gdfid, NULL, &strbufsize);
      
      printf(" Number of ASCII datasets in HDFEOS INFORMATION group = %d\n",(int)nmeta);
      printf(" Size of buffer for all metadata names = %d\n",(int)strbufsize);
      metadatanames = (char *)malloc((strbufsize+1)*sizeof(char));
      nmeta = HE5_EHinqmetadatas(gdfid, metadatanames, &strbufsize);
      printf(" metadatanames= %s\n",metadatanames);

      /*
       * If the grid file cannot be found, HE5_GDopen 
       * will return -1 for the file handle (gdfid). We
       * there check that this is not the case before
       * proceeding with the other routines.
       * 
       */ 

      status = HE5_EHreadmeta(gdfid, MetadataName, NULL, &bufferSize); 
      printf("Metadata bufferSize = %d\n",(int)bufferSize);
      metabuf = (char *)malloc((bufferSize+1)*sizeof(char));
      strcpy(metabuf, "");
      status = HE5_EHreadmeta(gdfid, MetadataName, metabuf, &bufferSize); 
 
      if (status == -1)
	{
	  printf("\t\tError: Cannot read %s metadata\n", MetadataName);
	  HE5_GDclose(gdfid);
	  return -1;
	}
      else
	{
	  coremeta = (char *)malloc((strlen(MetadataName)+1)*sizeof(char));
	  strcpy(coremeta, MetadataName);
	  printf("\n writing METADATA = %s to input he5 file:\n",MetadataName);
	  status = HE5_EHwritemeta(gdfid, "CoreMetadata", metabuf);
	  printf("\n wrote METADATA = %s :\n",MetadataName);
	  printf("%s\n", metabuf);
	}
    }
	
  HE5_GDclose(gdfid);
  free(metabuf);
  return 0;
}

