/* build_tools_preferences.c generated by valac 0.32.0.71-d187, the Vala compiler
 * generated from build_tools_preferences.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2012-2015 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */
/* The preferences of the default and personal build tools.*/
/* For the configuration of a single build tool, see build_tool_dialog.vala.*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <latexila.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_BUILD_TOOLS_PREFERENCES (build_tools_preferences_get_type ())
#define BUILD_TOOLS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferences))
#define BUILD_TOOLS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferencesClass))
#define IS_BUILD_TOOLS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOLS_PREFERENCES))
#define IS_BUILD_TOOLS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOLS_PREFERENCES))
#define BUILD_TOOLS_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferencesClass))

typedef struct _BuildToolsPreferences BuildToolsPreferences;
typedef struct _BuildToolsPreferencesClass BuildToolsPreferencesClass;
typedef struct _BuildToolsPreferencesPrivate BuildToolsPreferencesPrivate;

#define BUILD_TOOLS_PREFERENCES_TYPE_BUILD_TOOL_COLUMN (build_tools_preferences_build_tool_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
#define __g_list_free__gtk_tree_path_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_tree_path_free0_ (var), NULL)))
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_BUILD_TOOL_DIALOG (build_tool_dialog_get_type ())
#define BUILD_TOOL_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOL_DIALOG, BuildToolDialog))
#define BUILD_TOOL_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOL_DIALOG, BuildToolDialogClass))
#define IS_BUILD_TOOL_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOL_DIALOG))
#define IS_BUILD_TOOL_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOL_DIALOG))
#define BUILD_TOOL_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOL_DIALOG, BuildToolDialogClass))

typedef struct _BuildToolDialog BuildToolDialog;
typedef struct _BuildToolDialogClass BuildToolDialogClass;
typedef struct _Block8Data Block8Data;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;

struct _BuildToolsPreferences {
	GObject parent_instance;
	BuildToolsPreferencesPrivate * priv;
};

struct _BuildToolsPreferencesClass {
	GObjectClass parent_class;
};

struct _BuildToolsPreferencesPrivate {
	GtkDialog* _dialog;
	GtkListStore* _default_store;
	GtkListStore* _personal_store;
	GtkTreeView* _default_view;
	GtkTreeView* _personal_view;
};

typedef enum  {
	BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED,
	BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_PIXBUF,
	BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_LABEL,
	BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_DESCRIPTION,
	BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_N_COLUMNS
} BuildToolsPreferencesBuildToolColumn;

struct _Block4Data {
	int _ref_count_;
	BuildToolsPreferences* self;
	GtkTreeSelection* default_select;
	GtkTreeSelection* personal_select;
};

struct _Block5Data {
	int _ref_count_;
	BuildToolsPreferences* self;
	GtkTreeViewColumn* label_column;
	GtkListStore* store;
	LatexilaBuildTools* build_tools;
};

struct _Block6Data {
	int _ref_count_;
	BuildToolsPreferences* self;
	GtkTreeView* view;
	LatexilaBuildTools* build_tools;
};

struct _Block7Data {
	int _ref_count_;
	BuildToolsPreferences* self;
	GtkTreeView* view;
	LatexilaBuildTools* build_tools;
};

struct _Block8Data {
	int _ref_count_;
	BuildToolsPreferences* self;
	GtkToolButton* up_button;
	GtkTreeSelection* select;
};

struct _Block9Data {
	int _ref_count_;
	BuildToolsPreferences* self;
	GtkToolButton* down_button;
	GtkTreeSelection* select;
};

struct _Block10Data {
	int _ref_count_;
	BuildToolsPreferences* self;
	GtkTreeSelection* select;
	GtkWidget* widget;
};


static gpointer build_tools_preferences_parent_class = NULL;

GType build_tools_preferences_get_type (void) G_GNUC_CONST;
#define BUILD_TOOLS_PREFERENCES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferencesPrivate))
enum  {
	BUILD_TOOLS_PREFERENCES_DUMMY_PROPERTY
};
static GType build_tools_preferences_build_tool_column_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
BuildToolsPreferences* build_tools_preferences_new (GtkWindow* parent_window);
BuildToolsPreferences* build_tools_preferences_construct (GType object_type, GtkWindow* parent_window);
static GtkListStore* build_tools_preferences_get_new_store (BuildToolsPreferences* self);
static void build_tools_preferences_update_default_store (BuildToolsPreferences* self);
static void build_tools_preferences_update_personal_store (BuildToolsPreferences* self);
static void build_tools_preferences_init_views (BuildToolsPreferences* self);
static GtkWidget* build_tools_preferences_get_default_grid (BuildToolsPreferences* self);
static GtkWidget* build_tools_preferences_get_personal_grid (BuildToolsPreferences* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static GtkTreeView* build_tools_preferences_get_new_view (BuildToolsPreferences* self, GtkListStore* store, LatexilaBuildTools* build_tools);
static void __lambda119_ (Block4Data* _data4_);
static void build_tools_preferences_on_view_selection_changed (BuildToolsPreferences* self, GtkTreeSelection* select, GtkTreeSelection* other_select);
static void ___lambda119__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static void __lambda120_ (Block4Data* _data4_);
static void ___lambda120__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static GtkToolButton* build_tools_preferences_get_properties_button (BuildToolsPreferences* self, GtkTreeView* view, LatexilaBuildTools* build_tools, gboolean read_only);
static GtkToolButton* build_tools_preferences_get_copy_button (BuildToolsPreferences* self, GtkTreeView* view, LatexilaBuildTools* build_tools);
static GtkWidget* build_tools_preferences_join_view_and_toolbar (BuildToolsPreferences* self, GtkTreeView* view, GtkToolbar* toolbar);
static GtkToolButton* build_tools_preferences_get_add_button (BuildToolsPreferences* self);
static GtkToolButton* build_tools_preferences_get_remove_button (BuildToolsPreferences* self);
static GtkToolButton* build_tools_preferences_get_up_button (BuildToolsPreferences* self);
static GtkToolButton* build_tools_preferences_get_down_button (BuildToolsPreferences* self);
GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda108_ (Block5Data* _data5_, const gchar* path_string);
static void ___lambda108__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self);
static void __lambda109_ (Block5Data* _data5_, GtkTreePath* path, GtkTreeViewColumn* column);
static void build_tools_preferences_open_build_tool (BuildToolsPreferences* self, LatexilaBuildTools* build_tools, gint build_tool_num);
static void ___lambda109__gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static void _gtk_tree_path_free0_ (gpointer var);
static void _g_list_free__gtk_tree_path_free0_ (GList* self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void build_tools_preferences_set_sensitivity_on_selection (BuildToolsPreferences* self, GtkTreeView* view, GtkWidget* widget);
static void __lambda122_ (Block6Data* _data6_);
gint utils_get_selected_row (GtkTreeView* view, GtkTreeIter* iter);
static void ___lambda122__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda123_ (Block7Data* _data7_);
static void ___lambda123__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda124_ (BuildToolsPreferences* self);
GType build_tool_dialog_get_type (void) G_GNUC_CONST;
BuildToolDialog* build_tool_dialog_new (GtkWindow* parent, gboolean editable);
BuildToolDialog* build_tool_dialog_construct (GType object_type, GtkWindow* parent, gboolean editable);
gboolean build_tool_dialog_create_personal_build_tool (BuildToolDialog* self);
static void ___lambda124__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda125_ (BuildToolsPreferences* self);
static void ___lambda125__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda126_ (Block8Data* _data8_);
static void ___lambda126__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static void __lambda127_ (Block8Data* _data8_);
gboolean utils_tree_model_iter_prev (GtkTreeModel* model, GtkTreeIter* iter);
static void ___lambda127__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda128_ (Block9Data* _data9_);
static void ___lambda128__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static void __lambda129_ (Block9Data* _data9_);
static void ___lambda129__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void build_tools_preferences_update_store (BuildToolsPreferences* self, GtkListStore* store, LatexilaBuildTools* build_tools);
gboolean build_tool_dialog_open_build_tool (BuildToolDialog* self, LatexilaBuildTools* build_tools, gint build_tool_num);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void __lambda121_ (Block10Data* _data10_);
static void ___lambda121__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static void build_tools_preferences_finalize (GObject* obj);


static GType build_tools_preferences_build_tool_column_get_type (void) {
	static volatile gsize build_tools_preferences_build_tool_column_type_id__volatile = 0;
	if (g_once_init_enter (&build_tools_preferences_build_tool_column_type_id__volatile)) {
		static const GEnumValue values[] = {{BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED, "BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED", "enabled"}, {BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_PIXBUF, "BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_PIXBUF", "pixbuf"}, {BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_LABEL, "BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_LABEL", "label"}, {BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_DESCRIPTION, "BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_DESCRIPTION", "description"}, {BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_N_COLUMNS, "BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType build_tools_preferences_build_tool_column_type_id;
		build_tools_preferences_build_tool_column_type_id = g_enum_register_static ("BuildToolsPreferencesBuildToolColumn", values);
		g_once_init_leave (&build_tools_preferences_build_tool_column_type_id__volatile, build_tools_preferences_build_tool_column_type_id);
	}
	return build_tools_preferences_build_tool_column_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


BuildToolsPreferences* build_tools_preferences_construct (GType object_type, GtkWindow* parent_window) {
	BuildToolsPreferences * self = NULL;
	GtkListStore* _tmp0_ = NULL;
	GtkListStore* _tmp1_ = NULL;
	GObject* _tmp2_ = NULL;
	GObject* _tmp3_ = NULL;
	GtkDialog* _tmp4_ = NULL;
	GtkDialog* _tmp5_ = NULL;
	GtkWindow* _tmp6_ = NULL;
	GtkDialog* _tmp7_ = NULL;
	GtkDialog* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GtkGrid* hgrid = NULL;
	GtkGrid* _tmp10_ = NULL;
	GtkWidget* _tmp11_ = NULL;
	GtkWidget* _tmp12_ = NULL;
	GtkWidget* _tmp13_ = NULL;
	GtkWidget* _tmp14_ = NULL;
	GtkBox* content_area = NULL;
	GtkDialog* _tmp15_ = NULL;
	GtkBox* _tmp16_ = NULL;
	GtkBox* _tmp17_ = NULL;
	GtkDialog* _tmp18_ = NULL;
	GtkDialog* _tmp19_ = NULL;
	LatexilaBuildToolsPersonal* _tmp20_ = NULL;
	g_return_val_if_fail (parent_window != NULL, NULL);
	self = (BuildToolsPreferences*) g_object_new (object_type, NULL);
	_tmp0_ = build_tools_preferences_get_new_store (self);
	_g_object_unref0 (self->priv->_default_store);
	self->priv->_default_store = _tmp0_;
	_tmp1_ = build_tools_preferences_get_new_store (self);
	_g_object_unref0 (self->priv->_personal_store);
	self->priv->_personal_store = _tmp1_;
	build_tools_preferences_update_default_store (self);
	build_tools_preferences_update_personal_store (self);
	build_tools_preferences_init_views (self);
	_tmp2_ = g_object_new (gtk_dialog_get_type (), "use-header-bar", TRUE, NULL, NULL);
	_tmp3_ = G_IS_INITIALLY_UNOWNED (_tmp2_) ? g_object_ref_sink (_tmp2_) : _tmp2_;
	_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp3_) : NULL;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (_tmp3_);
	}
	_g_object_unref0 (self->priv->_dialog);
	self->priv->_dialog = _tmp4_;
	_tmp5_ = self->priv->_dialog;
	_tmp6_ = parent_window;
	gtk_window_set_transient_for ((GtkWindow*) _tmp5_, _tmp6_);
	_tmp7_ = self->priv->_dialog;
	gtk_window_set_destroy_with_parent ((GtkWindow*) _tmp7_, TRUE);
	_tmp8_ = self->priv->_dialog;
	_tmp9_ = _ ("Build Tools");
	gtk_window_set_title ((GtkWindow*) _tmp8_, _tmp9_);
	_tmp10_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp10_);
	hgrid = _tmp10_;
	gtk_orientable_set_orientation ((GtkOrientable*) hgrid, GTK_ORIENTATION_HORIZONTAL);
	gtk_grid_set_column_spacing (hgrid, (guint) 10);
	_tmp11_ = build_tools_preferences_get_default_grid (self);
	_tmp12_ = _tmp11_;
	gtk_container_add ((GtkContainer*) hgrid, _tmp12_);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = build_tools_preferences_get_personal_grid (self);
	_tmp14_ = _tmp13_;
	gtk_container_add ((GtkContainer*) hgrid, _tmp14_);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = self->priv->_dialog;
	_tmp16_ = (GtkBox*) gtk_dialog_get_content_area (_tmp15_);
	_tmp17_ = _g_object_ref0 (_tmp16_);
	content_area = _tmp17_;
	gtk_box_pack_start (content_area, (GtkWidget*) hgrid, TRUE, TRUE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) content_area);
	_tmp18_ = self->priv->_dialog;
	gtk_dialog_run (_tmp18_);
	_tmp19_ = self->priv->_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp19_);
	_tmp20_ = latexila_build_tools_personal_get_instance ();
	latexila_build_tools_personal_save (_tmp20_);
	_g_object_unref0 (content_area);
	_g_object_unref0 (hgrid);
	return self;
}


BuildToolsPreferences* build_tools_preferences_new (GtkWindow* parent_window) {
	return build_tools_preferences_construct (TYPE_BUILD_TOOLS_PREFERENCES, parent_window);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		BuildToolsPreferences* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->personal_select);
		_g_object_unref0 (_data4_->default_select);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static void __lambda119_ (Block4Data* _data4_) {
	BuildToolsPreferences* self;
	self = _data4_->self;
	build_tools_preferences_on_view_selection_changed (self, _data4_->default_select, _data4_->personal_select);
}


static void ___lambda119__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	__lambda119_ (self);
}


static void __lambda120_ (Block4Data* _data4_) {
	BuildToolsPreferences* self;
	self = _data4_->self;
	build_tools_preferences_on_view_selection_changed (self, _data4_->personal_select, _data4_->default_select);
}


static void ___lambda120__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	__lambda120_ (self);
}


static void build_tools_preferences_init_views (BuildToolsPreferences* self) {
	Block4Data* _data4_;
	GtkListStore* _tmp0_ = NULL;
	LatexilaBuildToolsDefault* _tmp1_ = NULL;
	GtkTreeView* _tmp2_ = NULL;
	GtkListStore* _tmp3_ = NULL;
	LatexilaBuildToolsPersonal* _tmp4_ = NULL;
	GtkTreeView* _tmp5_ = NULL;
	GtkTreeView* _tmp6_ = NULL;
	GtkTreeSelection* _tmp7_ = NULL;
	GtkTreeSelection* _tmp8_ = NULL;
	GtkTreeView* _tmp9_ = NULL;
	GtkTreeSelection* _tmp10_ = NULL;
	GtkTreeSelection* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = self->priv->_default_store;
	_tmp1_ = latexila_build_tools_default_get_instance ();
	_tmp2_ = build_tools_preferences_get_new_view (self, _tmp0_, (LatexilaBuildTools*) _tmp1_);
	_g_object_unref0 (self->priv->_default_view);
	self->priv->_default_view = _tmp2_;
	_tmp3_ = self->priv->_personal_store;
	_tmp4_ = latexila_build_tools_personal_get_instance ();
	_tmp5_ = build_tools_preferences_get_new_view (self, _tmp3_, (LatexilaBuildTools*) _tmp4_);
	_g_object_unref0 (self->priv->_personal_view);
	self->priv->_personal_view = _tmp5_;
	_tmp6_ = self->priv->_default_view;
	_tmp7_ = gtk_tree_view_get_selection (_tmp6_);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_data4_->default_select = _tmp8_;
	_tmp9_ = self->priv->_personal_view;
	_tmp10_ = gtk_tree_view_get_selection (_tmp9_);
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_data4_->personal_select = _tmp11_;
	g_signal_connect_data (_data4_->default_select, "changed", (GCallback) ___lambda119__gtk_tree_selection_changed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	g_signal_connect_data (_data4_->personal_select, "changed", (GCallback) ___lambda120__gtk_tree_selection_changed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}


static GtkWidget* build_tools_preferences_get_default_grid (BuildToolsPreferences* self) {
	GtkWidget* result = NULL;
	LatexilaBuildTools* default_build_tools = NULL;
	LatexilaBuildToolsDefault* _tmp0_ = NULL;
	LatexilaBuildTools* _tmp1_ = NULL;
	GtkToolButton* properties_button = NULL;
	GtkTreeView* _tmp2_ = NULL;
	GtkToolButton* _tmp3_ = NULL;
	GtkToolButton* copy_button = NULL;
	GtkTreeView* _tmp4_ = NULL;
	GtkToolButton* _tmp5_ = NULL;
	GtkToolbar* toolbar = NULL;
	GtkToolbar* _tmp6_ = NULL;
	GtkWidget* join = NULL;
	GtkTreeView* _tmp7_ = NULL;
	GtkWidget* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GtkWidget* _tmp10_ = NULL;
	GtkWidget* _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = latexila_build_tools_default_get_instance ();
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, latexila_build_tools_get_type ()) ? ((LatexilaBuildTools*) _tmp0_) : NULL);
	default_build_tools = _tmp1_;
	_tmp2_ = self->priv->_default_view;
	_tmp3_ = build_tools_preferences_get_properties_button (self, _tmp2_, default_build_tools, TRUE);
	properties_button = _tmp3_;
	_tmp4_ = self->priv->_default_view;
	_tmp5_ = build_tools_preferences_get_copy_button (self, _tmp4_, default_build_tools);
	copy_button = _tmp5_;
	_tmp6_ = (GtkToolbar*) gtk_toolbar_new ();
	g_object_ref_sink (_tmp6_);
	toolbar = _tmp6_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) properties_button, -1);
	gtk_toolbar_insert (toolbar, (GtkToolItem*) copy_button, -1);
	_tmp7_ = self->priv->_default_view;
	_tmp8_ = build_tools_preferences_join_view_and_toolbar (self, _tmp7_, toolbar);
	join = _tmp8_;
	_tmp9_ = _ ("Default Build Tools");
	_tmp10_ = latexila_utils_get_dialog_component (_tmp9_, join);
	_tmp11_ = _g_object_ref0 (_tmp10_);
	result = _tmp11_;
	_g_object_unref0 (join);
	_g_object_unref0 (toolbar);
	_g_object_unref0 (copy_button);
	_g_object_unref0 (properties_button);
	_g_object_unref0 (default_build_tools);
	return result;
}


static GtkWidget* build_tools_preferences_get_personal_grid (BuildToolsPreferences* self) {
	GtkWidget* result = NULL;
	LatexilaBuildTools* personal_build_tools = NULL;
	LatexilaBuildToolsPersonal* _tmp0_ = NULL;
	LatexilaBuildTools* _tmp1_ = NULL;
	GtkToolButton* properties_button = NULL;
	GtkTreeView* _tmp2_ = NULL;
	GtkToolButton* _tmp3_ = NULL;
	GtkToolButton* copy_button = NULL;
	GtkTreeView* _tmp4_ = NULL;
	GtkToolButton* _tmp5_ = NULL;
	GtkToolbar* toolbar = NULL;
	GtkToolbar* _tmp6_ = NULL;
	GtkToolButton* _tmp7_ = NULL;
	GtkToolButton* _tmp8_ = NULL;
	GtkToolButton* _tmp9_ = NULL;
	GtkToolButton* _tmp10_ = NULL;
	GtkToolButton* _tmp11_ = NULL;
	GtkToolButton* _tmp12_ = NULL;
	GtkToolButton* _tmp13_ = NULL;
	GtkToolButton* _tmp14_ = NULL;
	GtkWidget* join = NULL;
	GtkTreeView* _tmp15_ = NULL;
	GtkWidget* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	GtkWidget* _tmp18_ = NULL;
	GtkWidget* _tmp19_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = latexila_build_tools_personal_get_instance ();
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, latexila_build_tools_get_type ()) ? ((LatexilaBuildTools*) _tmp0_) : NULL);
	personal_build_tools = _tmp1_;
	_tmp2_ = self->priv->_personal_view;
	_tmp3_ = build_tools_preferences_get_properties_button (self, _tmp2_, personal_build_tools, FALSE);
	properties_button = _tmp3_;
	_tmp4_ = self->priv->_personal_view;
	_tmp5_ = build_tools_preferences_get_copy_button (self, _tmp4_, personal_build_tools);
	copy_button = _tmp5_;
	_tmp6_ = (GtkToolbar*) gtk_toolbar_new ();
	g_object_ref_sink (_tmp6_);
	toolbar = _tmp6_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) properties_button, -1);
	gtk_toolbar_insert (toolbar, (GtkToolItem*) copy_button, -1);
	_tmp7_ = build_tools_preferences_get_add_button (self);
	_tmp8_ = _tmp7_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp8_, -1);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = build_tools_preferences_get_remove_button (self);
	_tmp10_ = _tmp9_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp10_, -1);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = build_tools_preferences_get_up_button (self);
	_tmp12_ = _tmp11_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp12_, -1);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = build_tools_preferences_get_down_button (self);
	_tmp14_ = _tmp13_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp14_, -1);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = self->priv->_personal_view;
	_tmp16_ = build_tools_preferences_join_view_and_toolbar (self, _tmp15_, toolbar);
	join = _tmp16_;
	_tmp17_ = _ ("Personal Build Tools");
	_tmp18_ = latexila_utils_get_dialog_component (_tmp17_, join);
	_tmp19_ = _g_object_ref0 (_tmp18_);
	result = _tmp19_;
	_g_object_unref0 (join);
	_g_object_unref0 (toolbar);
	_g_object_unref0 (copy_button);
	_g_object_unref0 (properties_button);
	_g_object_unref0 (personal_build_tools);
	return result;
}


static GtkWidget* build_tools_preferences_join_view_and_toolbar (BuildToolsPreferences* self, GtkTreeView* view, GtkToolbar* toolbar) {
	GtkWidget* result = NULL;
	GtkTreeView* _tmp0_ = NULL;
	GtkScrolledWindow* scrolled_window = NULL;
	GtkTreeView* _tmp1_ = NULL;
	GtkScrolledWindow* _tmp2_ = NULL;
	GtkToolbar* _tmp3_ = NULL;
	GtkToolbar* _tmp4_ = NULL;
	GtkStyleContext* context = NULL;
	GtkToolbar* _tmp5_ = NULL;
	GtkStyleContext* _tmp6_ = NULL;
	GtkStyleContext* _tmp7_ = NULL;
	GtkToolbar* _tmp8_ = NULL;
	GtkWidget* _tmp9_ = NULL;
	GtkWidget* _tmp10_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (view != NULL, NULL);
	g_return_val_if_fail (toolbar != NULL, NULL);
	_tmp0_ = view;
	g_object_set ((GtkWidget*) _tmp0_, "expand", TRUE, NULL);
	_tmp1_ = view;
	_tmp2_ = utils_add_scrollbar ((GtkWidget*) _tmp1_);
	scrolled_window = _tmp2_;
	gtk_scrolled_window_set_shadow_type (scrolled_window, GTK_SHADOW_IN);
	gtk_widget_set_size_request ((GtkWidget*) scrolled_window, 350, 200);
	_tmp3_ = toolbar;
	gtk_toolbar_set_icon_size (_tmp3_, GTK_ICON_SIZE_MENU);
	_tmp4_ = toolbar;
	gtk_toolbar_set_style (_tmp4_, GTK_TOOLBAR_ICONS);
	_tmp5_ = toolbar;
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	context = _tmp7_;
	gtk_style_context_add_class (context, GTK_STYLE_CLASS_INLINE_TOOLBAR);
	_tmp8_ = toolbar;
	_tmp9_ = latexila_utils_join_widgets ((GtkWidget*) scrolled_window, (GtkWidget*) _tmp8_);
	_tmp10_ = _g_object_ref0 (_tmp9_);
	result = _tmp10_;
	_g_object_unref0 (context);
	_g_object_unref0 (scrolled_window);
	return result;
}


static GtkListStore* build_tools_preferences_get_new_store (BuildToolsPreferences* self) {
	GtkListStore* result = NULL;
	GtkListStore* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_list_store_new ((gint) BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_N_COLUMNS, G_TYPE_BOOLEAN, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, -1);
	result = _tmp0_;
	return result;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		BuildToolsPreferences* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->label_column);
		_g_object_unref0 (_data5_->store);
		_g_object_unref0 (_data5_->build_tools);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static void __lambda108_ (Block5Data* _data5_, const gchar* path_string) {
	BuildToolsPreferences* self;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	gboolean enabled = FALSE;
	GtkTreeModel* model = NULL;
	GtkListStore* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
	GtkListStore* _tmp7_ = NULL;
	GtkTreeIter _tmp8_ = {0};
	gboolean _tmp9_ = FALSE;
	gint num = 0;
	const gchar* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	LatexilaBuildTools* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	self = _data5_->self;
	g_return_if_fail (path_string != NULL);
	_tmp0_ = _data5_->store;
	_tmp1_ = path_string;
	gtk_tree_model_get_iter_from_string ((GtkTreeModel*) _tmp0_, &_tmp2_, _tmp1_);
	iter = _tmp2_;
	_tmp3_ = _data5_->store;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GTK_TYPE_TREE_MODEL) ? ((GtkTreeModel*) _tmp3_) : NULL);
	model = _tmp4_;
	_tmp5_ = iter;
	gtk_tree_model_get (model, &_tmp5_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED, &enabled, -1);
	_tmp6_ = enabled;
	enabled = !_tmp6_;
	_tmp7_ = _data5_->store;
	_tmp8_ = iter;
	_tmp9_ = enabled;
	gtk_list_store_set (_tmp7_, &_tmp8_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED, _tmp9_, -1);
	_tmp10_ = path_string;
	_tmp11_ = atoi (_tmp10_);
	num = _tmp11_;
	_tmp12_ = _data5_->build_tools;
	_tmp13_ = enabled;
	latexila_build_tools_set_enabled (_tmp12_, (guint) num, _tmp13_);
	_g_object_unref0 (model);
}


static void ___lambda108__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self) {
	__lambda108_ (self, path);
}


static void __lambda109_ (Block5Data* _data5_, GtkTreePath* path, GtkTreeViewColumn* column) {
	BuildToolsPreferences* self;
	GtkTreeViewColumn* _tmp0_ = NULL;
	self = _data5_->self;
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	_tmp0_ = column;
	if (_tmp0_ == _data5_->label_column) {
		gint build_tool_num = 0;
		GtkTreePath* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		LatexilaBuildTools* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		_tmp1_ = path;
		_tmp3_ = gtk_tree_path_get_indices_with_depth (_tmp1_, &_tmp2_);
		_tmp4_ = _tmp3_[0];
		build_tool_num = _tmp4_;
		_tmp5_ = _data5_->build_tools;
		_tmp6_ = build_tool_num;
		build_tools_preferences_open_build_tool (self, _tmp5_, _tmp6_);
	}
}


static void ___lambda109__gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	__lambda109_ (self, path, column);
}


static GtkTreeView* build_tools_preferences_get_new_view (BuildToolsPreferences* self, GtkListStore* store, LatexilaBuildTools* build_tools) {
	GtkTreeView* result = NULL;
	Block5Data* _data5_;
	GtkListStore* _tmp0_ = NULL;
	GtkListStore* _tmp1_ = NULL;
	LatexilaBuildTools* _tmp2_ = NULL;
	LatexilaBuildTools* _tmp3_ = NULL;
	GtkTreeView* view = NULL;
	GtkListStore* _tmp4_ = NULL;
	GtkTreeView* _tmp5_ = NULL;
	GtkTreeViewColumn* enabled_column = NULL;
	GtkTreeViewColumn* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkCellRendererToggle* toggle_renderer = NULL;
	GtkCellRendererToggle* _tmp8_ = NULL;
	GtkTreeViewColumn* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GtkCellRendererPixbuf* pixbuf_renderer = NULL;
	GtkCellRendererPixbuf* _tmp11_ = NULL;
	GtkCellRendererText* text_renderer = NULL;
	GtkCellRendererText* _tmp12_ = NULL;
	GtkTreeSelection* select = NULL;
	GtkTreeSelection* _tmp13_ = NULL;
	GtkTreeSelection* _tmp14_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (store != NULL, NULL);
	g_return_val_if_fail (build_tools != NULL, NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = store;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data5_->store);
	_data5_->store = _tmp1_;
	_tmp2_ = build_tools;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data5_->build_tools);
	_data5_->build_tools = _tmp3_;
	_tmp4_ = _data5_->store;
	_tmp5_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _tmp4_);
	g_object_ref_sink (_tmp5_);
	view = _tmp5_;
	_tmp6_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp6_);
	enabled_column = _tmp6_;
	_tmp7_ = _ ("Enabled");
	gtk_tree_view_column_set_title (enabled_column, _tmp7_);
	gtk_tree_view_append_column (view, enabled_column);
	_tmp8_ = (GtkCellRendererToggle*) gtk_cell_renderer_toggle_new ();
	g_object_ref_sink (_tmp8_);
	toggle_renderer = _tmp8_;
	gtk_cell_layout_pack_start ((GtkCellLayout*) enabled_column, (GtkCellRenderer*) toggle_renderer, FALSE);
	gtk_tree_view_column_set_attributes (enabled_column, (GtkCellRenderer*) toggle_renderer, "active", BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED, NULL);
	_tmp9_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp9_);
	_data5_->label_column = _tmp9_;
	_tmp10_ = _ ("Label");
	gtk_tree_view_column_set_title (_data5_->label_column, _tmp10_);
	gtk_tree_view_append_column (view, _data5_->label_column);
	_tmp11_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp11_);
	pixbuf_renderer = _tmp11_;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _data5_->label_column, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	gtk_tree_view_column_set_attributes (_data5_->label_column, (GtkCellRenderer*) pixbuf_renderer, "icon-name", BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_PIXBUF, NULL);
	_tmp12_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp12_);
	text_renderer = _tmp12_;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _data5_->label_column, (GtkCellRenderer*) text_renderer, TRUE);
	gtk_tree_view_column_set_attributes (_data5_->label_column, (GtkCellRenderer*) text_renderer, "text", BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_LABEL, NULL);
	gtk_tree_view_set_tooltip_column (view, (gint) BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_DESCRIPTION);
	_tmp13_ = gtk_tree_view_get_selection (view);
	_tmp14_ = _g_object_ref0 (_tmp13_);
	select = _tmp14_;
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	g_signal_connect_data (toggle_renderer, "toggled", (GCallback) ___lambda108__gtk_cell_renderer_toggle_toggled, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	g_signal_connect_data (view, "row-activated", (GCallback) ___lambda109__gtk_tree_view_row_activated, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	result = view;
	_g_object_unref0 (select);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
	_g_object_unref0 (toggle_renderer);
	_g_object_unref0 (enabled_column);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return result;
}


static void _gtk_tree_path_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL));
}


static void _g_list_free__gtk_tree_path_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gtk_tree_path_free0_, NULL);
	g_list_free (self);
}


static void build_tools_preferences_on_view_selection_changed (BuildToolsPreferences* self, GtkTreeSelection* select, GtkTreeSelection* other_select) {
	GList* selected_items = NULL;
	GtkTreeSelection* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (select != NULL);
	g_return_if_fail (other_select != NULL);
	_tmp0_ = select;
	_tmp1_ = gtk_tree_selection_get_selected_rows (_tmp0_, NULL);
	selected_items = _tmp1_;
	_tmp2_ = selected_items;
	_tmp3_ = g_list_length (_tmp2_);
	if (_tmp3_ > ((guint) 0)) {
		GtkTreeSelection* _tmp4_ = NULL;
		_tmp4_ = other_select;
		gtk_tree_selection_unselect_all (_tmp4_);
	}
	__g_list_free__gtk_tree_path_free0_0 (selected_items);
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		BuildToolsPreferences* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->view);
		_g_object_unref0 (_data6_->build_tools);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}


static void __lambda122_ (Block6Data* _data6_) {
	BuildToolsPreferences* self;
	gint build_tool_num = 0;
	GtkTreeView* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	self = _data6_->self;
	_tmp0_ = _data6_->view;
	_tmp1_ = utils_get_selected_row (_tmp0_, NULL);
	build_tool_num = _tmp1_;
	_tmp2_ = build_tool_num;
	if (0 <= _tmp2_) {
		LatexilaBuildTools* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		_tmp3_ = _data6_->build_tools;
		_tmp4_ = build_tool_num;
		build_tools_preferences_open_build_tool (self, _tmp3_, _tmp4_);
	}
}


static void ___lambda122__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda122_ (self);
}


static GtkToolButton* build_tools_preferences_get_properties_button (BuildToolsPreferences* self, GtkTreeView* view, LatexilaBuildTools* build_tools, gboolean read_only) {
	GtkToolButton* result = NULL;
	Block6Data* _data6_;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeView* _tmp1_ = NULL;
	LatexilaBuildTools* _tmp2_ = NULL;
	LatexilaBuildTools* _tmp3_ = NULL;
	GtkToolButton* properties_button = NULL;
	GtkToolButton* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GtkTreeView* _tmp12_ = NULL;
	GtkToolButton* _tmp13_ = NULL;
	GtkToolButton* _tmp14_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (view != NULL, NULL);
	g_return_val_if_fail (build_tools != NULL, NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = view;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data6_->view);
	_data6_->view = _tmp1_;
	_tmp2_ = build_tools;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data6_->build_tools);
	_data6_->build_tools = _tmp3_;
	_tmp4_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp4_);
	properties_button = _tmp4_;
	_tmp5_ = read_only;
	if (_tmp5_) {
		GtkToolButton* _tmp6_ = NULL;
		GtkToolButton* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		_tmp6_ = properties_button;
		gtk_tool_button_set_icon_name (_tmp6_, "edit-find-symbolic");
		_tmp7_ = properties_button;
		_tmp8_ = _ ("View the properties (read-only)");
		gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp7_, _tmp8_);
	} else {
		GtkToolButton* _tmp9_ = NULL;
		GtkToolButton* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		_tmp9_ = properties_button;
		gtk_tool_button_set_icon_name (_tmp9_, "document-properties-symbolic");
		_tmp10_ = properties_button;
		_tmp11_ = _ ("Edit the properties");
		gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp10_, _tmp11_);
	}
	_tmp12_ = _data6_->view;
	_tmp13_ = properties_button;
	build_tools_preferences_set_sensitivity_on_selection (self, _tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = properties_button;
	g_signal_connect_data (_tmp14_, "clicked", (GCallback) ___lambda122__gtk_tool_button_clicked, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	result = properties_button;
	block6_data_unref (_data6_);
	_data6_ = NULL;
	return result;
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		BuildToolsPreferences* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->view);
		_g_object_unref0 (_data7_->build_tools);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}


static void __lambda123_ (Block7Data* _data7_) {
	BuildToolsPreferences* self;
	gint selected_row = 0;
	GtkTreeView* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	LatexilaBuildTool* tool = NULL;
	LatexilaBuildTools* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	LatexilaBuildTool* _tmp5_ = NULL;
	LatexilaBuildTool* _tmp6_ = NULL;
	LatexilaBuildTool* _tmp7_ = NULL;
	LatexilaBuildTool* _tmp8_ = NULL;
	LatexilaBuildTool* _tmp9_ = NULL;
	LatexilaBuildTool* _tmp10_ = NULL;
	LatexilaBuildTool* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	LatexilaBuildTool* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	LatexilaBuildToolsPersonal* personal_build_tools = NULL;
	LatexilaBuildToolsPersonal* _tmp19_ = NULL;
	LatexilaBuildToolsPersonal* _tmp20_ = NULL;
	LatexilaBuildToolsPersonal* _tmp21_ = NULL;
	LatexilaBuildTool* _tmp22_ = NULL;
	self = _data7_->self;
	_tmp0_ = _data7_->view;
	_tmp1_ = utils_get_selected_row (_tmp0_, NULL);
	selected_row = _tmp1_;
	_tmp2_ = selected_row;
	if (_tmp2_ < 0) {
		return;
	}
	_tmp3_ = _data7_->build_tools;
	_tmp4_ = selected_row;
	_tmp5_ = latexila_build_tools_nth (_tmp3_, (guint) _tmp4_);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	tool = _tmp6_;
	_tmp7_ = tool;
	g_return_if_fail (_tmp7_ != NULL);
	_tmp8_ = tool;
	_tmp9_ = latexila_build_tool_clone (_tmp8_);
	_g_object_unref0 (tool);
	tool = _tmp9_;
	_tmp10_ = tool;
	g_object_set (_tmp10_, "enabled", FALSE, NULL);
	_tmp11_ = tool;
	_tmp12_ = _ ("%s [copy]");
	_tmp13_ = tool;
	g_object_get (_tmp13_, "label", &_tmp14_, NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strdup_printf (_tmp12_, _tmp16_);
	_tmp18_ = _tmp17_;
	g_object_set (_tmp11_, "label", _tmp18_, NULL);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp16_);
	_tmp19_ = latexila_build_tools_personal_get_instance ();
	_tmp20_ = _g_object_ref0 (_tmp19_);
	personal_build_tools = _tmp20_;
	_tmp21_ = personal_build_tools;
	_tmp22_ = tool;
	latexila_build_tools_personal_add (_tmp21_, _tmp22_);
	build_tools_preferences_update_personal_store (self);
	_g_object_unref0 (personal_build_tools);
	_g_object_unref0 (tool);
}


static void ___lambda123__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda123_ (self);
}


static GtkToolButton* build_tools_preferences_get_copy_button (BuildToolsPreferences* self, GtkTreeView* view, LatexilaBuildTools* build_tools) {
	GtkToolButton* result = NULL;
	Block7Data* _data7_;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeView* _tmp1_ = NULL;
	LatexilaBuildTools* _tmp2_ = NULL;
	LatexilaBuildTools* _tmp3_ = NULL;
	GtkToolButton* copy_button = NULL;
	GtkToolButton* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkTreeView* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (view != NULL, NULL);
	g_return_val_if_fail (build_tools != NULL, NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = view;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data7_->view);
	_data7_->view = _tmp1_;
	_tmp2_ = build_tools;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data7_->build_tools);
	_data7_->build_tools = _tmp3_;
	_tmp4_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp4_);
	copy_button = _tmp4_;
	gtk_tool_button_set_icon_name (copy_button, "edit-copy-symbolic");
	_tmp5_ = _ ("Create a copy");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) copy_button, _tmp5_);
	_tmp6_ = _data7_->view;
	build_tools_preferences_set_sensitivity_on_selection (self, _tmp6_, (GtkWidget*) copy_button);
	g_signal_connect_data (copy_button, "clicked", (GCallback) ___lambda123__gtk_tool_button_clicked, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	result = copy_button;
	block7_data_unref (_data7_);
	_data7_ = NULL;
	return result;
}


static void __lambda124_ (BuildToolsPreferences* self) {
	BuildToolDialog* dialog = NULL;
	GtkDialog* _tmp0_ = NULL;
	BuildToolDialog* _tmp1_ = NULL;
	BuildToolDialog* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	_tmp0_ = self->priv->_dialog;
	_tmp1_ = build_tool_dialog_new ((GtkWindow*) _tmp0_, TRUE);
	dialog = _tmp1_;
	_tmp2_ = dialog;
	_tmp3_ = build_tool_dialog_create_personal_build_tool (_tmp2_);
	if (_tmp3_) {
		build_tools_preferences_update_personal_store (self);
	}
	_g_object_unref0 (dialog);
}


static void ___lambda124__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda124_ ((BuildToolsPreferences*) self);
}


static GtkToolButton* build_tools_preferences_get_add_button (BuildToolsPreferences* self) {
	GtkToolButton* result = NULL;
	GtkToolButton* add_button = NULL;
	GtkToolButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	add_button = _tmp0_;
	gtk_tool_button_set_icon_name (add_button, "list-add-symbolic");
	_tmp1_ = _ ("Add...");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) add_button, _tmp1_);
	g_signal_connect_object (add_button, "clicked", (GCallback) ___lambda124__gtk_tool_button_clicked, self, 0);
	result = add_button;
	return result;
}


static void __lambda125_ (BuildToolsPreferences* self) {
	GtkTreeIter iter = {0};
	gint selected_row = 0;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gchar* label = NULL;
	GtkTreeModel* model = NULL;
	GtkListStore* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeModel* _tmp6_ = NULL;
	GtkTreeIter _tmp7_ = {0};
	GtkDialog* dialog = NULL;
	GtkDialog* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GtkMessageDialog* _tmp11_ = NULL;
	GtkDialog* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GtkDialog* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	GtkDialog* _tmp21_ = NULL;
	_tmp0_ = self->priv->_personal_view;
	_tmp2_ = utils_get_selected_row (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	selected_row = _tmp2_;
	_tmp3_ = selected_row;
	if (_tmp3_ == -1) {
		return;
	}
	_tmp4_ = self->priv->_personal_store;
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, GTK_TYPE_TREE_MODEL) ? ((GtkTreeModel*) _tmp4_) : NULL);
	model = _tmp5_;
	_tmp6_ = model;
	_tmp7_ = iter;
	gtk_tree_model_get (_tmp6_, &_tmp7_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_LABEL, &label, -1);
	_tmp8_ = self->priv->_dialog;
	_tmp9_ = _ ("Do you really want to delete the build tool \"%s\"?");
	_tmp10_ = label;
	_tmp11_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp8_, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _tmp9_, _tmp10_);
	g_object_ref_sink (_tmp11_);
	dialog = (GtkDialog*) _tmp11_;
	_tmp12_ = dialog;
	_tmp13_ = _ ("_Cancel");
	_tmp14_ = _ ("_Delete");
	gtk_dialog_add_buttons (_tmp12_, _tmp13_, GTK_RESPONSE_CANCEL, _tmp14_, GTK_RESPONSE_YES, NULL);
	_tmp15_ = dialog;
	_tmp16_ = gtk_dialog_run (_tmp15_);
	if (_tmp16_ == ((gint) GTK_RESPONSE_YES)) {
		GtkListStore* _tmp17_ = NULL;
		GtkTreeIter _tmp18_ = {0};
		LatexilaBuildToolsPersonal* _tmp19_ = NULL;
		gint _tmp20_ = 0;
		_tmp17_ = self->priv->_personal_store;
		_tmp18_ = iter;
		gtk_list_store_remove (_tmp17_, &_tmp18_);
		_tmp19_ = latexila_build_tools_personal_get_instance ();
		_tmp20_ = selected_row;
		latexila_build_tools_personal_delete (_tmp19_, (guint) _tmp20_);
	}
	_tmp21_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp21_);
	_g_object_unref0 (dialog);
	_g_object_unref0 (model);
	_g_free0 (label);
}


static void ___lambda125__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda125_ ((BuildToolsPreferences*) self);
}


static GtkToolButton* build_tools_preferences_get_remove_button (BuildToolsPreferences* self) {
	GtkToolButton* result = NULL;
	GtkToolButton* remove_button = NULL;
	GtkToolButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkTreeView* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	remove_button = _tmp0_;
	gtk_tool_button_set_icon_name (remove_button, "list-remove-symbolic");
	_tmp1_ = _ ("Remove");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) remove_button, _tmp1_);
	_tmp2_ = self->priv->_personal_view;
	build_tools_preferences_set_sensitivity_on_selection (self, _tmp2_, (GtkWidget*) remove_button);
	g_signal_connect_object (remove_button, "clicked", (GCallback) ___lambda125__gtk_tool_button_clicked, self, 0);
	result = remove_button;
	return result;
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void block8_data_unref (void * _userdata_) {
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		BuildToolsPreferences* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->up_button);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


static void __lambda126_ (Block8Data* _data8_) {
	BuildToolsPreferences* self;
	GList* selected_rows = NULL;
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	GtkTreePath* path_selected = NULL;
	GList* _tmp3_ = NULL;
	gconstpointer _tmp4_ = NULL;
	GtkTreePath* _tmp5_ = NULL;
	gint row_num = 0;
	GtkTreePath* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	self = _data8_->self;
	_tmp0_ = gtk_tree_selection_get_selected_rows (_data8_->select, NULL);
	selected_rows = _tmp0_;
	_tmp1_ = selected_rows;
	_tmp2_ = g_list_length (_tmp1_);
	if (_tmp2_ == ((guint) 0)) {
		gtk_widget_set_sensitive ((GtkWidget*) _data8_->up_button, FALSE);
		__g_list_free__gtk_tree_path_free0_0 (selected_rows);
		return;
	}
	_tmp3_ = selected_rows;
	_tmp4_ = g_list_nth_data (_tmp3_, (guint) 0);
	_tmp5_ = _gtk_tree_path_copy0 ((GtkTreePath*) _tmp4_);
	path_selected = _tmp5_;
	_tmp6_ = path_selected;
	_tmp8_ = gtk_tree_path_get_indices_with_depth (_tmp6_, &_tmp7_);
	_tmp9_ = _tmp8_[0];
	row_num = _tmp9_;
	_tmp10_ = row_num;
	gtk_widget_set_sensitive ((GtkWidget*) _data8_->up_button, _tmp10_ > 0);
	_gtk_tree_path_free0 (path_selected);
	__g_list_free__gtk_tree_path_free0_0 (selected_rows);
}


static void ___lambda126__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	__lambda126_ (self);
}


static void __lambda127_ (Block8Data* _data8_) {
	BuildToolsPreferences* self;
	GtkTreeIter iter_selected = {0};
	gint selected_row = 0;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	self = _data8_->self;
	_tmp0_ = self->priv->_personal_view;
	_tmp2_ = utils_get_selected_row (_tmp0_, &_tmp1_);
	iter_selected = _tmp1_;
	selected_row = _tmp2_;
	_tmp3_ = selected_row;
	if (_tmp3_ > 0) {
		GtkTreeIter iter_up = {0};
		GtkTreeIter _tmp4_ = {0};
		GtkListStore* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = iter_selected;
		iter_up = _tmp4_;
		_tmp5_ = self->priv->_personal_store;
		_tmp6_ = utils_tree_model_iter_prev ((GtkTreeModel*) _tmp5_, &iter_up);
		if (_tmp6_) {
			GtkListStore* _tmp7_ = NULL;
			GtkTreeIter _tmp8_ = {0};
			GtkTreeIter _tmp9_ = {0};
			LatexilaBuildToolsPersonal* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			_tmp7_ = self->priv->_personal_store;
			_tmp8_ = iter_selected;
			_tmp9_ = iter_up;
			gtk_list_store_swap (_tmp7_, &_tmp8_, &_tmp9_);
			_tmp10_ = latexila_build_tools_personal_get_instance ();
			_tmp11_ = selected_row;
			latexila_build_tools_personal_move_up (_tmp10_, (guint) _tmp11_);
			g_signal_emit_by_name (_data8_->select, "changed");
		}
	}
}


static void ___lambda127__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda127_ (self);
}


static GtkToolButton* build_tools_preferences_get_up_button (BuildToolsPreferences* self) {
	GtkToolButton* result = NULL;
	Block8Data* _data8_;
	GtkToolButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkTreeView* _tmp2_ = NULL;
	GtkTreeSelection* _tmp3_ = NULL;
	GtkToolButton* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	_data8_->up_button = _tmp0_;
	gtk_tool_button_set_icon_name (_data8_->up_button, "go-up-symbolic");
	_tmp1_ = _ ("Move up");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _data8_->up_button, _tmp1_);
	gtk_widget_set_sensitive ((GtkWidget*) _data8_->up_button, FALSE);
	_tmp2_ = self->priv->_personal_view;
	_tmp3_ = gtk_tree_view_get_selection (_tmp2_);
	_data8_->select = _tmp3_;
	g_signal_connect_data (_data8_->select, "changed", (GCallback) ___lambda126__gtk_tree_selection_changed, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
	g_signal_connect_data (_data8_->up_button, "clicked", (GCallback) ___lambda127__gtk_tool_button_clicked, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
	_tmp4_ = _g_object_ref0 (_data8_->up_button);
	result = _tmp4_;
	block8_data_unref (_data8_);
	_data8_ = NULL;
	return result;
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (void * _userdata_) {
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		BuildToolsPreferences* self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->down_button);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}


static void __lambda128_ (Block9Data* _data9_) {
	BuildToolsPreferences* self;
	GList* selected_rows = NULL;
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	GtkTreePath* path_selected = NULL;
	GList* _tmp3_ = NULL;
	gconstpointer _tmp4_ = NULL;
	GtkTreePath* _tmp5_ = NULL;
	gint row_num = 0;
	GtkTreePath* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	GtkTreeModel* model = NULL;
	GtkListStore* _tmp10_ = NULL;
	GtkTreeModel* _tmp11_ = NULL;
	gint nb_rows = 0;
	GtkTreeModel* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	self = _data9_->self;
	_tmp0_ = gtk_tree_selection_get_selected_rows (_data9_->select, NULL);
	selected_rows = _tmp0_;
	_tmp1_ = selected_rows;
	_tmp2_ = g_list_length (_tmp1_);
	if (_tmp2_ == ((guint) 0)) {
		gtk_widget_set_sensitive ((GtkWidget*) _data9_->down_button, FALSE);
		__g_list_free__gtk_tree_path_free0_0 (selected_rows);
		return;
	}
	_tmp3_ = selected_rows;
	_tmp4_ = g_list_nth_data (_tmp3_, (guint) 0);
	_tmp5_ = _gtk_tree_path_copy0 ((GtkTreePath*) _tmp4_);
	path_selected = _tmp5_;
	_tmp6_ = path_selected;
	_tmp8_ = gtk_tree_path_get_indices_with_depth (_tmp6_, &_tmp7_);
	_tmp9_ = _tmp8_[0];
	row_num = _tmp9_;
	_tmp10_ = self->priv->_personal_store;
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, GTK_TYPE_TREE_MODEL) ? ((GtkTreeModel*) _tmp10_) : NULL);
	model = _tmp11_;
	_tmp12_ = model;
	_tmp13_ = gtk_tree_model_iter_n_children (_tmp12_, NULL);
	nb_rows = _tmp13_;
	_tmp14_ = row_num;
	_tmp15_ = nb_rows;
	gtk_widget_set_sensitive ((GtkWidget*) _data9_->down_button, _tmp14_ < (_tmp15_ - 1));
	_g_object_unref0 (model);
	_gtk_tree_path_free0 (path_selected);
	__g_list_free__gtk_tree_path_free0_0 (selected_rows);
}


static void ___lambda128__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	__lambda128_ (self);
}


static void __lambda129_ (Block9Data* _data9_) {
	BuildToolsPreferences* self;
	GtkTreeIter iter_selected = {0};
	gint selected_row = 0;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	self = _data9_->self;
	_tmp0_ = self->priv->_personal_view;
	_tmp2_ = utils_get_selected_row (_tmp0_, &_tmp1_);
	iter_selected = _tmp1_;
	selected_row = _tmp2_;
	_tmp3_ = selected_row;
	if (_tmp3_ >= 0) {
		GtkTreeIter iter_down = {0};
		GtkTreeIter _tmp4_ = {0};
		GtkListStore* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = iter_selected;
		iter_down = _tmp4_;
		_tmp5_ = self->priv->_personal_store;
		_tmp6_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp5_, &iter_down);
		if (_tmp6_) {
			GtkListStore* _tmp7_ = NULL;
			GtkTreeIter _tmp8_ = {0};
			GtkTreeIter _tmp9_ = {0};
			LatexilaBuildToolsPersonal* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			_tmp7_ = self->priv->_personal_store;
			_tmp8_ = iter_selected;
			_tmp9_ = iter_down;
			gtk_list_store_swap (_tmp7_, &_tmp8_, &_tmp9_);
			_tmp10_ = latexila_build_tools_personal_get_instance ();
			_tmp11_ = selected_row;
			latexila_build_tools_personal_move_down (_tmp10_, (guint) _tmp11_);
			g_signal_emit_by_name (_data9_->select, "changed");
		}
	}
}


static void ___lambda129__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda129_ (self);
}


static GtkToolButton* build_tools_preferences_get_down_button (BuildToolsPreferences* self) {
	GtkToolButton* result = NULL;
	Block9Data* _data9_;
	GtkToolButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkTreeView* _tmp2_ = NULL;
	GtkTreeSelection* _tmp3_ = NULL;
	GtkToolButton* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	_data9_->down_button = _tmp0_;
	gtk_tool_button_set_icon_name (_data9_->down_button, "go-down-symbolic");
	_tmp1_ = _ ("Move down");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _data9_->down_button, _tmp1_);
	gtk_widget_set_sensitive ((GtkWidget*) _data9_->down_button, FALSE);
	_tmp2_ = self->priv->_personal_view;
	_tmp3_ = gtk_tree_view_get_selection (_tmp2_);
	_data9_->select = _tmp3_;
	g_signal_connect_data (_data9_->select, "changed", (GCallback) ___lambda128__gtk_tree_selection_changed, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	g_signal_connect_data (_data9_->down_button, "clicked", (GCallback) ___lambda129__gtk_tool_button_clicked, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	_tmp4_ = _g_object_ref0 (_data9_->down_button);
	result = _tmp4_;
	block9_data_unref (_data9_);
	_data9_ = NULL;
	return result;
}


static void build_tools_preferences_update_default_store (BuildToolsPreferences* self) {
	GtkListStore* _tmp0_ = NULL;
	LatexilaBuildToolsDefault* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_default_store;
	_tmp1_ = latexila_build_tools_default_get_instance ();
	build_tools_preferences_update_store (self, _tmp0_, (LatexilaBuildTools*) _tmp1_);
}


static void build_tools_preferences_update_personal_store (BuildToolsPreferences* self) {
	GtkListStore* _tmp0_ = NULL;
	LatexilaBuildToolsPersonal* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_personal_store;
	_tmp1_ = latexila_build_tools_personal_get_instance ();
	build_tools_preferences_update_store (self, _tmp0_, (LatexilaBuildTools*) _tmp1_);
}


static void build_tools_preferences_update_store (BuildToolsPreferences* self, GtkListStore* store, LatexilaBuildTools* build_tools) {
	GtkListStore* _tmp0_ = NULL;
	LatexilaBuildTools* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	g_return_if_fail (build_tools != NULL);
	_tmp0_ = store;
	gtk_list_store_clear (_tmp0_);
	_tmp1_ = build_tools;
	_tmp2_ = _tmp1_->build_tools;
	{
		GList* tool_collection = NULL;
		GList* tool_it = NULL;
		tool_collection = _tmp2_;
		for (tool_it = tool_collection; tool_it != NULL; tool_it = tool_it->next) {
			LatexilaBuildTool* _tmp3_ = NULL;
			LatexilaBuildTool* tool = NULL;
			_tmp3_ = _g_object_ref0 ((LatexilaBuildTool*) tool_it->data);
			tool = _tmp3_;
			{
				gchar* description = NULL;
				LatexilaBuildTool* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				gchar* _tmp6_ = NULL;
				GtkTreeIter iter = {0};
				GtkListStore* _tmp7_ = NULL;
				GtkTreeIter _tmp8_ = {0};
				GtkListStore* _tmp9_ = NULL;
				GtkTreeIter _tmp10_ = {0};
				LatexilaBuildTool* _tmp11_ = NULL;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_ = FALSE;
				LatexilaBuildTool* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_ = NULL;
				LatexilaBuildTool* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				_tmp4_ = tool;
				_tmp5_ = latexila_build_tool_get_description (_tmp4_);
				_tmp6_ = g_markup_escape_text (_tmp5_, (gssize) -1);
				description = _tmp6_;
				_tmp7_ = store;
				gtk_list_store_append (_tmp7_, &_tmp8_);
				iter = _tmp8_;
				_tmp9_ = store;
				_tmp10_ = iter;
				_tmp11_ = tool;
				g_object_get (_tmp11_, "enabled", &_tmp12_, NULL);
				_tmp13_ = _tmp12_;
				_tmp14_ = tool;
				g_object_get (_tmp14_, "icon", &_tmp15_, NULL);
				_tmp16_ = _tmp15_;
				_tmp17_ = _tmp16_;
				_tmp18_ = tool;
				g_object_get (_tmp18_, "label", &_tmp19_, NULL);
				_tmp20_ = _tmp19_;
				_tmp21_ = _tmp20_;
				_tmp22_ = description;
				gtk_list_store_set (_tmp9_, &_tmp10_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED, _tmp13_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_PIXBUF, _tmp17_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_LABEL, _tmp21_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_DESCRIPTION, _tmp22_, -1);
				_g_free0 (_tmp21_);
				_g_free0 (_tmp17_);
				_g_free0 (description);
				_g_object_unref0 (tool);
			}
		}
	}
}


static void build_tools_preferences_open_build_tool (BuildToolsPreferences* self, LatexilaBuildTools* build_tools, gint build_tool_num) {
	gboolean editable = FALSE;
	LatexilaBuildTools* _tmp0_ = NULL;
	BuildToolDialog* dialog = NULL;
	GtkDialog* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	BuildToolDialog* _tmp3_ = NULL;
	gboolean edited = FALSE;
	BuildToolDialog* _tmp4_ = NULL;
	LatexilaBuildTools* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (build_tools != NULL);
	_tmp0_ = build_tools;
	editable = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, latexila_build_tools_personal_get_type ());
	_tmp1_ = self->priv->_dialog;
	_tmp2_ = editable;
	_tmp3_ = build_tool_dialog_new ((GtkWindow*) _tmp1_, _tmp2_);
	dialog = _tmp3_;
	_tmp4_ = dialog;
	_tmp5_ = build_tools;
	_tmp6_ = build_tool_num;
	_tmp7_ = build_tool_dialog_open_build_tool (_tmp4_, _tmp5_, _tmp6_);
	edited = _tmp7_;
	_tmp8_ = edited;
	if (_tmp8_) {
		build_tools_preferences_update_personal_store (self);
	}
	_g_object_unref0 (dialog);
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}


static void block10_data_unref (void * _userdata_) {
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		BuildToolsPreferences* self;
		self = _data10_->self;
		_g_object_unref0 (_data10_->widget);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}


static void __lambda121_ (Block10Data* _data10_) {
	BuildToolsPreferences* self;
	gboolean row_selected = FALSE;
	gint _tmp0_ = 0;
	GtkWidget* _tmp1_ = NULL;
	self = _data10_->self;
	_tmp0_ = gtk_tree_selection_count_selected_rows (_data10_->select);
	row_selected = _tmp0_ > 0;
	_tmp1_ = _data10_->widget;
	gtk_widget_set_sensitive (_tmp1_, row_selected);
}


static void ___lambda121__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	__lambda121_ (self);
}


static void build_tools_preferences_set_sensitivity_on_selection (BuildToolsPreferences* self, GtkTreeView* view, GtkWidget* widget) {
	Block10Data* _data10_;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkTreeView* _tmp3_ = NULL;
	GtkTreeSelection* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	g_return_if_fail (widget != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = widget;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data10_->widget);
	_data10_->widget = _tmp1_;
	_tmp2_ = _data10_->widget;
	gtk_widget_set_sensitive (_tmp2_, FALSE);
	_tmp3_ = view;
	_tmp4_ = gtk_tree_view_get_selection (_tmp3_);
	_data10_->select = _tmp4_;
	g_signal_connect_data (_data10_->select, "changed", (GCallback) ___lambda121__gtk_tree_selection_changed, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}


static void build_tools_preferences_class_init (BuildToolsPreferencesClass * klass) {
	build_tools_preferences_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BuildToolsPreferencesPrivate));
	G_OBJECT_CLASS (klass)->finalize = build_tools_preferences_finalize;
}


static void build_tools_preferences_instance_init (BuildToolsPreferences * self) {
	self->priv = BUILD_TOOLS_PREFERENCES_GET_PRIVATE (self);
}


static void build_tools_preferences_finalize (GObject* obj) {
	BuildToolsPreferences * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferences);
	_g_object_unref0 (self->priv->_dialog);
	_g_object_unref0 (self->priv->_default_store);
	_g_object_unref0 (self->priv->_personal_store);
	_g_object_unref0 (self->priv->_default_view);
	_g_object_unref0 (self->priv->_personal_view);
	G_OBJECT_CLASS (build_tools_preferences_parent_class)->finalize (obj);
}


GType build_tools_preferences_get_type (void) {
	static volatile gsize build_tools_preferences_type_id__volatile = 0;
	if (g_once_init_enter (&build_tools_preferences_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BuildToolsPreferencesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) build_tools_preferences_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuildToolsPreferences), 0, (GInstanceInitFunc) build_tools_preferences_instance_init, NULL };
		GType build_tools_preferences_type_id;
		build_tools_preferences_type_id = g_type_register_static (G_TYPE_OBJECT, "BuildToolsPreferences", &g_define_type_info, 0);
		g_once_init_leave (&build_tools_preferences_type_id__volatile, build_tools_preferences_type_id);
	}
	return build_tools_preferences_type_id__volatile;
}



