/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quarter@users.sourceforge.net> */

#include "include/support.h"
#include "include/paritycommand.h"

/*! \brief Konstruktor dwu członowego polecenia

	Konstruktor dwu członowego polecenia
*/
LWCommandSegment::LWCommandSegment(): matched(FALSE)
{
}

/*! \brief Czy polecenie jest dwuczłonowe

	Czy polecenie jest dwuczłonowe
	\return Zawsze zwraca prawdę
*/
gboolean LWCommandSegment::isSegment ()
{
	return TRUE;
}

gboolean LWCommandSegment::matchNextCondition(LWCommand *cmd)
{
	(void) cmd;
	return FALSE;
}

gboolean LWCommandSegment::matchPrevCondition(LWCommand *cmd)
{
	(void) cmd;
	return FALSE;
}

/*! \brief Dopasowuje polecenie

	Oznacza polecenia jako już dopasowane z jego końcem
*/
void LWCommandSegment::match ()
{
	matched = TRUE;
}

/*! \brief Czy polecenie jest już dopasowane

	Czy polecenie jest już dopasowane
	\return Zwraca prawdę jeśli było już dopasowane w przeciwnym razie fałsz
*/
gboolean LWCommandSegment::isAlreadyMatched ()
{
	return matched;
}

/*! \brief Zeruje polecenie

	Zeruje polecenie czyniąc je niedopasowanym
*/
void LWCommandSegment::reset1 ()
{
	matched = FALSE;
}
