# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.image_algorithm import ImageAlgorithm


class SEPReader(ImageAlgorithm):
    r"""
    SEPReader - Stanford Exploration Project files reader.
    
    Superclass: ImageAlgorithm
    
    This reader takes a .H file that points to a .H@ file and contains
    all the information to interpret the raw data in the  .H@ file.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSEPReader, obj, update, **traits)
    
    extent_split_mode = traits.Int(3, enter_set=True, auto_set=False, desc=\
        r"""
        Specify extent translator split mode.
        Default: ExtentTranslator::BLOCK_MODE
        """
    )

    def _extent_split_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetExtentSplitMode,
                        self.extent_split_mode)

    file_name = tvtk_base.vtk_file_name("", desc=\
        r"""
        Specify file name for the SEP Header file.
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    output_grid_dimension = traits.Int(3, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _output_grid_dimension_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutputGridDimension,
                        self.output_grid_dimension)

    def _get_all_dimensions(self):
        return wrap_vtk(self._vtk_obj.GetAllDimensions())
    all_dimensions = traits.Property(_get_all_dimensions, desc=\
        r"""
        Array containing the name of all dimensions. Contains ESize
        elements.
        """
    )

    def _get_all_ranges(self):
        return wrap_vtk(self._vtk_obj.GetAllRanges())
    all_ranges = traits.Property(_get_all_ranges, desc=\
        r"""
        Array containing the name and the size of all dimensions. The two
        first entries are the header. Contains 2*ESize elements.
        """
    )

    def _get_data_origin(self):
        return self._vtk_obj.GetDataOrigin()
    data_origin = traits.Property(_get_data_origin, desc=\
        r"""
        
        """
    )

    def _get_data_spacing(self):
        return self._vtk_obj.GetDataSpacing()
    data_spacing = traits.Property(_get_data_spacing, desc=\
        r"""
        
        """
    )

    def _get_fixed_dim_range(self):
        return self._vtk_obj.GetFixedDimRange()
    fixed_dim_range = traits.Property(_get_fixed_dim_range, desc=\
        r"""
        
        """
    )

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        Get a data object for one of the input port connections.  The use
        of this method is strongly discouraged, but some filters that
        were written a long time ago still use this method.
        """
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def can_read_file(self, *args):
        """
        can_read_file(self, __a:str) -> bool
        C++: bool can_read_file(const char *)"""
        ret = self._wrap_call(self._vtk_obj.CanReadFile, *args)
        return ret

    def set_fixed_dimension1(self, *args):
        """
        set_fixed_dimension1(self, arg:str) -> None
        C++: virtual void set_fixed_dimension1(const char *arg)"""
        ret = self._wrap_call(self._vtk_obj.SetFixedDimension1, *args)
        return ret

    def set_fixed_dimension2(self, *args):
        """
        set_fixed_dimension2(self, arg:str) -> None
        C++: virtual void set_fixed_dimension2(const char *arg)"""
        ret = self._wrap_call(self._vtk_obj.SetFixedDimension2, *args)
        return ret

    def set_fixed_dimension_value1(self, *args):
        """
        set_fixed_dimension_value1(self, _arg:int) -> None
        C++: virtual void set_fixed_dimension_value1(int _arg)"""
        ret = self._wrap_call(self._vtk_obj.SetFixedDimensionValue1, *args)
        return ret

    def set_fixed_dimension_value2(self, *args):
        """
        set_fixed_dimension_value2(self, _arg:int) -> None
        C++: virtual void set_fixed_dimension_value2(int _arg)"""
        ret = self._wrap_call(self._vtk_obj.SetFixedDimensionValue2, *args)
        return ret

    def set_x_dimension(self, *args):
        """
        set_x_dimension(self, arg:str) -> None
        C++: virtual void set_x_dimension(const char *arg)
        Specify the name for each spatial / fixed dimension. ZDimension
        is only used for 3D output. fixed_dimension2 is only used for 2D
        output.
        """
        ret = self._wrap_call(self._vtk_obj.SetXDimension, *args)
        return ret

    def set_y_dimension(self, *args):
        """
        set_y_dimension(self, arg:str) -> None
        C++: virtual void set_y_dimension(const char *arg)"""
        ret = self._wrap_call(self._vtk_obj.SetYDimension, *args)
        return ret

    def set_z_dimension(self, *args):
        """
        set_z_dimension(self, arg:str) -> None
        C++: virtual void set_z_dimension(const char *arg)"""
        ret = self._wrap_call(self._vtk_obj.SetZDimension, *args)
        return ret

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('extent_split_mode', 'GetExtentSplitMode'), ('file_name',
    'GetFileName'), ('output_grid_dimension', 'GetOutputGridDimension'),
    ('progress', 'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'extent_split_mode', 'file_name',
    'output_grid_dimension', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(SEPReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit SEPReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['extent_split_mode', 'file_name',
            'output_grid_dimension']),
            title='Edit SEPReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit SEPReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

