#ifndef TIMEOUT_CALC_H
#define TIMEOUT_CALC_H

#include <algorithm>
#include "compat.h"
#include "mswatch_config.h"

class timeout_calc
{
  public:
	timeout_calc(time_t base, time_t inter, time_t max);
	timeout_calc(const mswatch_config& config);

	time_t get_timeout() const;

	void enqueue_event();
	void enqueue_event(time_t base_delay);
	void dequeue_events();

	void set_dequeue_error();
	bool get_dequeue_error() const;

  private:
	const time_t default_inter_delay;
	time_t base_delay, inter_delay, oldest_event, prev_dequeue;

	const time_t error_base_delay, error_max_delay;
	bool is_error;
	time_t error_delay;
	unsigned error_ntries;
};

#endif // TIMEOUT_CALC_H
