/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse;

import com.sourceforge.knecs.util.converters.FormatException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Vector;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.scidac.cmcs.tools.bse.AbstractBasisSetToXml;
import org.scidac.cmcs.tools.pertable.PerTable;

public class NWChemInputToBasisXml
extends AbstractBasisSetToXml {
    protected PerTable mPertable = PerTable.getPerTable();

    @Override
    public Vector convert(String title, String xmlFileName, String harmonicType, String description, InputStream inputStream) throws IOException, FormatException {
        Vector<Document> ret = new Vector<Document>();
        boolean hasBasisSet = false;
        boolean hasEcp = false;
        boolean hasSo = false;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        String line = null;
        while ((line = reader.readLine()) != null) {
            line = line.trim().toUpperCase();
            Document doc = null;
            if (line.startsWith("BASIS")) {
                if (hasBasisSet) {
                    throw new FormatException("Multiple BASIS keywords detected.  We do not currently support multiple basis set sections, including fitting sets, in one file.");
                }
                doc = this.loadBasisSet(reader, line, title, xmlFileName, harmonicType, description);
                if (doc != null) {
                    hasBasisSet = true;
                }
            } else if (line.startsWith("ECP")) {
                if (hasEcp) {
                    throw new FormatException("Multiple ECP keywords detected.  We do not support multiple basis sets in one file");
                }
                doc = this.loadECPs(reader, line, title, xmlFileName);
                if (doc != null) {
                    hasEcp = true;
                }
            } else if (line.startsWith("SO")) {
                if (hasSo) {
                    throw new FormatException("Can not have more than two so sections in one file.");
                }
                doc = this.loadSpinOrbitals(reader, line, title, xmlFileName);
                if (doc != null) {
                    hasSo = true;
                }
            }
            if (doc == null) continue;
            ret.add(doc);
        }
        if (ret.size() == 0) {
            throw new FormatException("Unable to find start of basis set data.  Make sure you have specified the correct file type.");
        }
        for (Document doc : ret) {
            String docType = doc.getRootElement().getName().toLowerCase();
            if (!docType.equals("basisset")) continue;
            if (hasEcp) {
                doc.getRootElement().addContent(this.createEcpLink(xmlFileName));
            }
            if (!hasSo) continue;
            doc.getRootElement().addContent(this.createSoLink(xmlFileName));
        }
        return ret;
    }

    protected Document loadBasisSet(BufferedReader reader, String options, String name, String xmlFileName, String harmonicType, String description) throws IOException, FormatException {
        Element root = this.createBasisRoot();
        root.addContent(this.createBasisMime());
        root.addContent(this.createTitle(name));
        root.addContent(this.createHarmonicType(harmonicType));
        root.addContent(this.createContractionType("segmented"));
        root.addContent(this.createRefLink(xmlFileName + "-BS-REF.xml"));
        root.addContent(this.createDescription(description));
        String line = "";
        String maxShell = this.getMinimumShell();
        String lastElement = "";
        Element contractions = null;
        while (!line.equals("END") && (line = reader.readLine()) != null) {
            if ((line = line.trim().toUpperCase()).length() == 0 || line.startsWith("#")) continue;
            if (line.equals("END")) break;
            if (line.indexOf("LIBRARY") >= 0) {
                throw new FormatException("Library keyword not permitted.");
            }
            Vector columns = this.tokenize(line);
            String element = (String)columns.get(0);
            if (!this.mPertable.isValid(element = this.mPertable.formatSymbol(element))) {
                throw new FormatException("Unrecognized element: " + element);
            }
            if (columns.size() <= 1) {
                throw new FormatException("Missing L values: " + line);
            }
            String shell = (String)columns.get(1);
            if (!this.isValidShell(shell)) {
                throw new FormatException("Unrecognized shell type " + shell);
            }
            if (!element.equals(lastElement)) {
                contractions = this.createContractions(element);
                root.addContent(contractions);
                lastElement = element;
                maxShell = this.getMinimumShell();
            }
            Element contraction = this.createContraction(shell);
            maxShell = this.selectMaxShell(shell, maxShell);
            contractions.addContent(contraction);
            this.readMatrix(reader, contraction);
        }
        Document result = new Document(root);
        NWChemInputToBasisXml.addContractionDescriptions(result);
        return result;
    }

    protected boolean readMatrix(BufferedReader reader, Element parent) throws IOException {
        String line;
        boolean ret = false;
        Vector matrix = new Vector();
        int nColumns = 0;
        int nRows = 0;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim().toUpperCase()).length() == 0 || line.startsWith("#")) continue;
            Vector data = this.tokenize(line);
            String sym = this.mPertable.formatSymbol((String)data.get(0));
            if (line.equals("END") || this.mPertable.isValid(sym)) {
                ret = true;
                Element matrixEl = this.createMatrix(matrix, nRows, nColumns);
                parent.addContent(matrixEl);
                reader.reset();
                break;
            }
            reader.mark(80);
            nColumns = data.size();
            ++nRows;
            matrix.addAll(data);
        }
        return ret;
    }

    protected Document loadECPs(BufferedReader reader, String options, String name, String xmlFileName) throws IOException, FormatException {
        return this.loadECPFormattedData(reader, options, "scalar", name, xmlFileName);
    }

    protected Document loadSpinOrbitals(BufferedReader reader, String options, String name, String xmlFileName) throws IOException, FormatException {
        return this.loadECPFormattedData(reader, options, "spin", name + "-so", xmlFileName);
    }

    protected Document loadECPFormattedData(BufferedReader reader, String options, String type, String name, String xmlFileName) throws IOException, FormatException {
        Element root = this.createEcpRoot();
        root.addContent(this.createEcpMime());
        root.addContent(this.createTitle(name));
        root.addContent(this.createEcpType("type"));
        if (xmlFileName.endsWith("-ECP")) {
            root.addContent(this.createRefLink(xmlFileName + "-REF.xml"));
        } else {
            root.addContent(this.createRefLink(xmlFileName + "-ECP-REF.xml"));
        }
        String line = "";
        while (!line.equals("END") && (line = reader.readLine()) != null) {
            if ((line = line.trim().toUpperCase()).length() == 0 || line.startsWith("#")) continue;
            if (line.equals("END")) break;
            Vector columns = this.tokenize(line);
            String element = (String)columns.get(0);
            if (!this.mPertable.isValid(element = this.mPertable.formatSymbol(element))) {
                throw new FormatException("Unrecognized element: " + element);
            }
            if (columns.size() <= 1) {
                throw new FormatException("Missing nelec: " + line);
            }
            String nElectrons = (String)columns.get(2);
            String maxShell = this.getMinimumShell();
            Element potentials = this.createPotentials(element, nElectrons);
            root.addContent(potentials);
            while ((line = reader.readLine().trim().toUpperCase()) != null && !line.equals("END")) {
                if (line.startsWith("#")) continue;
                columns = this.tokenize(line);
                String element2 = (String)columns.get(0);
                if (!element.equals(element2 = this.mPertable.formatSymbol(element2))) {
                    reader.reset();
                    element = element2;
                    maxShell = this.getMinimumShell();
                    break;
                }
                if (columns.size() != 2) {
                    throw new FormatException("Expected potential line: ie Si s" + line);
                }
                String shell = (String)columns.get(1);
                if (!this.isValidShell(shell)) {
                    throw new FormatException("Unrecognized shell type " + shell);
                }
                maxShell = this.selectMaxShell(shell, maxShell);
                Element potential = this.createPotential(shell.toLowerCase() + " potential", shell);
                potentials.addContent(potential);
                this.readMatrix(reader, potential);
            }
            maxShell = maxShell.toLowerCase();
            List potentialEls = potentials.getChildren("potential", mEmslNs);
            for (Element p : potentialEls) {
                Attribute attribute = p.getAttribute("potentialType");
                String shell = p.getAttribute("shell").getValue().toLowerCase();
                if (shell.equals(maxShell)) {
                    attribute.setValue(shell + " potential");
                    continue;
                }
                attribute.setValue(shell + "-" + maxShell + " potential");
            }
        }
        return new Document(root);
    }
}

