/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class ServletUtils {
    public static final int HTTP_PORT = 80;
    public static final int HTTPS_PORT = 443;
    public static final int FTP_PORT = 20;
    public static final String URI_SCHEME_SEPARATOR = "://";

    public static String expandRelative(ServletConfig config, String text) {
        ServletContext context;
        String base;
        if (text == null || text.length() <= 0) {
            return text;
        }
        if (config == null) {
            return null;
        }
        if (!(text.startsWith("/") || text.startsWith("./") || text.startsWith("\\") || text.startsWith(".\\"))) {
            StringBuffer sb = new StringBuffer();
            sb.append("./");
            sb.append(text);
            text = sb.toString();
        }
        if ((base = (context = config.getServletContext()).getRealPath("/")) == null) {
            base = config.getInitParameter("basedir");
        }
        if (base == null) {
            return text;
        }
        String separator = System.getProperty("path.separator");
        StringTokenizer tokenizer = new StringTokenizer(text, separator);
        StringBuffer buffer = new StringBuffer();
        while (tokenizer.hasMoreTokens()) {
            buffer.append(base).append(tokenizer.nextToken());
            if (!tokenizer.hasMoreTokens()) continue;
            buffer.append(separator);
        }
        return buffer.toString();
    }

    public static StringBuffer hostURL(HttpServletRequest req) {
        return ServletUtils.hostURL(req, null);
    }

    public static StringBuffer hostURL(HttpServletRequest req, String scheme) {
        if (scheme == null) {
            scheme = req.getScheme();
        }
        StringBuffer url = new StringBuffer().append(scheme).append(URI_SCHEME_SEPARATOR).append(req.getServerName());
        int port = req.getServerPort();
        if (!("http".equalsIgnoreCase(scheme) && port == 80 || "https".equalsIgnoreCase(scheme) && port == 443 || "ftp".equalsIgnoreCase(scheme) && port == 20)) {
            url.append(':').append(port);
        }
        return url;
    }
}

