// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Units_UnitsSystem_HeaderFile
#define _Units_UnitsSystem_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_Units_UnitsSystem.hxx>

#include <Handle_Units_QuantitiesSequence.hxx>
#include <Handle_TColStd_HSequenceOfInteger.hxx>
#include <MMgt_TShared.hxx>
#include <Standard_CString.hxx>
#include <Standard_Boolean.hxx>
#include <Standard_Real.hxx>
class Units_QuantitiesSequence;
class TColStd_HSequenceOfInteger;
class Units_NoSuchUnit;
class Units_NoSuchType;
class TCollection_AsciiString;


//! This class  allows  the  user  to  define his  own
//! system of units.
class Units_UnitsSystem : public MMgt_TShared
{

public:

  
  //! Returns an instance of UnitsSystem initialized to the
  //! S.I. units system.
  Standard_EXPORT Units_UnitsSystem();
  
  //! Returns an instance of UnitsSystem initialized to the
  //! S.I. units system upgraded by the base system units decription
  //! file.
  //! Attempts to find the four following files:
  //! $CSF_`aName`Defaults/.aName
  //! $CSF_`aName`SiteDefaults/.aName
  //! $CSF_`aName`GroupDefaults/.aName
  //! $CSF_`aName`UserDefaults/.aName
  //! See : Resource_Manager for the description of this file.
  Standard_EXPORT Units_UnitsSystem(const Standard_CString aName, const Standard_Boolean Verbose = Standard_False);
  
  //! Returns the sequence of refined quantities.
  Standard_EXPORT   Handle(Units_QuantitiesSequence) QuantitiesSequence()  const;
  
  //! Returns a sequence of integer in correspondance with
  //! the sequence of quantities, which indicates, for each
  //! redefined quantity, the index into the sequence of
  //! units, of the active unit.
  Standard_EXPORT   Handle(TColStd_HSequenceOfInteger) ActiveUnitsSequence()  const;
  
  //! Specifies for <aquantity> the unit <aunit> used.
  Standard_EXPORT   void Specify (const Standard_CString aquantity, const Standard_CString aunit) ;
  
  //! Removes for <aquantity> the unit <aunit> used.
  Standard_EXPORT   void Remove (const Standard_CString aquantity, const Standard_CString aunit) ;
  
  //! Specifies for <aquantity> the unit <aunit> used.
  Standard_EXPORT   void Activate (const Standard_CString aquantity, const Standard_CString aunit) ;
  
  //! Activates the first unit of all defined system quantities
  Standard_EXPORT   void Activates() ;
  
  //! Returns for <aquantity> the active unit.
  Standard_EXPORT   TCollection_AsciiString ActiveUnit (const Standard_CString aquantity)  const;
  
  //! Converts a real value <avalue> from the unit <aunit>
  //! belonging to the physical dimensions <aquantity> to
  //! the corresponding unit of the user system.
  Standard_EXPORT   Standard_Real ConvertValueToUserSystem (const Standard_CString aquantity, const Standard_Real avalue, const Standard_CString aunit)  const;
  
  //! Converts the real value <avalue> from the S.I. system
  //! of units to the user system of units. <aquantity> is
  //! the physical dimensions of the measurement.
  Standard_EXPORT   Standard_Real ConvertSIValueToUserSystem (const Standard_CString aquantity, const Standard_Real avalue)  const;
  
  //! Converts the real value <avalue> from the user system
  //! of units to the S.I. system of units. <aquantity> is
  //! the physical dimensions of the measurement.
  Standard_EXPORT   Standard_Real ConvertUserSystemValueToSI (const Standard_CString aquantity, const Standard_Real avalue)  const;
  
  Standard_EXPORT   void Dump()  const;
  
  //! Returns TRUE if no units has been defined in the system.
  Standard_EXPORT   Standard_Boolean IsEmpty()  const;




  DEFINE_STANDARD_RTTI(Units_UnitsSystem)

protected:




private: 


  Handle(Units_QuantitiesSequence) thequantitiessequence;
  Handle(TColStd_HSequenceOfInteger) theactiveunitssequence;


};







#endif // _Units_UnitsSystem_HeaderFile
