/*************************************************************************
 * odil - Copyright (C) Universite de Strasbourg
 * Distributed under the terms of the CeCILL-B license, as published by
 * the CEA-CNRS-INRIA. Refer to the LICENSE file or to
 * http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 * for details.
 ************************************************************************/

#include <map>
#include <string>
#include <tuple>

#include "odil/ElementsDictionary.h"
#include "odil/Tag.h"

namespace odil
{

namespace registry
{

void update_0028(
    ElementsDictionary & public_dictionary,
    std::map<std::string, odil::Tag> & public_tags)
{

    public_dictionary.emplace(Tag(0x0028, 0x0002), ElementsDictionaryEntry("Samples per Pixel", "SamplesPerPixel",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0003), ElementsDictionaryEntry("Samples per Pixel Used", "SamplesPerPixelUsed",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0004), ElementsDictionaryEntry("Photometric Interpretation", "PhotometricInterpretation",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0005), ElementsDictionaryEntry("Image Dimensions", "ImageDimensions",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0006), ElementsDictionaryEntry("Planar Configuration", "PlanarConfiguration",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0008), ElementsDictionaryEntry("Number of Frames", "NumberOfFrames",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0009), ElementsDictionaryEntry("Frame Increment Pointer", "FrameIncrementPointer",  "AT", "1-n"));
    public_dictionary.emplace(Tag(0x0028, 0x000a), ElementsDictionaryEntry("Frame Dimension Pointer", "FrameDimensionPointer",  "AT", "1-n"));
    public_dictionary.emplace(Tag(0x0028, 0x0010), ElementsDictionaryEntry("Rows", "Rows",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0011), ElementsDictionaryEntry("Columns", "Columns",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0012), ElementsDictionaryEntry("Planes", "Planes",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0014), ElementsDictionaryEntry("Ultrasound Color Data Present", "UltrasoundColorDataPresent",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0030), ElementsDictionaryEntry("Pixel Spacing", "PixelSpacing",  "DS", "2"));
    public_dictionary.emplace(Tag(0x0028, 0x0031), ElementsDictionaryEntry("Zoom Factor", "ZoomFactor",  "DS", "2"));
    public_dictionary.emplace(Tag(0x0028, 0x0032), ElementsDictionaryEntry("Zoom Center", "ZoomCenter",  "DS", "2"));
    public_dictionary.emplace(Tag(0x0028, 0x0034), ElementsDictionaryEntry("Pixel Aspect Ratio", "PixelAspectRatio",  "IS", "2"));
    public_dictionary.emplace(Tag(0x0028, 0x0040), ElementsDictionaryEntry("Image Format", "ImageFormat",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0050), ElementsDictionaryEntry("Manipulated Image", "ManipulatedImage",  "LO", "1-n"));
    public_dictionary.emplace(Tag(0x0028, 0x0051), ElementsDictionaryEntry("Corrected Image", "CorrectedImage",  "CS", "1-n"));
    public_dictionary.emplace(Tag(0x0028, 0x005f), ElementsDictionaryEntry("Compression Recognition Code", "CompressionRecognitionCode",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0060), ElementsDictionaryEntry("Compression Code", "CompressionCode",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0061), ElementsDictionaryEntry("Compression Originator", "CompressionOriginator",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0062), ElementsDictionaryEntry("Compression Label", "CompressionLabel",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0063), ElementsDictionaryEntry("Compression Description", "CompressionDescription",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0065), ElementsDictionaryEntry("Compression Sequence", "CompressionSequence",  "CS", "1-n"));
    public_dictionary.emplace(Tag(0x0028, 0x0066), ElementsDictionaryEntry("Compression Step Pointers", "CompressionStepPointers",  "AT", "1-n"));
    public_dictionary.emplace(Tag(0x0028, 0x0068), ElementsDictionaryEntry("Repeat Interval", "RepeatInterval",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0069), ElementsDictionaryEntry("Bits Grouped", "BitsGrouped",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0070), ElementsDictionaryEntry("Perimeter Table", "PerimeterTable",  "US", "1-n"));
    public_dictionary.emplace(Tag(0x0028, 0x0071), ElementsDictionaryEntry("Perimeter Value", "PerimeterValue",  "US or SS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0080), ElementsDictionaryEntry("Predictor Rows", "PredictorRows",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0081), ElementsDictionaryEntry("Predictor Columns", "PredictorColumns",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0082), ElementsDictionaryEntry("Predictor Constants", "PredictorConstants",  "US", "1-n"));
    public_dictionary.emplace(Tag(0x0028, 0x0090), ElementsDictionaryEntry("Blocked Pixels", "BlockedPixels",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0091), ElementsDictionaryEntry("Block Rows", "BlockRows",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0092), ElementsDictionaryEntry("Block Columns", "BlockColumns",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0093), ElementsDictionaryEntry("Row Overlap", "RowOverlap",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0094), ElementsDictionaryEntry("Column Overlap", "ColumnOverlap",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0100), ElementsDictionaryEntry("Bits Allocated", "BitsAllocated",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0101), ElementsDictionaryEntry("Bits Stored", "BitsStored",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0102), ElementsDictionaryEntry("High Bit", "HighBit",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0103), ElementsDictionaryEntry("Pixel Representation", "PixelRepresentation",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0104), ElementsDictionaryEntry("Smallest Valid Pixel Value", "SmallestValidPixelValue",  "US or SS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0105), ElementsDictionaryEntry("Largest Valid Pixel Value", "LargestValidPixelValue",  "US or SS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0106), ElementsDictionaryEntry("Smallest Image Pixel Value", "SmallestImagePixelValue",  "US or SS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0107), ElementsDictionaryEntry("Largest Image Pixel Value", "LargestImagePixelValue",  "US or SS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0108), ElementsDictionaryEntry("Smallest Pixel Value in Series", "SmallestPixelValueInSeries",  "US or SS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0109), ElementsDictionaryEntry("Largest Pixel Value in Series", "LargestPixelValueInSeries",  "US or SS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0110), ElementsDictionaryEntry("Smallest Image Pixel Value in Plane", "SmallestImagePixelValueInPlane",  "US or SS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0111), ElementsDictionaryEntry("Largest Image Pixel Value in Plane", "LargestImagePixelValueInPlane",  "US or SS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0120), ElementsDictionaryEntry("Pixel Padding Value", "PixelPaddingValue",  "US or SS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0121), ElementsDictionaryEntry("Pixel Padding Range Limit", "PixelPaddingRangeLimit",  "US or SS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0122), ElementsDictionaryEntry("Float Pixel Padding Value", "FloatPixelPaddingValue",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0123), ElementsDictionaryEntry("Double Float Pixel Padding Value", "DoubleFloatPixelPaddingValue",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0124), ElementsDictionaryEntry("Float Pixel Padding Range Limit", "FloatPixelPaddingRangeLimit",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0125), ElementsDictionaryEntry("Double Float Pixel Padding Range Limit", "DoubleFloatPixelPaddingRangeLimit",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0200), ElementsDictionaryEntry("Image Location", "ImageLocation",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0300), ElementsDictionaryEntry("Quality Control Image", "QualityControlImage",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0301), ElementsDictionaryEntry("Burned In Annotation", "BurnedInAnnotation",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0302), ElementsDictionaryEntry("Recognizable Visual Features", "RecognizableVisualFeatures",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0303), ElementsDictionaryEntry("Longitudinal Temporal Information Modified", "LongitudinalTemporalInformationModified",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0304), ElementsDictionaryEntry("Referenced Color Palette Instance UID", "ReferencedColorPaletteInstanceUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0400), ElementsDictionaryEntry("Transform Label", "TransformLabel",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0401), ElementsDictionaryEntry("Transform Version Number", "TransformVersionNumber",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0402), ElementsDictionaryEntry("Number of Transform Steps", "NumberOfTransformSteps",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0403), ElementsDictionaryEntry("Sequence of Compressed Data", "SequenceOfCompressedData",  "LO", "1-n"));
    public_dictionary.emplace(Tag(0x0028, 0x0404), ElementsDictionaryEntry("Details of Coefficients", "DetailsOfCoefficients",  "AT", "1-n"));
    public_dictionary.emplace(Tag(0x0028, 0x0700), ElementsDictionaryEntry("DCT Label", "DCTLabel",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0701), ElementsDictionaryEntry("Data Block Description", "DataBlockDescription",  "CS", "1-n"));
    public_dictionary.emplace(Tag(0x0028, 0x0702), ElementsDictionaryEntry("Data Block", "DataBlock",  "AT", "1-n"));
    public_dictionary.emplace(Tag(0x0028, 0x0710), ElementsDictionaryEntry("Normalization Factor Format", "NormalizationFactorFormat",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0720), ElementsDictionaryEntry("Zonal Map Number Format", "ZonalMapNumberFormat",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0721), ElementsDictionaryEntry("Zonal Map Location", "ZonalMapLocation",  "AT", "1-n"));
    public_dictionary.emplace(Tag(0x0028, 0x0722), ElementsDictionaryEntry("Zonal Map Format", "ZonalMapFormat",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0730), ElementsDictionaryEntry("Adaptive Map Format", "AdaptiveMapFormat",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0740), ElementsDictionaryEntry("Code Number Format", "CodeNumberFormat",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0a02), ElementsDictionaryEntry("Pixel Spacing Calibration Type", "PixelSpacingCalibrationType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x0a04), ElementsDictionaryEntry("Pixel Spacing Calibration Description", "PixelSpacingCalibrationDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1040), ElementsDictionaryEntry("Pixel Intensity Relationship", "PixelIntensityRelationship",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1041), ElementsDictionaryEntry("Pixel Intensity Relationship Sign", "PixelIntensityRelationshipSign",  "SS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1050), ElementsDictionaryEntry("Window Center", "WindowCenter",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x0028, 0x1051), ElementsDictionaryEntry("Window Width", "WindowWidth",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x0028, 0x1052), ElementsDictionaryEntry("Rescale Intercept", "RescaleIntercept",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1053), ElementsDictionaryEntry("Rescale Slope", "RescaleSlope",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1054), ElementsDictionaryEntry("Rescale Type", "RescaleType",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1055), ElementsDictionaryEntry("Window Center & Width Explanation", "WindowCenterWidthExplanation",  "LO", "1-n"));
    public_dictionary.emplace(Tag(0x0028, 0x1056), ElementsDictionaryEntry("VOI LUT Function", "VOILUTFunction",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1080), ElementsDictionaryEntry("Gray Scale", "GrayScale",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1090), ElementsDictionaryEntry("Recommended Viewing Mode", "RecommendedViewingMode",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1100), ElementsDictionaryEntry("Gray Lookup Table Descriptor", "GrayLookupTableDescriptor",  "US or SS", "3"));
    public_dictionary.emplace(Tag(0x0028, 0x1101), ElementsDictionaryEntry("Red Palette Color Lookup Table Descriptor", "RedPaletteColorLookupTableDescriptor",  "US or SS", "3"));
    public_dictionary.emplace(Tag(0x0028, 0x1102), ElementsDictionaryEntry("Green Palette Color Lookup Table Descriptor", "GreenPaletteColorLookupTableDescriptor",  "US or SS", "3"));
    public_dictionary.emplace(Tag(0x0028, 0x1103), ElementsDictionaryEntry("Blue Palette Color Lookup Table Descriptor", "BluePaletteColorLookupTableDescriptor",  "US or SS", "3"));
    public_dictionary.emplace(Tag(0x0028, 0x1104), ElementsDictionaryEntry("Alpha Palette Color Lookup Table Descriptor", "AlphaPaletteColorLookupTableDescriptor",  "US", "3"));
    public_dictionary.emplace(Tag(0x0028, 0x1111), ElementsDictionaryEntry("Large Red Palette Color Lookup Table Descriptor", "LargeRedPaletteColorLookupTableDescriptor",  "US or SS", "4"));
    public_dictionary.emplace(Tag(0x0028, 0x1112), ElementsDictionaryEntry("Large Green Palette Color Lookup Table Descriptor", "LargeGreenPaletteColorLookupTableDescriptor",  "US or SS", "4"));
    public_dictionary.emplace(Tag(0x0028, 0x1113), ElementsDictionaryEntry("Large Blue Palette Color Lookup Table Descriptor", "LargeBluePaletteColorLookupTableDescriptor",  "US or SS", "4"));
    public_dictionary.emplace(Tag(0x0028, 0x1199), ElementsDictionaryEntry("Palette Color Lookup Table UID", "PaletteColorLookupTableUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1200), ElementsDictionaryEntry("Gray Lookup Table Data", "GrayLookupTableData",  "US or SS or OW", "1-n or 1"));
    public_dictionary.emplace(Tag(0x0028, 0x1201), ElementsDictionaryEntry("Red Palette Color Lookup Table Data", "RedPaletteColorLookupTableData",  "OW", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1202), ElementsDictionaryEntry("Green Palette Color Lookup Table Data", "GreenPaletteColorLookupTableData",  "OW", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1203), ElementsDictionaryEntry("Blue Palette Color Lookup Table Data", "BluePaletteColorLookupTableData",  "OW", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1204), ElementsDictionaryEntry("Alpha Palette Color Lookup Table Data", "AlphaPaletteColorLookupTableData",  "OW", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1211), ElementsDictionaryEntry("Large Red Palette Color Lookup Table Data", "LargeRedPaletteColorLookupTableData",  "OW", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1212), ElementsDictionaryEntry("Large Green Palette Color Lookup Table Data", "LargeGreenPaletteColorLookupTableData",  "OW", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1213), ElementsDictionaryEntry("Large Blue Palette Color Lookup Table Data", "LargeBluePaletteColorLookupTableData",  "OW", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1214), ElementsDictionaryEntry("Large Palette Color Lookup Table UID", "LargePaletteColorLookupTableUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1221), ElementsDictionaryEntry("Segmented Red Palette Color Lookup Table Data", "SegmentedRedPaletteColorLookupTableData",  "OW", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1222), ElementsDictionaryEntry("Segmented Green Palette Color Lookup Table Data", "SegmentedGreenPaletteColorLookupTableData",  "OW", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1223), ElementsDictionaryEntry("Segmented Blue Palette Color Lookup Table Data", "SegmentedBluePaletteColorLookupTableData",  "OW", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1224), ElementsDictionaryEntry("Segmented Alpha Palette Color Lookup Table Data", "SegmentedAlphaPaletteColorLookupTableData",  "OW", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1230), ElementsDictionaryEntry("Stored Value Color Range Sequence", "StoredValueColorRangeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1231), ElementsDictionaryEntry("Minimum Stored Value Mapped", "MinimumStoredValueMapped",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1232), ElementsDictionaryEntry("Maximum Stored Value Mapped", "MaximumStoredValueMapped",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1300), ElementsDictionaryEntry("Breast Implant Present", "BreastImplantPresent",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1350), ElementsDictionaryEntry("Partial View", "PartialView",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1351), ElementsDictionaryEntry("Partial View Description", "PartialViewDescription",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1352), ElementsDictionaryEntry("Partial View Code Sequence", "PartialViewCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x135a), ElementsDictionaryEntry("Spatial Locations Preserved", "SpatialLocationsPreserved",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1401), ElementsDictionaryEntry("Data Frame Assignment Sequence", "DataFrameAssignmentSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1402), ElementsDictionaryEntry("Data Path Assignment", "DataPathAssignment",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1403), ElementsDictionaryEntry("Bits Mapped to Color Lookup Table", "BitsMappedToColorLookupTable",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1404), ElementsDictionaryEntry("Blending LUT 1 Sequence", "BlendingLUT1Sequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1405), ElementsDictionaryEntry("Blending LUT 1 Transfer Function", "BlendingLUT1TransferFunction",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1406), ElementsDictionaryEntry("Blending Weight Constant", "BlendingWeightConstant",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1407), ElementsDictionaryEntry("Blending Lookup Table Descriptor", "BlendingLookupTableDescriptor",  "US", "3"));
    public_dictionary.emplace(Tag(0x0028, 0x1408), ElementsDictionaryEntry("Blending Lookup Table Data", "BlendingLookupTableData",  "OW", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x140b), ElementsDictionaryEntry("Enhanced Palette Color Lookup Table Sequence", "EnhancedPaletteColorLookupTableSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x140c), ElementsDictionaryEntry("Blending LUT 2 Sequence", "BlendingLUT2Sequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x140d), ElementsDictionaryEntry("Blending LUT 2 Transfer Function", "BlendingLUT2TransferFunction",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x140e), ElementsDictionaryEntry("Data Path ID", "DataPathID",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x140f), ElementsDictionaryEntry("RGB LUT Transfer Function", "RGBLUTTransferFunction",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x1410), ElementsDictionaryEntry("Alpha LUT Transfer Function", "AlphaLUTTransferFunction",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x2000), ElementsDictionaryEntry("ICC Profile", "ICCProfile",  "OB", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x2002), ElementsDictionaryEntry("Color Space", "ColorSpace",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x2110), ElementsDictionaryEntry("Lossy Image Compression", "LossyImageCompression",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x2112), ElementsDictionaryEntry("Lossy Image Compression Ratio", "LossyImageCompressionRatio",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x0028, 0x2114), ElementsDictionaryEntry("Lossy Image Compression Method", "LossyImageCompressionMethod",  "CS", "1-n"));
    public_dictionary.emplace(Tag(0x0028, 0x3000), ElementsDictionaryEntry("Modality LUT Sequence", "ModalityLUTSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x3002), ElementsDictionaryEntry("LUT Descriptor", "LUTDescriptor",  "US or SS", "3"));
    public_dictionary.emplace(Tag(0x0028, 0x3003), ElementsDictionaryEntry("LUT Explanation", "LUTExplanation",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x3004), ElementsDictionaryEntry("Modality LUT Type", "ModalityLUTType",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x3006), ElementsDictionaryEntry("LUT Data", "LUTData",  "US or OW", "1-n or 1"));
    public_dictionary.emplace(Tag(0x0028, 0x3010), ElementsDictionaryEntry("VOI LUT Sequence", "VOILUTSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x3110), ElementsDictionaryEntry("Softcopy VOI LUT Sequence", "SoftcopyVOILUTSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x4000), ElementsDictionaryEntry("Image Presentation Comments", "ImagePresentationComments",  "LT", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x5000), ElementsDictionaryEntry("Bi-Plane Acquisition Sequence", "BiPlaneAcquisitionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x6010), ElementsDictionaryEntry("Representative Frame Number", "RepresentativeFrameNumber",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x6020), ElementsDictionaryEntry("Frame Numbers of Interest (FOI)", "FrameNumbersOfInterest",  "US", "1-n"));
    public_dictionary.emplace(Tag(0x0028, 0x6022), ElementsDictionaryEntry("Frame of Interest Description", "FrameOfInterestDescription",  "LO", "1-n"));
    public_dictionary.emplace(Tag(0x0028, 0x6023), ElementsDictionaryEntry("Frame of Interest Type", "FrameOfInterestType",  "CS", "1-n"));
    public_dictionary.emplace(Tag(0x0028, 0x6030), ElementsDictionaryEntry("Mask Pointer(s)", "MaskPointers",  "US", "1-n"));
    public_dictionary.emplace(Tag(0x0028, 0x6040), ElementsDictionaryEntry("R Wave Pointer", "RWavePointer",  "US", "1-n"));
    public_dictionary.emplace(Tag(0x0028, 0x6100), ElementsDictionaryEntry("Mask Subtraction Sequence", "MaskSubtractionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x6101), ElementsDictionaryEntry("Mask Operation", "MaskOperation",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x6102), ElementsDictionaryEntry("Applicable Frame Range", "ApplicableFrameRange",  "US", "2-2n"));
    public_dictionary.emplace(Tag(0x0028, 0x6110), ElementsDictionaryEntry("Mask Frame Numbers", "MaskFrameNumbers",  "US", "1-n"));
    public_dictionary.emplace(Tag(0x0028, 0x6112), ElementsDictionaryEntry("Contrast Frame Averaging", "ContrastFrameAveraging",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x6114), ElementsDictionaryEntry("Mask Sub-pixel Shift", "MaskSubPixelShift",  "FL", "2"));
    public_dictionary.emplace(Tag(0x0028, 0x6120), ElementsDictionaryEntry("TID Offset", "TIDOffset",  "SS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x6190), ElementsDictionaryEntry("Mask Operation Explanation", "MaskOperationExplanation",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x7000), ElementsDictionaryEntry("Equipment Administrator Sequence", "EquipmentAdministratorSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x7001), ElementsDictionaryEntry("Number of Display Subsystems", "NumberOfDisplaySubsystems",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x7002), ElementsDictionaryEntry("Current Configuration ID", "CurrentConfigurationID",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x7003), ElementsDictionaryEntry("Display Subsystem ID", "DisplaySubsystemID",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x7004), ElementsDictionaryEntry("Display Subsystem Name", "DisplaySubsystemName",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x7005), ElementsDictionaryEntry("Display Subsystem Description", "DisplaySubsystemDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x7006), ElementsDictionaryEntry("System Status", "SystemStatus",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x7007), ElementsDictionaryEntry("System Status Comment", "SystemStatusComment",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x7008), ElementsDictionaryEntry("Target Luminance Characteristics Sequence", "TargetLuminanceCharacteristicsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x7009), ElementsDictionaryEntry("Luminance Characteristics ID", "LuminanceCharacteristicsID",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x700a), ElementsDictionaryEntry("Display Subsystem Configuration Sequence", "DisplaySubsystemConfigurationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x700b), ElementsDictionaryEntry("Configuration ID", "ConfigurationID",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x700c), ElementsDictionaryEntry("Configuration Name", "ConfigurationName",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x700d), ElementsDictionaryEntry("Configuration Description", "ConfigurationDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x700e), ElementsDictionaryEntry("Referenced Target Luminance Characteristics ID", "ReferencedTargetLuminanceCharacteristicsID",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x700f), ElementsDictionaryEntry("QA Results Sequence", "QAResultsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x7010), ElementsDictionaryEntry("Display Subsystem QA Results Sequence", "DisplaySubsystemQAResultsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x7011), ElementsDictionaryEntry("Configuration QA Results Sequence", "ConfigurationQAResultsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x7012), ElementsDictionaryEntry("Measurement Equipment Sequence", "MeasurementEquipmentSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x7013), ElementsDictionaryEntry("Measurement Functions", "MeasurementFunctions",  "CS", "1-n"));
    public_dictionary.emplace(Tag(0x0028, 0x7014), ElementsDictionaryEntry("Measurement Equipment Type", "MeasurementEquipmentType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x7015), ElementsDictionaryEntry("Visual Evaluation Result Sequence", "VisualEvaluationResultSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x7016), ElementsDictionaryEntry("Display Calibration Result Sequence", "DisplayCalibrationResultSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x7017), ElementsDictionaryEntry("DDL Value", "DDLValue",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x7018), ElementsDictionaryEntry("CIExy White Point", "CIExyWhitePoint",  "FL", "2"));
    public_dictionary.emplace(Tag(0x0028, 0x7019), ElementsDictionaryEntry("Display Function Type", "DisplayFunctionType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x701a), ElementsDictionaryEntry("Gamma Value", "GammaValue",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x701b), ElementsDictionaryEntry("Number of Luminance Points", "NumberOfLuminancePoints",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x701c), ElementsDictionaryEntry("Luminance Response Sequence", "LuminanceResponseSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x701d), ElementsDictionaryEntry("Target Minimum Luminance", "TargetMinimumLuminance",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x701e), ElementsDictionaryEntry("Target Maximum Luminance", "TargetMaximumLuminance",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x701f), ElementsDictionaryEntry("Luminance Value", "LuminanceValue",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x7020), ElementsDictionaryEntry("Luminance Response Description", "LuminanceResponseDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x7021), ElementsDictionaryEntry("White Point Flag", "WhitePointFlag",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x7022), ElementsDictionaryEntry("Display Device Type Code Sequence", "DisplayDeviceTypeCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x7023), ElementsDictionaryEntry("Display Subsystem Sequence", "DisplaySubsystemSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x7024), ElementsDictionaryEntry("Luminance Result Sequence", "LuminanceResultSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x7025), ElementsDictionaryEntry("Ambient Light Value Source", "AmbientLightValueSource",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x7026), ElementsDictionaryEntry("Measured Characteristics", "MeasuredCharacteristics",  "CS", "1-n"));
    public_dictionary.emplace(Tag(0x0028, 0x7027), ElementsDictionaryEntry("Luminance Uniformity Result Sequence", "LuminanceUniformityResultSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x7028), ElementsDictionaryEntry("Visual Evaluation Test Sequence", "VisualEvaluationTestSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x7029), ElementsDictionaryEntry("Test Result", "TestResult",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x702a), ElementsDictionaryEntry("Test Result Comment", "TestResultComment",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x702b), ElementsDictionaryEntry("Test Image Validation", "TestImageValidation",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x702c), ElementsDictionaryEntry("Test Pattern Code Sequence", "TestPatternCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x702d), ElementsDictionaryEntry("Measurement Pattern Code Sequence", "MeasurementPatternCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x702e), ElementsDictionaryEntry("Visual Evaluation Method Code Sequence", "VisualEvaluationMethodCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x7fe0), ElementsDictionaryEntry("Pixel Data Provider URL", "PixelDataProviderURL",  "UR", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x9001), ElementsDictionaryEntry("Data Point Rows", "DataPointRows",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x9002), ElementsDictionaryEntry("Data Point Columns", "DataPointColumns",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x9003), ElementsDictionaryEntry("Signal Domain Columns", "SignalDomainColumns",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x9099), ElementsDictionaryEntry("Largest Monochrome Pixel Value", "LargestMonochromePixelValue",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x9108), ElementsDictionaryEntry("Data Representation", "DataRepresentation",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x9110), ElementsDictionaryEntry("Pixel Measures Sequence", "PixelMeasuresSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x9132), ElementsDictionaryEntry("Frame VOI LUT Sequence", "FrameVOILUTSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x9145), ElementsDictionaryEntry("Pixel Value Transformation Sequence", "PixelValueTransformationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x9235), ElementsDictionaryEntry("Signal Domain Rows", "SignalDomainRows",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x9411), ElementsDictionaryEntry("Display Filter Percentage", "DisplayFilterPercentage",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x9415), ElementsDictionaryEntry("Frame Pixel Shift Sequence", "FramePixelShiftSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x9416), ElementsDictionaryEntry("Subtraction Item ID", "SubtractionItemID",  "US", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x9422), ElementsDictionaryEntry("Pixel Intensity Relationship LUT Sequence", "PixelIntensityRelationshipLUTSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x9443), ElementsDictionaryEntry("Frame Pixel Data Properties Sequence", "FramePixelDataPropertiesSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x9444), ElementsDictionaryEntry("Geometrical Properties", "GeometricalProperties",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x9445), ElementsDictionaryEntry("Geometric Maximum Distortion", "GeometricMaximumDistortion",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x9446), ElementsDictionaryEntry("Image Processing Applied", "ImageProcessingApplied",  "CS", "1-n"));
    public_dictionary.emplace(Tag(0x0028, 0x9454), ElementsDictionaryEntry("Mask Selection Mode", "MaskSelectionMode",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x9474), ElementsDictionaryEntry("LUT Function", "LUTFunction",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x9478), ElementsDictionaryEntry("Mask Visibility Percentage", "MaskVisibilityPercentage",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x9501), ElementsDictionaryEntry("Pixel Shift Sequence", "PixelShiftSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x9502), ElementsDictionaryEntry("Region Pixel Shift Sequence", "RegionPixelShiftSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x9503), ElementsDictionaryEntry("Vertices of the Region", "VerticesOfTheRegion",  "SS", "2-2n"));
    public_dictionary.emplace(Tag(0x0028, 0x9505), ElementsDictionaryEntry("Multi-frame Presentation Sequence", "MultiFramePresentationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0028, 0x9506), ElementsDictionaryEntry("Pixel Shift Frame Range", "PixelShiftFrameRange",  "US", "2-2n"));
    public_dictionary.emplace(Tag(0x0028, 0x9507), ElementsDictionaryEntry("LUT Frame Range", "LUTFrameRange",  "US", "2-2n"));
    public_dictionary.emplace(Tag(0x0028, 0x9520), ElementsDictionaryEntry("Image to Equipment Mapping Matrix", "ImageToEquipmentMappingMatrix",  "DS", "16"));
    public_dictionary.emplace(Tag(0x0028, 0x9537), ElementsDictionaryEntry("Equipment Coordinate System Identification", "EquipmentCoordinateSystemIdentification",  "CS", "1"));

    public_tags.emplace("SamplesPerPixel", Tag(0x0028, 0x0002));
    public_tags.emplace("SamplesPerPixelUsed", Tag(0x0028, 0x0003));
    public_tags.emplace("PhotometricInterpretation", Tag(0x0028, 0x0004));
    public_tags.emplace("ImageDimensions", Tag(0x0028, 0x0005));
    public_tags.emplace("PlanarConfiguration", Tag(0x0028, 0x0006));
    public_tags.emplace("NumberOfFrames", Tag(0x0028, 0x0008));
    public_tags.emplace("FrameIncrementPointer", Tag(0x0028, 0x0009));
    public_tags.emplace("FrameDimensionPointer", Tag(0x0028, 0x000a));
    public_tags.emplace("Rows", Tag(0x0028, 0x0010));
    public_tags.emplace("Columns", Tag(0x0028, 0x0011));
    public_tags.emplace("Planes", Tag(0x0028, 0x0012));
    public_tags.emplace("UltrasoundColorDataPresent", Tag(0x0028, 0x0014));
    public_tags.emplace("PixelSpacing", Tag(0x0028, 0x0030));
    public_tags.emplace("ZoomFactor", Tag(0x0028, 0x0031));
    public_tags.emplace("ZoomCenter", Tag(0x0028, 0x0032));
    public_tags.emplace("PixelAspectRatio", Tag(0x0028, 0x0034));
    public_tags.emplace("ImageFormat", Tag(0x0028, 0x0040));
    public_tags.emplace("ManipulatedImage", Tag(0x0028, 0x0050));
    public_tags.emplace("CorrectedImage", Tag(0x0028, 0x0051));
    public_tags.emplace("CompressionRecognitionCode", Tag(0x0028, 0x005f));
    public_tags.emplace("CompressionCode", Tag(0x0028, 0x0060));
    public_tags.emplace("CompressionOriginator", Tag(0x0028, 0x0061));
    public_tags.emplace("CompressionLabel", Tag(0x0028, 0x0062));
    public_tags.emplace("CompressionDescription", Tag(0x0028, 0x0063));
    public_tags.emplace("CompressionSequence", Tag(0x0028, 0x0065));
    public_tags.emplace("CompressionStepPointers", Tag(0x0028, 0x0066));
    public_tags.emplace("RepeatInterval", Tag(0x0028, 0x0068));
    public_tags.emplace("BitsGrouped", Tag(0x0028, 0x0069));
    public_tags.emplace("PerimeterTable", Tag(0x0028, 0x0070));
    public_tags.emplace("PerimeterValue", Tag(0x0028, 0x0071));
    public_tags.emplace("PredictorRows", Tag(0x0028, 0x0080));
    public_tags.emplace("PredictorColumns", Tag(0x0028, 0x0081));
    public_tags.emplace("PredictorConstants", Tag(0x0028, 0x0082));
    public_tags.emplace("BlockedPixels", Tag(0x0028, 0x0090));
    public_tags.emplace("BlockRows", Tag(0x0028, 0x0091));
    public_tags.emplace("BlockColumns", Tag(0x0028, 0x0092));
    public_tags.emplace("RowOverlap", Tag(0x0028, 0x0093));
    public_tags.emplace("ColumnOverlap", Tag(0x0028, 0x0094));
    public_tags.emplace("BitsAllocated", Tag(0x0028, 0x0100));
    public_tags.emplace("BitsStored", Tag(0x0028, 0x0101));
    public_tags.emplace("HighBit", Tag(0x0028, 0x0102));
    public_tags.emplace("PixelRepresentation", Tag(0x0028, 0x0103));
    public_tags.emplace("SmallestValidPixelValue", Tag(0x0028, 0x0104));
    public_tags.emplace("LargestValidPixelValue", Tag(0x0028, 0x0105));
    public_tags.emplace("SmallestImagePixelValue", Tag(0x0028, 0x0106));
    public_tags.emplace("LargestImagePixelValue", Tag(0x0028, 0x0107));
    public_tags.emplace("SmallestPixelValueInSeries", Tag(0x0028, 0x0108));
    public_tags.emplace("LargestPixelValueInSeries", Tag(0x0028, 0x0109));
    public_tags.emplace("SmallestImagePixelValueInPlane", Tag(0x0028, 0x0110));
    public_tags.emplace("LargestImagePixelValueInPlane", Tag(0x0028, 0x0111));
    public_tags.emplace("PixelPaddingValue", Tag(0x0028, 0x0120));
    public_tags.emplace("PixelPaddingRangeLimit", Tag(0x0028, 0x0121));
    public_tags.emplace("FloatPixelPaddingValue", Tag(0x0028, 0x0122));
    public_tags.emplace("DoubleFloatPixelPaddingValue", Tag(0x0028, 0x0123));
    public_tags.emplace("FloatPixelPaddingRangeLimit", Tag(0x0028, 0x0124));
    public_tags.emplace("DoubleFloatPixelPaddingRangeLimit", Tag(0x0028, 0x0125));
    public_tags.emplace("ImageLocation", Tag(0x0028, 0x0200));
    public_tags.emplace("QualityControlImage", Tag(0x0028, 0x0300));
    public_tags.emplace("BurnedInAnnotation", Tag(0x0028, 0x0301));
    public_tags.emplace("RecognizableVisualFeatures", Tag(0x0028, 0x0302));
    public_tags.emplace("LongitudinalTemporalInformationModified", Tag(0x0028, 0x0303));
    public_tags.emplace("ReferencedColorPaletteInstanceUID", Tag(0x0028, 0x0304));
    public_tags.emplace("TransformLabel", Tag(0x0028, 0x0400));
    public_tags.emplace("TransformVersionNumber", Tag(0x0028, 0x0401));
    public_tags.emplace("NumberOfTransformSteps", Tag(0x0028, 0x0402));
    public_tags.emplace("SequenceOfCompressedData", Tag(0x0028, 0x0403));
    public_tags.emplace("DetailsOfCoefficients", Tag(0x0028, 0x0404));
    public_tags.emplace("DCTLabel", Tag(0x0028, 0x0700));
    public_tags.emplace("DataBlockDescription", Tag(0x0028, 0x0701));
    public_tags.emplace("DataBlock", Tag(0x0028, 0x0702));
    public_tags.emplace("NormalizationFactorFormat", Tag(0x0028, 0x0710));
    public_tags.emplace("ZonalMapNumberFormat", Tag(0x0028, 0x0720));
    public_tags.emplace("ZonalMapLocation", Tag(0x0028, 0x0721));
    public_tags.emplace("ZonalMapFormat", Tag(0x0028, 0x0722));
    public_tags.emplace("AdaptiveMapFormat", Tag(0x0028, 0x0730));
    public_tags.emplace("CodeNumberFormat", Tag(0x0028, 0x0740));
    public_tags.emplace("PixelSpacingCalibrationType", Tag(0x0028, 0x0a02));
    public_tags.emplace("PixelSpacingCalibrationDescription", Tag(0x0028, 0x0a04));
    public_tags.emplace("PixelIntensityRelationship", Tag(0x0028, 0x1040));
    public_tags.emplace("PixelIntensityRelationshipSign", Tag(0x0028, 0x1041));
    public_tags.emplace("WindowCenter", Tag(0x0028, 0x1050));
    public_tags.emplace("WindowWidth", Tag(0x0028, 0x1051));
    public_tags.emplace("RescaleIntercept", Tag(0x0028, 0x1052));
    public_tags.emplace("RescaleSlope", Tag(0x0028, 0x1053));
    public_tags.emplace("RescaleType", Tag(0x0028, 0x1054));
    public_tags.emplace("WindowCenterWidthExplanation", Tag(0x0028, 0x1055));
    public_tags.emplace("VOILUTFunction", Tag(0x0028, 0x1056));
    public_tags.emplace("GrayScale", Tag(0x0028, 0x1080));
    public_tags.emplace("RecommendedViewingMode", Tag(0x0028, 0x1090));
    public_tags.emplace("GrayLookupTableDescriptor", Tag(0x0028, 0x1100));
    public_tags.emplace("RedPaletteColorLookupTableDescriptor", Tag(0x0028, 0x1101));
    public_tags.emplace("GreenPaletteColorLookupTableDescriptor", Tag(0x0028, 0x1102));
    public_tags.emplace("BluePaletteColorLookupTableDescriptor", Tag(0x0028, 0x1103));
    public_tags.emplace("AlphaPaletteColorLookupTableDescriptor", Tag(0x0028, 0x1104));
    public_tags.emplace("LargeRedPaletteColorLookupTableDescriptor", Tag(0x0028, 0x1111));
    public_tags.emplace("LargeGreenPaletteColorLookupTableDescriptor", Tag(0x0028, 0x1112));
    public_tags.emplace("LargeBluePaletteColorLookupTableDescriptor", Tag(0x0028, 0x1113));
    public_tags.emplace("PaletteColorLookupTableUID", Tag(0x0028, 0x1199));
    public_tags.emplace("GrayLookupTableData", Tag(0x0028, 0x1200));
    public_tags.emplace("RedPaletteColorLookupTableData", Tag(0x0028, 0x1201));
    public_tags.emplace("GreenPaletteColorLookupTableData", Tag(0x0028, 0x1202));
    public_tags.emplace("BluePaletteColorLookupTableData", Tag(0x0028, 0x1203));
    public_tags.emplace("AlphaPaletteColorLookupTableData", Tag(0x0028, 0x1204));
    public_tags.emplace("LargeRedPaletteColorLookupTableData", Tag(0x0028, 0x1211));
    public_tags.emplace("LargeGreenPaletteColorLookupTableData", Tag(0x0028, 0x1212));
    public_tags.emplace("LargeBluePaletteColorLookupTableData", Tag(0x0028, 0x1213));
    public_tags.emplace("LargePaletteColorLookupTableUID", Tag(0x0028, 0x1214));
    public_tags.emplace("SegmentedRedPaletteColorLookupTableData", Tag(0x0028, 0x1221));
    public_tags.emplace("SegmentedGreenPaletteColorLookupTableData", Tag(0x0028, 0x1222));
    public_tags.emplace("SegmentedBluePaletteColorLookupTableData", Tag(0x0028, 0x1223));
    public_tags.emplace("SegmentedAlphaPaletteColorLookupTableData", Tag(0x0028, 0x1224));
    public_tags.emplace("StoredValueColorRangeSequence", Tag(0x0028, 0x1230));
    public_tags.emplace("MinimumStoredValueMapped", Tag(0x0028, 0x1231));
    public_tags.emplace("MaximumStoredValueMapped", Tag(0x0028, 0x1232));
    public_tags.emplace("BreastImplantPresent", Tag(0x0028, 0x1300));
    public_tags.emplace("PartialView", Tag(0x0028, 0x1350));
    public_tags.emplace("PartialViewDescription", Tag(0x0028, 0x1351));
    public_tags.emplace("PartialViewCodeSequence", Tag(0x0028, 0x1352));
    public_tags.emplace("SpatialLocationsPreserved", Tag(0x0028, 0x135a));
    public_tags.emplace("DataFrameAssignmentSequence", Tag(0x0028, 0x1401));
    public_tags.emplace("DataPathAssignment", Tag(0x0028, 0x1402));
    public_tags.emplace("BitsMappedToColorLookupTable", Tag(0x0028, 0x1403));
    public_tags.emplace("BlendingLUT1Sequence", Tag(0x0028, 0x1404));
    public_tags.emplace("BlendingLUT1TransferFunction", Tag(0x0028, 0x1405));
    public_tags.emplace("BlendingWeightConstant", Tag(0x0028, 0x1406));
    public_tags.emplace("BlendingLookupTableDescriptor", Tag(0x0028, 0x1407));
    public_tags.emplace("BlendingLookupTableData", Tag(0x0028, 0x1408));
    public_tags.emplace("EnhancedPaletteColorLookupTableSequence", Tag(0x0028, 0x140b));
    public_tags.emplace("BlendingLUT2Sequence", Tag(0x0028, 0x140c));
    public_tags.emplace("BlendingLUT2TransferFunction", Tag(0x0028, 0x140d));
    public_tags.emplace("DataPathID", Tag(0x0028, 0x140e));
    public_tags.emplace("RGBLUTTransferFunction", Tag(0x0028, 0x140f));
    public_tags.emplace("AlphaLUTTransferFunction", Tag(0x0028, 0x1410));
    public_tags.emplace("ICCProfile", Tag(0x0028, 0x2000));
    public_tags.emplace("ColorSpace", Tag(0x0028, 0x2002));
    public_tags.emplace("LossyImageCompression", Tag(0x0028, 0x2110));
    public_tags.emplace("LossyImageCompressionRatio", Tag(0x0028, 0x2112));
    public_tags.emplace("LossyImageCompressionMethod", Tag(0x0028, 0x2114));
    public_tags.emplace("ModalityLUTSequence", Tag(0x0028, 0x3000));
    public_tags.emplace("LUTDescriptor", Tag(0x0028, 0x3002));
    public_tags.emplace("LUTExplanation", Tag(0x0028, 0x3003));
    public_tags.emplace("ModalityLUTType", Tag(0x0028, 0x3004));
    public_tags.emplace("LUTData", Tag(0x0028, 0x3006));
    public_tags.emplace("VOILUTSequence", Tag(0x0028, 0x3010));
    public_tags.emplace("SoftcopyVOILUTSequence", Tag(0x0028, 0x3110));
    public_tags.emplace("ImagePresentationComments", Tag(0x0028, 0x4000));
    public_tags.emplace("BiPlaneAcquisitionSequence", Tag(0x0028, 0x5000));
    public_tags.emplace("RepresentativeFrameNumber", Tag(0x0028, 0x6010));
    public_tags.emplace("FrameNumbersOfInterest", Tag(0x0028, 0x6020));
    public_tags.emplace("FrameOfInterestDescription", Tag(0x0028, 0x6022));
    public_tags.emplace("FrameOfInterestType", Tag(0x0028, 0x6023));
    public_tags.emplace("MaskPointers", Tag(0x0028, 0x6030));
    public_tags.emplace("RWavePointer", Tag(0x0028, 0x6040));
    public_tags.emplace("MaskSubtractionSequence", Tag(0x0028, 0x6100));
    public_tags.emplace("MaskOperation", Tag(0x0028, 0x6101));
    public_tags.emplace("ApplicableFrameRange", Tag(0x0028, 0x6102));
    public_tags.emplace("MaskFrameNumbers", Tag(0x0028, 0x6110));
    public_tags.emplace("ContrastFrameAveraging", Tag(0x0028, 0x6112));
    public_tags.emplace("MaskSubPixelShift", Tag(0x0028, 0x6114));
    public_tags.emplace("TIDOffset", Tag(0x0028, 0x6120));
    public_tags.emplace("MaskOperationExplanation", Tag(0x0028, 0x6190));
    public_tags.emplace("EquipmentAdministratorSequence", Tag(0x0028, 0x7000));
    public_tags.emplace("NumberOfDisplaySubsystems", Tag(0x0028, 0x7001));
    public_tags.emplace("CurrentConfigurationID", Tag(0x0028, 0x7002));
    public_tags.emplace("DisplaySubsystemID", Tag(0x0028, 0x7003));
    public_tags.emplace("DisplaySubsystemName", Tag(0x0028, 0x7004));
    public_tags.emplace("DisplaySubsystemDescription", Tag(0x0028, 0x7005));
    public_tags.emplace("SystemStatus", Tag(0x0028, 0x7006));
    public_tags.emplace("SystemStatusComment", Tag(0x0028, 0x7007));
    public_tags.emplace("TargetLuminanceCharacteristicsSequence", Tag(0x0028, 0x7008));
    public_tags.emplace("LuminanceCharacteristicsID", Tag(0x0028, 0x7009));
    public_tags.emplace("DisplaySubsystemConfigurationSequence", Tag(0x0028, 0x700a));
    public_tags.emplace("ConfigurationID", Tag(0x0028, 0x700b));
    public_tags.emplace("ConfigurationName", Tag(0x0028, 0x700c));
    public_tags.emplace("ConfigurationDescription", Tag(0x0028, 0x700d));
    public_tags.emplace("ReferencedTargetLuminanceCharacteristicsID", Tag(0x0028, 0x700e));
    public_tags.emplace("QAResultsSequence", Tag(0x0028, 0x700f));
    public_tags.emplace("DisplaySubsystemQAResultsSequence", Tag(0x0028, 0x7010));
    public_tags.emplace("ConfigurationQAResultsSequence", Tag(0x0028, 0x7011));
    public_tags.emplace("MeasurementEquipmentSequence", Tag(0x0028, 0x7012));
    public_tags.emplace("MeasurementFunctions", Tag(0x0028, 0x7013));
    public_tags.emplace("MeasurementEquipmentType", Tag(0x0028, 0x7014));
    public_tags.emplace("VisualEvaluationResultSequence", Tag(0x0028, 0x7015));
    public_tags.emplace("DisplayCalibrationResultSequence", Tag(0x0028, 0x7016));
    public_tags.emplace("DDLValue", Tag(0x0028, 0x7017));
    public_tags.emplace("CIExyWhitePoint", Tag(0x0028, 0x7018));
    public_tags.emplace("DisplayFunctionType", Tag(0x0028, 0x7019));
    public_tags.emplace("GammaValue", Tag(0x0028, 0x701a));
    public_tags.emplace("NumberOfLuminancePoints", Tag(0x0028, 0x701b));
    public_tags.emplace("LuminanceResponseSequence", Tag(0x0028, 0x701c));
    public_tags.emplace("TargetMinimumLuminance", Tag(0x0028, 0x701d));
    public_tags.emplace("TargetMaximumLuminance", Tag(0x0028, 0x701e));
    public_tags.emplace("LuminanceValue", Tag(0x0028, 0x701f));
    public_tags.emplace("LuminanceResponseDescription", Tag(0x0028, 0x7020));
    public_tags.emplace("WhitePointFlag", Tag(0x0028, 0x7021));
    public_tags.emplace("DisplayDeviceTypeCodeSequence", Tag(0x0028, 0x7022));
    public_tags.emplace("DisplaySubsystemSequence", Tag(0x0028, 0x7023));
    public_tags.emplace("LuminanceResultSequence", Tag(0x0028, 0x7024));
    public_tags.emplace("AmbientLightValueSource", Tag(0x0028, 0x7025));
    public_tags.emplace("MeasuredCharacteristics", Tag(0x0028, 0x7026));
    public_tags.emplace("LuminanceUniformityResultSequence", Tag(0x0028, 0x7027));
    public_tags.emplace("VisualEvaluationTestSequence", Tag(0x0028, 0x7028));
    public_tags.emplace("TestResult", Tag(0x0028, 0x7029));
    public_tags.emplace("TestResultComment", Tag(0x0028, 0x702a));
    public_tags.emplace("TestImageValidation", Tag(0x0028, 0x702b));
    public_tags.emplace("TestPatternCodeSequence", Tag(0x0028, 0x702c));
    public_tags.emplace("MeasurementPatternCodeSequence", Tag(0x0028, 0x702d));
    public_tags.emplace("VisualEvaluationMethodCodeSequence", Tag(0x0028, 0x702e));
    public_tags.emplace("PixelDataProviderURL", Tag(0x0028, 0x7fe0));
    public_tags.emplace("DataPointRows", Tag(0x0028, 0x9001));
    public_tags.emplace("DataPointColumns", Tag(0x0028, 0x9002));
    public_tags.emplace("SignalDomainColumns", Tag(0x0028, 0x9003));
    public_tags.emplace("LargestMonochromePixelValue", Tag(0x0028, 0x9099));
    public_tags.emplace("DataRepresentation", Tag(0x0028, 0x9108));
    public_tags.emplace("PixelMeasuresSequence", Tag(0x0028, 0x9110));
    public_tags.emplace("FrameVOILUTSequence", Tag(0x0028, 0x9132));
    public_tags.emplace("PixelValueTransformationSequence", Tag(0x0028, 0x9145));
    public_tags.emplace("SignalDomainRows", Tag(0x0028, 0x9235));
    public_tags.emplace("DisplayFilterPercentage", Tag(0x0028, 0x9411));
    public_tags.emplace("FramePixelShiftSequence", Tag(0x0028, 0x9415));
    public_tags.emplace("SubtractionItemID", Tag(0x0028, 0x9416));
    public_tags.emplace("PixelIntensityRelationshipLUTSequence", Tag(0x0028, 0x9422));
    public_tags.emplace("FramePixelDataPropertiesSequence", Tag(0x0028, 0x9443));
    public_tags.emplace("GeometricalProperties", Tag(0x0028, 0x9444));
    public_tags.emplace("GeometricMaximumDistortion", Tag(0x0028, 0x9445));
    public_tags.emplace("ImageProcessingApplied", Tag(0x0028, 0x9446));
    public_tags.emplace("MaskSelectionMode", Tag(0x0028, 0x9454));
    public_tags.emplace("LUTFunction", Tag(0x0028, 0x9474));
    public_tags.emplace("MaskVisibilityPercentage", Tag(0x0028, 0x9478));
    public_tags.emplace("PixelShiftSequence", Tag(0x0028, 0x9501));
    public_tags.emplace("RegionPixelShiftSequence", Tag(0x0028, 0x9502));
    public_tags.emplace("VerticesOfTheRegion", Tag(0x0028, 0x9503));
    public_tags.emplace("MultiFramePresentationSequence", Tag(0x0028, 0x9505));
    public_tags.emplace("PixelShiftFrameRange", Tag(0x0028, 0x9506));
    public_tags.emplace("LUTFrameRange", Tag(0x0028, 0x9507));
    public_tags.emplace("ImageToEquipmentMappingMatrix", Tag(0x0028, 0x9520));
    public_tags.emplace("EquipmentCoordinateSystemIdentification", Tag(0x0028, 0x9537));
}

}

}