documentation_complete: true

hidden: true

title: Default Profile for Ubuntu 24.04

description: |-
    This profile contains all the rules from all control files.
    It won't be rendered into an XCCDF Profile entity, nor it will select any
    of these rules by default. The only purpose of this profile
    is to make sure any unselected rules are added to the product's XCCDF Benchmark.

selections:
    - account_disable_post_pw_expiration
    - accounts_maximum_age_login_defs
    - accounts_minimum_age_login_defs
    - accounts_no_uid_except_zero
    - accounts_password_all_shadowed
    - accounts_password_last_change_is_in_past
    - accounts_password_pam_dcredit
    - accounts_password_pam_dictcheck
    - accounts_password_pam_difok
    - accounts_password_pam_enforce_root
    - accounts_password_pam_enforcing
    - accounts_password_pam_lcredit
    - accounts_password_pam_maxrepeat
    - accounts_password_pam_maxsequence
    - accounts_password_pam_minclass
    - accounts_password_pam_minlen
    - accounts_password_pam_ocredit
    - accounts_password_pam_pwhistory_enabled
    - accounts_password_pam_pwhistory_enforce_root
    - accounts_password_pam_pwhistory_remember
    - accounts_password_pam_pwhistory_use_authtok
    - accounts_password_pam_pwquality_enabled
    - accounts_password_pam_ucredit
    - accounts_password_pam_unix_authtok
    - accounts_password_pam_unix_enabled
    - accounts_password_pam_unix_no_remember
    - accounts_password_set_max_life_existing
    - accounts_password_set_min_life_existing
    - accounts_passwords_pam_faillock_deny
    - accounts_passwords_pam_faillock_enabled
    - accounts_passwords_pam_faillock_root_unlock_time
    - accounts_passwords_pam_faillock_unlock_time
    - accounts_password_warn_age_login_defs
    - accounts_root_gid_zero
    - accounts_root_path_dirs_no_write
    - accounts_tmout
    - accounts_umask_etc_bashrc
    - accounts_umask_etc_login_defs
    - accounts_umask_etc_profile
    - accounts_umask_root
    - accounts_user_dot_group_ownership
    - accounts_user_dot_user_ownership
    - accounts_user_interactive_home_directory_exists
    - account_unique_id
    - account_unique_name
    - aide_build_database
    - aide_check_audit_tools
    - aide_periodic_checking_systemd_timer
    - all_apparmor_profiles_enforced
    - all_apparmor_profiles_in_enforce_complain_mode
    - auditd_data_disk_error_action
    - auditd_data_disk_full_action
    - auditd_data_retention_action_mail_acct
    - auditd_data_retention_admin_space_left_action
    - auditd_data_retention_max_log_file
    - auditd_data_retention_max_log_file_action
    - auditd_data_retention_space_left_action
    - audit_rules_dac_modification_chmod
    - audit_rules_dac_modification_chown
    - audit_rules_dac_modification_fchmod
    - audit_rules_dac_modification_fchmodat
    - audit_rules_dac_modification_fchown
    - audit_rules_dac_modification_fchownat
    - audit_rules_dac_modification_fremovexattr
    - audit_rules_dac_modification_fsetxattr
    - audit_rules_dac_modification_lchown
    - audit_rules_dac_modification_lremovexattr
    - audit_rules_dac_modification_lsetxattr
    - audit_rules_dac_modification_removexattr
    - audit_rules_dac_modification_setxattr
    - audit_rules_execution_chacl
    - audit_rules_execution_chcon
    - audit_rules_execution_setfacl
    - audit_rules_file_deletion_events_rename
    - audit_rules_file_deletion_events_renameat
    - audit_rules_file_deletion_events_unlink
    - audit_rules_file_deletion_events_unlinkat
    - audit_rules_immutable
    - audit_rules_kernel_module_loading_delete
    - audit_rules_kernel_module_loading_init
    - audit_rules_login_events_faillock
    - audit_rules_login_events_lastlog
    - audit_rules_mac_modification_etc_apparmor
    - audit_rules_mac_modification_etc_apparmor_d
    - audit_rules_media_export
    - audit_rules_networkconfig_modification
    - audit_rules_privileged_commands
    - audit_rules_privileged_commands_insmod
    - audit_rules_privileged_commands_modprobe
    - audit_rules_privileged_commands_rmmod
    - audit_rules_privileged_commands_usermod
    - audit_rules_session_events
    - audit_rules_suid_privilege_function
    - audit_rules_sysadmin_actions
    - audit_rules_time_adjtimex
    - audit_rules_time_clock_settime
    - audit_rules_time_settimeofday
    - audit_rules_time_watch_localtime
    - audit_rules_unsuccessful_file_modification_creat
    - audit_rules_unsuccessful_file_modification_ftruncate
    - audit_rules_unsuccessful_file_modification_open
    - audit_rules_unsuccessful_file_modification_openat
    - audit_rules_unsuccessful_file_modification_truncate
    - audit_rules_usergroup_modification_group
    - audit_rules_usergroup_modification_gshadow
    - audit_rules_usergroup_modification_nsswitch_conf
    - audit_rules_usergroup_modification_opasswd
    - audit_rules_usergroup_modification_pam_conf
    - audit_rules_usergroup_modification_pamd
    - audit_rules_usergroup_modification_passwd
    - audit_rules_usergroup_modification_shadow
    - audit_sudo_log_events
    - banner_etc_issue_cis
    - banner_etc_issue_net_cis
    - banner_etc_motd_cis
    - check_ufw_active
    - chronyd_configure_pool_and_server
    - chronyd_run_as_chrony_user
    - dconf_gnome_banner_enabled
    - dconf_gnome_disable_automount
    - dconf_gnome_disable_automount_open
    - dconf_gnome_disable_autorun
    - dconf_gnome_disable_user_list
    - dconf_gnome_login_banner_text
    - dconf_gnome_screensaver_idle_delay
    - dconf_gnome_screensaver_lock_delay
    - dconf_gnome_screensaver_lock_enabled
    - directory_permissions_var_log_audit
    - disable_host_auth
    - disable_users_coredumps
    - ensure_pam_wheel_group_empty
    - ensure_root_access_controlled
    - ensure_shadow_group_empty
    - file_at_allow_exists
    - file_cron_allow_exists
    - file_cron_deny_not_exist
    - file_groupowner_at_allow
    - file_groupowner_at_deny
    - file_groupowner_backup_etc_group
    - file_groupowner_backup_etc_gshadow
    - file_groupowner_backup_etc_passwd
    - file_groupowner_backup_etc_shadow
    - file_groupowner_cron_allow
    - file_groupowner_cron_d
    - file_groupowner_cron_daily
    - file_groupowner_cron_hourly
    - file_groupowner_cron_monthly
    - file_groupowner_crontab
    - file_groupowner_cron_weekly
    - file_groupowner_etc_group
    - file_groupowner_etc_gshadow
    - file_groupowner_etc_issue
    - file_groupowner_etc_issue_net
    - file_groupowner_etc_motd
    - file_groupowner_etc_passwd
    - file_groupowner_etc_security_opasswd
    - file_groupowner_etc_security_opasswd_old
    - file_groupowner_etc_shadow
    - file_groupowner_etc_shells
    - file_groupownership_audit_binaries
    - file_groupownership_audit_configuration
    - file_groupownership_home_directories
    - file_group_ownership_var_log_audit
    - file_groupowner_sshd_config
    - file_owner_at_allow
    - file_owner_at_deny
    - file_owner_backup_etc_group
    - file_owner_backup_etc_gshadow
    - file_owner_backup_etc_passwd
    - file_owner_backup_etc_shadow
    - file_owner_cron_allow
    - file_owner_cron_d
    - file_owner_cron_daily
    - file_owner_cron_hourly
    - file_owner_cron_monthly
    - file_owner_crontab
    - file_owner_cron_weekly
    - file_owner_etc_group
    - file_owner_etc_gshadow
    - file_owner_etc_issue
    - file_owner_etc_issue_net
    - file_owner_etc_motd
    - file_owner_etc_passwd
    - file_owner_etc_security_opasswd
    - file_owner_etc_security_opasswd_old
    - file_owner_etc_shadow
    - file_owner_etc_shells
    - file_owner_grub2_cfg
    - file_ownership_audit_binaries
    - file_ownership_audit_configuration
    - file_ownership_home_directories
    - file_ownership_var_log_audit_stig
    - file_owner_sshd_config
    - file_permissions_at_allow
    - file_permissions_at_deny
    - file_permissions_audit_binaries
    - file_permissions_backup_etc_group
    - file_permissions_backup_etc_gshadow
    - file_permissions_backup_etc_passwd
    - file_permissions_backup_etc_shadow
    - file_permissions_cron_allow
    - file_permissions_cron_d
    - file_permissions_cron_daily
    - file_permissions_cron_hourly
    - file_permissions_cron_monthly
    - file_permissions_crontab
    - file_permissions_cron_weekly
    - file_permissions_etc_audit_auditd
    - file_permissions_etc_audit_rules
    - file_permissions_etc_audit_rulesd
    - file_permissions_etc_group
    - file_permissions_etc_gshadow
    - file_permissions_etc_issue
    - file_permissions_etc_issue_net
    - file_permissions_etc_motd
    - file_permissions_etc_passwd
    - file_permissions_etc_security_opasswd
    - file_permissions_etc_security_opasswd_old
    - file_permissions_etc_shadow
    - file_permissions_etc_shells
    - file_permissions_grub2_cfg
    - file_permissions_home_directories
    - file_permissions_sshd_config
    - file_permissions_sshd_private_key
    - file_permissions_sshd_pub_key
    - file_permissions_unauthorized_world_writable
    - file_permissions_ungroupowned
    - file_permissions_var_log_audit
    - file_permission_user_bash_history
    - file_permission_user_init_files
    - firewall_single_service_active
    - gid_passwd_group_same
    - gnome_gdm_disable_xdmcp
    - groups_no_zero_gid_except_root
    - group_unique_id
    - group_unique_name
    - grub2_audit_argument
    - grub2_audit_backlog_limit_argument
    - grub2_enable_apparmor
    - grub2_password
    - grub2_uefi_password
    - has_nonlocal_mta
    - ip6tables_rules_for_open_ports
    - iptables_rules_for_open_ports
    - journald_compress
    - journald_disable_forward_to_syslog
    - journald_forward_to_syslog
    - journald_storage
    - kernel_module_cramfs_disabled
    - kernel_module_dccp_disabled
    - kernel_module_freevxfs_disabled
    - kernel_module_hfs_disabled
    - kernel_module_hfsplus_disabled
    - kernel_module_jffs2_disabled
    - kernel_module_overlayfs_disabled
    - kernel_module_rds_disabled
    - kernel_module_sctp_disabled
    - kernel_module_squashfs_disabled
    - kernel_module_tipc_disabled
    - kernel_module_udf_disabled
    - kernel_module_usb-storage_disabled
    - logging_services_active
    - mount_option_dev_shm_nodev
    - mount_option_dev_shm_noexec
    - mount_option_dev_shm_nosuid
    - mount_option_home_nodev
    - mount_option_home_nosuid
    - mount_option_tmp_nodev
    - mount_option_tmp_noexec
    - mount_option_tmp_nosuid
    - mount_option_var_log_audit_nodev
    - mount_option_var_log_audit_noexec
    - mount_option_var_log_audit_nosuid
    - mount_option_var_log_nodev
    - mount_option_var_log_noexec
    - mount_option_var_log_nosuid
    - mount_option_var_nodev
    - mount_option_var_nosuid
    - mount_option_var_tmp_nodev
    - mount_option_var_tmp_noexec
    - mount_option_var_tmp_nosuid
    - nftables_ensure_default_deny_policy
    - nftables_rules_permanent
    - no_dirs_unowned_by_root
    - no_empty_passwords
    - no_empty_passwords_etc_shadow
    - no_files_unowned_by_user
    - no_forward_files
    - no_invalid_shell_accounts_unlocked
    - no_netrc_files
    - no_nologin_in_shells
    - no_rsh_trust_files
    - no_shelllogin_for_systemaccounts
    - ntp_single_service_active
    - package_aide_installed
    - package_apparmor_installed
    - package_apparmor-utils_installed
    - package_audit-audispd-plugins_installed
    - package_audit_installed
    - package_autofs_removed
    - package_avahi_removed
    - package_bind_removed
    - package_chrony_installed
    - package_cron_installed
    - package_cups_removed
    - package_dhcp_removed
    - package_dnsmasq_removed
    - package_dovecot_removed
    - package_ftp_removed
    - package_gdm_removed
    - package_httpd_removed
    - package_iptables_installed
    - package_iptables-persistent_installed
    - package_iptables-persistent_removed
    - package_net-snmp_removed
    - package_nfs-kernel-server_removed
    - package_nftables_installed
    - package_nginx_removed
    - package_nis_removed
    - package_openldap-clients_removed
    - package_openldap-servers_removed
    - package_pam_modules_installed
    - package_pam_pwquality_installed
    - package_pam_runtime_installed
    - package_prelink_removed
    - package_rpcbind_removed
    - package_rsh_removed
    - package_rsync_removed
    - package_rsyslog_installed
    - package_samba_removed
    - package_squid_removed
    - package_sudo_installed
    - package_systemd-journal-remote_installed
    - package_talk_removed
    - package_telnet_removed
    - package_tftp-server_removed
    - package_timesyncd_installed
    - package_tnftp_removed
    - package_ufw_installed
    - package_ufw_removed
    - package_vsftpd_removed
    - package_xinetd_removed
    - package_xorg-x11-server-common_removed
    - package_ypserv_removed
    - partition_for_dev_shm
    - partition_for_home
    - partition_for_tmp
    - partition_for_var
    - partition_for_var_log
    - partition_for_var_log_audit
    - partition_for_var_tmp
    - permissions_local_var_log
    - postfix_network_listening_disabled
    - root_path_all_dirs
    - root_path_no_dot
    - rsyslog_filecreatemode
    - rsyslog_nolisten
    - rsyslog_remote_loghost
    - service_apport_disabled
    - service_auditd_enabled
    - service_autofs_disabled
    - service_avahi-daemon_disabled
    - service_bluetooth_disabled
    - service_chronyd_disabled
    - service_chronyd_enabled
    - service_cron_enabled
    - service_cups_disabled
    - service_dhcpd6_disabled
    - service_dhcpd_disabled
    - service_dnsmasq_disabled
    - service_dovecot_disabled
    - service_httpd_disabled
    - service_named_disabled
    - service_nfs_disabled
    - service_nftables_disabled
    - service_nftables_enabled
    - service_nginx_disabled
    - service_rpcbind_disabled
    - service_rsyncd_disabled
    - service_rsyslog_enabled
    - service_slapd_disabled
    - service_smb_disabled
    - service_snmpd_disabled
    - service_squid_disabled
    - service_systemd-journald_enabled
    - service_systemd-journal-upload_enabled
    - service_tftp_disabled
    - service_timesyncd_configured
    - service_timesyncd_disabled
    - service_timesyncd_enabled
    - service_ufw_enabled
    - service_vsftpd_disabled
    - service_xinetd_disabled
    - service_ypserv_disabled
    - set_ip6tables_default_rule
    - set_iptables_default_rule
    - set_ipv6_loopback_traffic
    - set_loopback_traffic
    - set_nftables_base_chain
    - set_nftables_loopback_traffic
    - set_nftables_table
    - set_password_hashing_algorithm_logindefs
    - set_password_hashing_algorithm_systemauth
    - set_ufw_default_rule
    - set_ufw_loopback_traffic
    - socket_systemd-journal-remote_disabled
    - sshd_disable_empty_passwords
    - sshd_disable_forwarding
    - sshd_disable_gssapi_auth
    - sshd_disable_rhosts
    - sshd_disable_root_login
    - sshd_do_not_permit_user_env
    - sshd_enable_pam
    - sshd_enable_warning_banner_net
    - sshd_limit_user_access
    - sshd_set_idle_timeout
    - sshd_set_keepalive
    - sshd_set_login_grace_time
    - sshd_set_loglevel_info
    - sshd_set_max_auth_tries
    - sshd_set_max_sessions
    - sshd_set_maxstartups
    - sshd_use_strong_ciphers
    - sshd_use_strong_kex
    - sshd_use_strong_macs
    - sudo_add_use_pty
    - sudo_custom_logfile
    - sudo_remove_no_authenticate
    - sudo_require_authentication
    - sudo_require_reauthentication
    - sysctl_fs_suid_dumpable
    - sysctl_kernel_randomize_va_space
    - sysctl_kernel_yama_ptrace_scope
    - sysctl_net_ipv4_conf_all_accept_redirects
    - sysctl_net_ipv4_conf_all_accept_source_route
    - sysctl_net_ipv4_conf_all_log_martians
    - sysctl_net_ipv4_conf_all_rp_filter
    - sysctl_net_ipv4_conf_all_secure_redirects
    - sysctl_net_ipv4_conf_all_send_redirects
    - sysctl_net_ipv4_conf_default_accept_redirects
    - sysctl_net_ipv4_conf_default_accept_source_route
    - sysctl_net_ipv4_conf_default_log_martians
    - sysctl_net_ipv4_conf_default_rp_filter
    - sysctl_net_ipv4_conf_default_secure_redirects
    - sysctl_net_ipv4_conf_default_send_redirects
    - sysctl_net_ipv4_icmp_echo_ignore_broadcasts
    - sysctl_net_ipv4_icmp_ignore_bogus_error_responses
    - sysctl_net_ipv4_ip_forward
    - sysctl_net_ipv4_tcp_syncookies
    - sysctl_net_ipv6_conf_all_accept_ra
    - sysctl_net_ipv6_conf_all_accept_redirects
    - sysctl_net_ipv6_conf_all_accept_source_route
    - sysctl_net_ipv6_conf_all_forwarding
    - sysctl_net_ipv6_conf_default_accept_ra
    - sysctl_net_ipv6_conf_default_accept_redirects
    - sysctl_net_ipv6_conf_default_accept_source_route
    - systemd_journal_upload_server_tls
    - systemd_journal_upload_url
    - ufw_rules_for_open_ports
    - use_pam_wheel_group_for_su
    - wireless_disable_interfaces
    - zipl_audit_argument
    - zipl_audit_backlog_limit_argument
