#include <stdio.h>
#include "libucsv.h"

int main()
{
	int first_in_line = 1;
	ucsv_ctx_t ctx = {0};

	for(;;) {
		int c;
		ucsv_token_t t;

		c = fgetc(stdin);
		t = ucsv_parser_char(&ctx, c);
		if (t == UCSV_END)
			break;
		if ((t == UCSV_TOK_TEXT) || (t == UCSV_TOK_END_LINE)) {
			fprintf(stderr, "TEXT: '%s'\n", ctx.buf);
			ucsv_print_cell(&ctx, stdout, ctx.buf, first_in_line);
			first_in_line = 0;
		}
		if (t == UCSV_TOK_END_LINE) {
			fprintf(stderr, "ENDLINE\n");
			ucsv_print_endline(stdout);
			first_in_line = 1;
		}
		
	}

	ucsv_parser_uninit(&ctx);
	return 0;
}
