#ifndef DSRGLWINDOW_H
#define DSRGLWINDOW_H

#include "molecule.h"
#include "dsrgui.h"
#include <QOpenGLWidget>
class DSRGlWindow : public QOpenGLWidget
{
  Q_OBJECT

public:
  DSRGlWindow(QWidget *parent, Molecule *m, DSRMol header, QString fragment);
  virtual ~DSRGlWindow() override;
  CEnvironment xd;        //!< MyAtom list of the molecule
  CEnvironment selFragAt; //! MyAtom list of selected fragment atoms
  CEnvironment fita;      //! MyAtom list of atoms where the fragment is fitted to plus the surrounding
  Connection bonds;       //!< MyBond list of the fragment molecule bonds
  Connection fitabonds;   //!< MyBond list of the target molecule bonds
  Molecule *m_molecule;
  QString source_atoms;
  QCheckBox *showFit;
  QCheckBox *showFitLabel;
  bool selchanged = true;
  void qglColor(const QColor color);
  void renderText(double x, double y, double z, const QString &str);
public slots:
  void display_fragment(DSRMol frag, bool clear_sel=true);
  void makeInfo();
  void clear_molecule();
  void set_label_color();
  void mousePressEvent(QMouseEvent *event) override;
signals:
  void sourceStringChanged();
  void updateInfo(QString);
protected:
  void initializeGL() override;
  void resizeGL(int width, int height) override;
  void paintGL() override;
  void mouseMoveEvent(QMouseEvent *event) override;
  void wheelEvent(QWheelEvent *event) override;
private:  
  inline void __RotateCS( double c, double s, double& X, double& Y ) ;
  void glTranslateL( const double dx, const double dy, const double dz );
  void glRotateL( const double dang, const double x, const double y, const double z );
  QFont myFont; //!< a font for the atom labels
  //Molecule mole;
  QColor dsrLabelColor;
  GLint vp[4];  
  double labScal;
  void draw();
  double retinafktr = 1;
  void project(double x, double y, double z, GLdouble &tx, GLdouble &ty);
  double L, moux, mouy;
  int wh,ww;
  void tryfit();
  virtual QSize sizeHint() const override;
  virtual QSize minimumSizeHint() const override;
};

#endif // DSRGLWINDOW_H
