# encoding: utf-8
=begin

* Name: SiSU

** Description: documents, structuring, processing, publishing, search
*** summary of generated outputs and metadata

** Author: Ralph Amissah
  [ralph@amissah.com]
  [ralph.amissah@gmail.com]

** Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
  2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016 Ralph Amissah,
  All Rights Reserved.

** License: GPL 3 or later:

  SiSU, a framework for document structuring, publishing and search

  Copyright (C) Ralph Amissah

  This program is free software: you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation, either version 3 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program. If not, see [http://www.gnu.org/licenses/].

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
  [http://www.fsf.org/licensing/licenses/gpl.html]
  [http://www.gnu.org/licenses/gpl.html]

** SiSU uses:
  * Standard SiSU markup syntax,
  * Standard SiSU meta-markup syntax, and the
  * Standard SiSU object citation numbering and system

** Hompages:
  [http://www.jus.uio.no/sisu]
  [http://www.sisudoc.org]

** Git
  [http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary]
  [http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/html_manifest.rb;hb=HEAD]

=end
module SiSU_Manifest
  require_relative 'se'                                 # se.rb
    include SiSU_Env
  require_relative 'prog_text_translation'              # prog_text_translation.rb
  require_relative 'se_hub_particulars'                 # se_hub_particulars.rb
    include SiSU_Particulars
  require_relative 'html_parts'                         # html_parts.rb
  require_relative 'html_minitoc'                       # html_minitoc.rb
  require_relative 'html'                               # html.rb
    include SiSU_HTML_Format
  require_relative 'dp'                                 # dp.rb
    include SiSU_Param
  require_relative 'i18n'                               # i18n.rb
  class Source
    def initialize(opt)
      @opt=opt
      @particulars=SiSU_Particulars::CombinedSingleton.instance.get_all(opt)
      l=SiSU_Env::StandardiseLanguage.new(opt.lng).language
      @doc_language=l[:n]
    end
    def read
      begin
        @env=SiSU_Env::InfoEnv.new(@opt.fns)
        @md=SiSU_Param::Parameters.new(@opt).get
        xbrowser=@env.program.web_browser
        browser=@env.program.console_web_browser
#       webserv_url=@env.path.url.output_tell #fix in sysenv
        unless @opt.act[:quiet][:set]==:on
          url_html='file://' \
          + @md.file.output_path.manifest.dir + '/' \
          + @md.file.base_filename.manifest
          (@opt.act[:verbose][:set]==:on \
          || @opt.act[:verbose_plus][:set]==:on \
          || @opt.act[:maintenance][:set]==:on) \
          ? SiSU_Screen::Ansi.new(
              @opt.act[:color_state][:set],
              'Manifest',
              "#{xbrowser} #{url_html}"
            ).green_hi_blue
          : SiSU_Screen::Ansi.new(
              @opt.act[:color_state][:set],
              'Manifest',
              "[#{@opt.f_pth[:lng_is]}]",
              "#{url_html}"
            ).grey_title_grey_blue
          if (@md.opt.act[:verbose][:set]==:on \
          || @md.opt.act[:verbose_plus][:set]==:on)
            SiSU_Screen::Ansi.new(
              @opt.act[:color_state][:set],
              "#{browser} #{url_html}"
            ).grey_tab
          end
        end
        data=SiSU_HTML::Source::HTML_Environment.new(@particulars).tuned_file_instructions
        SiSU_Manifest::Source::Output.new(@md).check_output(data)
      rescue
        SiSU_Errors::Rescued.new($!,$@,@opt.selections.str,@opt.fns).location do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
        SiSU_Env::CreateSite.new(@opt).cp_css
        Dir.chdir(@opt.f_pth[:pth])
      end
    end
    private
    class Output <Source
      include SiSU_Parts_HTML
      def initialize(md)
        @manifest={ txt: [], html: [] }
        @md,@fns=md,md.fns
        @env=SiSU_Env::InfoEnv.new(md.fns)
        @f=SiSU_Env::FileOp.new(md)
        @fnb=md.fnb
        @base_url="#{@env.url.root}/#{@fnb}"
        @o_str=SiSU_Env::FileOp.new(md).output_dir_structure
        @image_path=(@o_str.dump_or_redirect?) \
        ? './image'
        : %{#{@f.path_rel_links.html_scroll_2}_sisu/image_sys}
        @base_path=@f.output_path.manifest.dir
        @@dg ||=SiSU_Env::InfoEnv.new(md.fns,md).digest(md.opt).type
        @dg=@@dg
        l=SiSU_Env::StandardiseLanguage.new(md.opt.lng).language
        @language=l[:n]
        @translate=SiSU_Translate::Source.new(md,@language)
        @stylesheet=SiSU_Style::CSS_HeadInfo.new(md).stylesheet
        @fn_lng=(@f.output_dir_structure.by_language_code?) \
        ? ''
        : ('.' + md.opt.lng)
      end
      def output
        manifest=@f.write_file.manifest
        @manifest[:html].each do |x|
          x=x.gsub(Xx[:html_relative2],@f.path_rel_links.html_scroll_2).
            gsub(Xx[:html_relative1],@f.path_rel_links.html_scroll_1)
          manifest << x
        end
      end
      def url_make(url,file,src=nil)
        if @o_str.dump_or_redirect?
          ''
        elsif src==:src #check
          %{<br>#{the_url_decoration.xml_open}<a href="#{url}/#{file}">#{url}/#{file}</a>#{the_url_decoration.xml_close}}
        else
          %{<p class="tiny">#{the_url_decoration.xml_open}<a href="#{url}/#{file}">#{url}/#{file}</a>#{the_url_decoration.xml_close}</p>}
        end
      end
      def summarize(desc,id,file,pth='',rel='',url='',img='● ')
        size=(File.size("#{pth}/#{file}")/1024.00).to_s
        kb=/([0-9]+\.[0-9]{0,1})/m.match(size)[1]
        @manifest[:txt] << "#{file} #{desc} #{kb}\n"
        @manifest[:html] << %{<tr><th class="left"><p class="norm"><a href="#{rel}/#{file}">#{img}#{desc}</a></p></th><td><p class="small"><a href="#{rel}/#{file}">#{file}</a></p>#{url_make(url,file)}</td><td class="right"><p class="right">#{kb}</p></td></tr>\n}
      end
      def summarize_html_seg(desc,id,file,pth='',rel='',url='',img='● ')
        size=(File.size("#{pth}/#{file}")/1024.00).to_s
        kb=/([0-9]+\.[0-9]{0,1})/m.match(size)[1]
        @manifest[:txt] << "#{file} #{desc} #{kb}\n"
        @manifest[:html] << %{<tr><th class="left"><p class="norm"><a href="#{rel}/#{file}">#{img}#{desc}</a></p></th><td><p class="small"><a href="#{rel}/#{file}">#{file}</a></p>#{url_make(url,file)}</td><td class="right"><p class="right">#{kb}</p></td></tr>\n}
      end
      def summarize_sources(desc,id,file,pth,rel,url)
        sys=SiSU_Env::SystemCall.new
        dgst=case @dg
        when :sha512
          sys.sha512("#{pth}/#{file}")
        when :sha256
          sys.sha256("#{pth}/#{file}")
        when :md5
          sys.md5("#{pth}/#{file}")
        else
        end
        dgst=dgst ? dgst : [ '', 'n/a' ]
        if (@md.opt.act[:verbose][:set]==:on \
        || @md.opt.act[:verbose_plus][:set]==:on \
        || @md.opt.act[:maintenance][:set]==:on)
          SiSU_Screen::Ansi.new(
            @md.opt.act[:color_state][:set],
            "#{dgst[1]} #{file}"
          ).warn
        end
        size=(File.size("#{pth}/#{file}")/1024.00).to_s
        kb=/([0-9]+\.[0-9]{0,1})/m.match(size)[1]
        @manifest[:txt] << "#{file} #{desc} #{kb}\n"
        @manifest[:html] << %{<tr>} \
        + %{<th class="left"><p class="norm" id="#{id}"><a href="#{rel}/#{file}">#{desc}</a></p></th>} \
        + %{<td class="right"><p class="tiny"><a href="#{rel}/#{file}">#{file}</a> &nbsp;&nbsp;#{dgst[1]}#{url_make(url,file,:src)}</p></td>} \
        + %{<td class="right"><p class="right">#{kb}</p></td>} \
        + %{</tr>\n} \
          if kb and kb =~/\d+/
      end
      def published_manifests?
        @f=SiSU_Env::FileOp.new(@md) #.base_filename
        @m=[]
        url=@f.output_path.base.url
        manifests={}
        mp,mn,mt,mr=nil,nil,nil,nil
        ln=SiSU_i18n::Languages.new.language.list
        Px[:lng_lst].each do |lc|
          lngc=SiSU_Env::FilenameLanguageCodeInsert.new(@md.opt,lc).language_code_insert
          fnh={
             fn: @md.fnb,
             lng: lngc,
          }
          mn=@f.base_filename.manifest(fnh)
          if @o_str.dump_or_redirect? #does not work for --redirect or --dump
            mp="#{@f.output_path.base.dir}"
            mt="#{mp}/#{mn}"
            mr="../../#{lc}/manifest/#{mn}"
            mu="#{url}/#{mn}"
          elsif @f.output_dir_structure.by_language_code?
            mp="#{@f.output_path.base.dir}/#{lc}/manifest"
            mt="#{mp}/#{mn}"
            mr="../../#{lc}/manifest/#{mn}"
            mu="#{url}/#{lc}/manifest/#{mn}"
          elsif @f.output_dir_structure.by_filetype?
            mp="#{@f.output_path.base.dir}/manifest"
            mt="#{mp}/#{mn}"
            mr=mn
            mu="#{url}/manifest/#{mn}"
          else
            mp="#{@f.output_path.base.dir}/#{@md.fnb}"
            mt="#{mp}/#{mn}"
            mr=mn
            mu="#{url}/#{mn}"
          end
          if FileTest.directory?(mp) \
          &&  FileTest.file?(mt)
            lng=ln[lc][:t]
            manifests[lc]={ ln: lng, fn: mn, rel: mr }
            @m << { mu: mu, l: lng, rel: mr }
          end
        end
        @m=@m.uniq
      end
      def languages(desc,file)
        @manifest[:html] << %{<tr><th class="left"><div id="horizontal_links"><ul id="horizontal">\n}
        published_manifests?.each do |l|
          SiSU_Translate::Source.new(@md,@language,l[:n]).language_list
          @manifest[:txt] << "#{l[:mu]} #{l[:l]}\n"
          @manifest[:html] << %{<li class="norm"><a href="#{l[:rel]}">#{l[:l]}</a>&nbsp;&nbsp;&nbsp;</li>}
        end
        @manifest[:html] << %{</ul></div></th></tr>\n}
      end
      def published_languages(desc)
        published_manifests?.each do |l|
          @manifest[:txt] << "#{l[:mu]} #{l[:l]}\n"
          @manifest[:html] << %{<tr><th class="left"><p class="bold"><a href="#{l[:mu]}">#{l[:l]}</a></p></th><td><p class="norm">#{l[:l]}</p><p class="tiny">#{the_url_decoration.xml_open}<a href="#{l[:mu]}">#{l[:mu]}</a>#{the_url_decoration.xml_close}</p></td><td class="right"><p class="right">&nbsp;</p></td></tr>\n}
        end
      end
      def metadata(desc,id,info)
        info=info.to_s.gsub(/(?:#{Mx[:br_line]}|\\)+/,'<br>')
        @manifest[:html] << %{<tr><th class="left"><p class="bold_left" id="#{id}">#{desc}:</p></th><td><p class="left">#{info}</p></td></tr>\n}
      end
      def links(url,lnk,target)
        static=if url =~/^\.\// then url.gsub(/^\.(\.)?/,@base_url)
        elsif url =~/^\.\.\//   then url.gsub(/^\.(\.)?/,@env.url.root)
        else                         url
        end
        @manifest[:html] << %{<tr><th class="right" width=5%><p class="norm">●</p></th><td class="left"><p class="norm"><a href="#{url}">#{lnk}</a></p><p class="tiny">&nbsp;&nbsp;#{the_url_decoration.xml_open}<a href="#{static}">#{static}</a>#{the_url_decoration.xml_close}</p></td></tr>\n}
      end
      def output_tests
        if FileTest.file?(@f.place_file.html_segtoc.dir)==true
          img=%{<img border="0" height="18" width="15" src="#{@image_path}/b_toc.png" alt="TOC linked" /> }
          pth=@f.output_path.html_seg.dir
          rel=@f.output_path.html_seg.rel_sm
          url=@f.output_path.html_seg.url
          desc,id,file='HTML, table of contents (for segmented text)','html',@f.base_filename.html_segtoc
          summarize_html_seg(desc,id,file,pth,rel,url,img)
        end
        if FileTest.file?(@f.place_file.html_scroll.dir)==true
          img=%{<img border="0" height="15" width="15" src="#{@image_path}/b_doc.png" alt="Full Text" /> }
          pth=@f.output_path.html_scroll.dir
          rel=@f.output_path.html_scroll.rel_sm
          url=@f.output_path.html_scroll.url
          desc,id,file='HTML, full length document','html_scroll',@f.base_filename.html_scroll
          summarize(desc,id,file,pth,rel,url,img)
        end
        if FileTest.file?(@f.place_file.html_book_index.dir)==true
          pth=@f.output_path.html_seg.dir
          rel=@f.output_path.html_seg.rel_sm
          url=@f.output_path.html_seg.url
          desc,id,file='HTML, (book type) index','html_book',@f.base_filename.html_book_index
          summarize(desc,id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.html_concordance.dir)==true
          pth=@f.output_path.html_seg.dir
          rel=@f.output_path.html_seg.rel_sm
          url=@f.output_path.html_seg.url
          desc,id,file='HTML, concordance file','concordance',@f.base_filename.html_concordance
          summarize(desc,id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.epub.dir)==true
          img=%{<img border="0" height="18" width="18" src="#{@image_path}/b_epub.png" alt="EPUB" /> }
          desc,id,file='EPUB (Electronic Publication, e-book standard)','epub',@f.base_filename.epub
          pth=@f.output_path.epub.dir
          rel=@f.output_path.epub.rel_sm
          url=@f.output_path.epub.url
          summarize(desc,id,file,pth,rel,url,img)
        end
        if FileTest.file?("#{@f.output_path.pdf.dir}/#{@f.base_filename.pdf_p_letter}")==true
          img=%{<img border="0" height="18" width="15" src="#{@image_path}/b_pdf.png" alt="PDF portrait" /> }
          pth=@f.output_path.pdf.dir
          rel=@f.output_path.pdf.rel_sm
          url=@f.output_path.pdf.url
          desc,id,file="PDF, U.S. letter size, portrait/vertical document (recommended for printing)",'pdf_letter',"#{@f.base_filename.pdf_p_letter}"
          summarize(desc,id,file,pth,rel,url,img)
        end
        if FileTest.file?("#{@f.output_path.pdf.dir}/#{@f.base_filename.pdf_l_letter}")==true
          img=%{<img border="0" height="15" width="18" src="#{@image_path}/b_pdf.png" alt="PDF landscape" /> }
          pth=@f.output_path.pdf.dir
          rel=@f.output_path.pdf.rel_sm
          url=@f.output_path.pdf.url
          desc,id,file="PDF, U.S. letter size, landscape/horizontal document (recommended for screen viewing)",'pdf_letter_landscape',"#{@f.base_filename.pdf_l_letter}"
          summarize(desc,id,file,pth,rel,url,img)
        end
        if FileTest.file?("#{@f.output_path.pdf.dir}/#{@f.base_filename.pdf_p_a4}")==true
          img=%{<img border="0" height="18" width="15" src="#{@image_path}/b_pdf.png" alt="PDF portrait" /> }
          pth=@f.output_path.pdf.dir
          rel=@f.output_path.pdf.rel_sm
          url=@f.output_path.pdf.url
          desc,id,file="PDF, A4 size, portrait/vertical document (recommended for printing)",'pdf_a4',"#{@f.base_filename.pdf_p_a4}"
          summarize(desc,id,file,pth,rel,url,img)
        end
        if FileTest.file?("#{@f.output_path.pdf.dir}/#{@f.base_filename.pdf_l_a4}")==true
          img=%{<img border="0" height="15" width="18" src="#{@image_path}/b_pdf.png" alt="PDF landscape" /> }
          pth=@f.output_path.pdf.dir
          rel=@f.output_path.pdf.rel_sm
          url=@f.output_path.pdf.url
          desc,id,file="PDF, A4 size, landscape/horizontal document (recommended for screen viewing)",'pdf_a4_landscape',"#{@f.base_filename.pdf_l_a4}"
          summarize(desc,id,file,pth,rel,url,img)
        end
        if FileTest.file?("#{@f.output_path.pdf.dir}/#{@f.base_filename.pdf_p_a5}")==true
          img=%{<img border="0" height="18" width="15" src="#{@image_path}/b_pdf.png" alt="PDF portrait" /> }
          pth=@f.output_path.pdf.dir
          rel=@f.output_path.pdf.rel_sm
          url=@f.output_path.pdf.url
          desc,id,file="PDF, A5 (book) size, portrait/vertical document (recommended for printing)",'pdf_a5',"#{@f.base_filename.pdf_p_a5}"
          summarize(desc,id,file,pth,rel,url,img)
        end
        if FileTest.file?("#{@f.output_path.pdf.dir}/#{@f.base_filename.pdf_l_a5}")==true
          img=%{<img border="0" height="15" width="18" src="#{@image_path}/b_pdf.png" alt="PDF landscape" /> }
          pth=@f.output_path.pdf.dir
          rel=@f.output_path.pdf.rel_sm
          url=@f.output_path.pdf.url
          desc,id,file="PDF, A5 (book) size, landscape/horizontal document (recommended for screen viewing)",'pdf_a5_landscape',"#{@f.base_filename.pdf_l_a5}"
          summarize(desc,id,file,pth,rel,url,img)
        end
        if FileTest.file?("#{@f.output_path.pdf.dir}/#{@f.base_filename.pdf_p_b5}")==true
          img=%{<img border="0" height="18" width="15" src="#{@image_path}/b_pdf.png" alt="PDF portrait" /> }
          pth=@f.output_path.pdf.dir
          rel=@f.output_path.pdf.rel_sm
          url=@f.output_path.pdf.url
          desc,id,file="PDF, B5 (book) size, portrait/vertical document (recommended for printing)",'pdf_b5',"#{@f.base_filename.pdf_p_b5}"
          summarize(desc,id,file,pth,rel,url,img)
        end
        if FileTest.file?("#{@f.output_path.pdf.dir}/#{@f.base_filename.pdf_l_b5}")==true
          img=%{<img border="0" height="15" width="18" src="#{@image_path}/b_pdf.png" alt="PDF landscape" /> }
          pth=@f.output_path.pdf.dir
          rel=@f.output_path.pdf.rel_sm
          url=@f.output_path.pdf.url
          desc,id,file="PDF, B5 (book) size, landscape/horizontal document (recommended for screen viewing)",'pdf_a5_landscape',"#{@f.base_filename.pdf_l_b5}"
          summarize(desc,id,file,pth,rel,url,img)
        end
        if FileTest.file?("#{@f.output_path.pdf.dir}/#{@f.base_filename.pdf_p_legal}")==true
          img=%{<img border="0" height="18" width="15" src="#{@image_path}/b_pdf.png" alt="PDF portrait" /> }
          pth=@f.output_path.pdf.dir
          rel=@f.output_path.pdf.rel_sm
          url=@f.output_path.pdf.url
          desc,id,file="PDF, U.S. legal size, portrait/vertical document (recommended for printing)",'pdf_legal',"#{@f.base_filename.pdf_p_legal}"
          summarize(desc,id,file,pth,rel,url,img)
        end
        if FileTest.file?("#{@f.output_path.pdf.dir}/#{@f.base_filename.pdf_l_legal}")==true
          img=%{<img border="0" height="15" width="18" src="#{@image_path}/b_pdf.png" alt="PDF landscape" /> }
          pth=@f.output_path.pdf.dir
          rel=@f.output_path.pdf.rel_sm
          url=@f.output_path.pdf.url
          desc,id,file="PDF, U.S. legal size, landscape/horizontal document (recommended for screen viewing)",'pdf_legal_landscape',"#{@f.base_filename.pdf_l_legal}"
          summarize(desc,id,file,pth,rel,url,img)
        end
        if FileTest.file?(@f.place_file.odt.dir)==true
          img=%{<img border="0" height="18" width="18" src="#{@image_path}/b_odf.png" alt="ODF/ODT" /> }
          pth=@f.output_path.odt.dir
          rel=@f.output_path.odt.rel_sm
          url=@f.output_path.odt.url
          desc,id,file='ODF:ODT (Open Document Format)','odt',@f.base_filename.odt
          summarize(desc,id,file,pth,rel,url,img)
        end
        if FileTest.file?(@f.place_file.xhtml.dir)==true
          pth=@f.output_path.xhtml.dir
          rel=@f.output_path.xhtml.rel_sm
          url=@f.output_path.xhtml.url
          desc,id,file='XHTML','xhtml',@f.base_filename.xhtml
          summarize(desc,id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.xml_sax.dir)==true
          pth=@f.output_path.xml_sax.dir
          rel=@f.output_path.xml_sax.rel_sm
          url=@f.output_path.xml_sax.url
          desc,id,file='XML SAX','xml_sax',@f.base_filename.xml_sax
          summarize(desc,id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.xml_dom.dir)==true
          pth=@f.output_path.xml_dom.dir
          rel=@f.output_path.xml_dom.rel_sm
          url=@f.output_path.xml_dom.url
          desc,id,file='XML DOM','xml_dom',@f.base_filename.xml_dom
          summarize(desc,id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.xml_docbook_article.dir)==true
          pth=@f.output_path.xml_docbook_article.dir
          rel=@f.output_path.xml_docbook_article.rel_sm
          url=@f.output_path.xml_docbook_article.url
          desc,id,file='XML Docbook Article','docbook_article',@f.base_filename.xml_docbook_article
          summarize(desc,id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.xml_docbook_book.dir)==true
          pth=@f.output_path.xml_docbook_book.dir
          rel=@f.output_path.xml_docbook_book.rel_sm
          url=@f.output_path.xml_docbook_book.url
          desc,id,file='XML Docbook Book','docbook',@f.base_filename.xml_docbook_book
          summarize(desc,id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.xml_fictionbook.dir)==true
          pth=@f.output_path.xml_fictionbook.dir
          rel=@f.output_path.xml_fictionbook.rel_sm
          url=@f.output_path.xml_fictionbook.url
          desc,id,file='XML Fictionbook','fictionbook',@f.base_filename.xml_fictionbook
          summarize(desc,id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.xml_scaffold_structure_sisu.dir)==true
          pth=@f.output_path.xml_scaffold_structure_sisu.dir
          rel=@f.output_path.xml_scaffold_structure_sisu.rel_sm
          url=@f.output_path.xml_scaffold_structure_sisu.url
          desc,id,file='XML Scaffold sisu structure','xml_scaffold',@f.base_filename.xml_scaffold_structure_sisu
          summarize(desc,id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.xml_scaffold_structure_collapse.dir)==true
          pth=@f.output_path.xml_scaffold_structure_collapse.dir
          rel=@f.output_path.xml_scaffold_structure_collapse.rel_sm
          url=@f.output_path.xml_scaffold_structure_collapse.url
          desc,id,file='XML Scaffold collapsed structure','xml_collapsed',@f.base_filename.xml_scaffold_structure_collapse
          summarize(desc,id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.info.dir)==true
          pth=@f.output_path.texinfo.dir
          rel=@f.output_path.texinfo.rel_sm
          url=@f.output_path.texinfo.url
          desc,id,file='Info file','info',@f.base_filename.info
          summarize(desc,id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.manpage.dir)==true
          pth=@f.output_path.manpage.dir
          rel=@f.output_path.manpage.rel_sm
          url=@f.output_path.manpage.url
          desc,id,file='Manpage','manpage',@f.base_filename.manpage
          summarize(desc,id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.sqlite_discrete.dir)==true
          desc,id,file='SQLite3 file','sqlite',@f.base_filename.sqlite_discrete
          pth=@f.output_path.sqlite_discrete.dir
          rel=@f.output_path.sqlite_discrete.rel_sm
          url=@f.output_path.sqlite_discrete.url
          summarize(desc,id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.txt.dir)==true
          desc,id='Plaintext (UTF-8)','text'
          pth=@f.output_path.txt.dir
          rel=@f.output_path.txt.rel_sm
          url=@f.output_path.txt.url
          file=@f.base_filename.txt
          summarize(desc,id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.textile.dir)==true
          desc,id='Textile text (UTF-8)','textile'
          pth=@f.output_path.textile.dir
          rel=@f.output_path.textile.rel_sm
          url=@f.output_path.textile.url
          file=@f.base_filename.textile
          summarize(desc,id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.asciidoc.dir)==true
          desc,id='AsciiDoc text (UTF-8)','asciidoc'
          pth=@f.output_path.asciidoc.dir
          rel=@f.output_path.asciidoc.rel_sm
          url=@f.output_path.asciidoc.url
          file=@f.base_filename.asciidoc
          summarize(desc,id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.markdown.dir)==true
          desc,id='Markdown text (UTF-8)','markdown'
          pth=@f.output_path.markdown.dir
          rel=@f.output_path.markdown.rel_sm
          url=@f.output_path.markdown.url
          file=@f.base_filename.markdown
          summarize(desc,id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.rst.dir)==true
          desc,id='rST text (UTF-8)','rst'
          pth=@f.output_path.rst.dir
          rel=@f.output_path.rst.rel_sm
          url=@f.output_path.rst.url
          file=@f.base_filename.rst
          summarize(desc,id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.orgmode.dir)==true
          desc,id='OrgMode structure text (UTF-8)','org'
          pth=@f.output_path.orgmode.dir
          rel=@f.output_path.orgmode.rel_sm
          url=@f.output_path.orgmode.url
          file=@f.base_filename.orgmode
          summarize(desc,id,file,pth,rel,url)
        end
        if FileTest.file?("#{@base_path}/#{@md.fns}.tex")==true
          desc,id,file='LaTeX (portrait)','latex',"#{@md.fns}.tex"
          pth,rel,url='','',''
          summarize(desc,id,file,pth,rel,url)
        end
        if FileTest.file?("#{@base_path}/#{@md.fns}.tex")==true
          desc,id,file='LaTeX (landscape)','latex_landscape',"#{@md.fns}.landscape.tex"
          pth,rel,url='','',''
          summarize(desc,id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.hash_digest.dir)==true
          pth=@f.output_path.hash_digest.dir
          rel=@f.output_path.hash_digest.rel_sm
          url=@f.output_path.hash_digest.url
          desc,id,file="Digest/DCC - Document Content Certificate (#{@dg})",'digests',@f.base_filename.hash_digest
          summarize(desc,id,file,pth,rel,url)
        end
      end
      def published_versions
        desc,file='Markup (SiSU source)','source',@md.fns
        languages(desc,file)
      end
      def language_versions
        if FileTest.file?(@f.place_file.manifest.dir)==true
          desc='Markup (SiSU source)'
          published_languages(desc)
        end
      end
      def qrc_image
        fn=(@f.output_dir_structure.by_filename?) \
        ? 'sisu_manifest'
        : @md.fnb
        pth=((@o_str.dump_or_redirect?) \
        || (@f.output_dir_structure.by_filename?)) \
        ? '.'
        : 'qrcode'
        img_md="#{pth}/#{fn}#{@fn_lng}.md.png"
        img_title="#{pth}/#{fn}#{@fn_lng}.title.png"
        if FileTest.file?(@f.place_file.qrcode_md.dir)==true
          @manifest[:html] <<<<WOK
<tr><td class="left">
  <p class="tiny">QR code SiSU document metadata:</p>
  <p class="tiny">
    <img border="0" src="#{img_md}" alt="qrcode metadata" />
  </p>
</td></tr>
WOK
        end
        if FileTest.file?(@f.place_file.qrcode_title.dir)==true
          @manifest[:html] <<<<WOK
<tr><td class="left">
  <p class="tiny">QR code document title info:</p>
  <p class="tiny">
    <img border="0" src="#{img_title}" alt="qrcode title" />
  </p>
</td></tr>
WOK
        end
      end
      def source_tests
        if @md.fno =~/\.ssm$/                                                  #% decide whether to extract and include requested/required documents
          if FileTest.file?(@f.place_file.src.dir)==true
            pth=@f.output_path.src.dir
            rel=@f.output_path.src.rel_sm
            url=@f.output_path.src.url
            desc,id,file='Markup Composite File (SiSU source)','source',@f.base_filename.src
            summarize_sources(desc,id,file,pth,rel,url)
          end
        else
          if FileTest.file?(@f.place_file.src.dir)==true
            pth=@f.output_path.src.dir
            rel=@f.output_path.src.rel_sm
            url=@f.output_path.src.url
            desc,id,file='Markup (SiSU source)','composite',@f.base_filename.src
            summarize_sources(desc,id,file,pth,rel,url)
          end
        end
        if FileTest.file?(@f.place_file.sisupod.dir)==true
          pth=@f.output_path.sisupod.dir
          rel=@f.output_path.sisupod.rel_sm
          url=@f.output_path.sisupod.url
          desc,id,file='SiSUdoc pod (tar.xz)','sisupod',@f.base_filename.sisupod
          summarize_sources(desc,id,file,pth,rel,url)
        end
        if FileTest.file?(@f.place_file.pot.dir)==true
          pth=@f.output_path.pot.dir
          rel=@f.output_path.pot.rel_sm
          url=@f.output_path.pot.url
          desc,id,file='SiSU pot','pot',@f.base_filename.pot
          summarize_sources(desc,id,file,pth,rel,url)
        end
      end
      def metadata_tests
        if defined? @md.title                                                   #%
          if defined? @md.title.full \
          and @md.title.full=~/\S+/
            desc,id,info=@translate.full_title,'title',@md.title.full
            metadata(desc,id,info)
          end
        end
        if defined? @md.creator                                                 #%
          if defined? @md.creator.author \
          and @md.creator.author=~/\S+/
            desc,id,info=@translate.author,'author',@md.creator.author
            metadata(desc,id,info)
          end
          if defined? @md.creator.editor \
          and @md.creator.editor=~/\S+/
            desc,id,info=@translate.editor,'editor',@md.creator.editor
            metadata(desc,id,info)
          end
          if defined? @md.creator.contributor \
          and @md.creator.contributor=~/\S+/
            desc,id,info=@translate.contributor,'contributor',@md.creator.contributor
            metadata(desc,id,info)
          end
          if defined? @md.creator.translator \
          and @md.creator.translator=~/\S+/
            desc,id,info=@translate.translator,'creator',@md.creator.translator
            metadata(desc,id,info)
          end
          if defined? @md.creator.illustrator \
          and @md.creator.illustrator=~/\S+/
            desc,id,info=@translate.illustrator,'illustrator',@md.creator.illustrator
            metadata(desc,id,info)
          end
          if defined? @md.creator.prepared_by \
          and @md.creator.prepared_by=~/\S+/
            desc,id,info=@translate.prepared_by,'prepared_by',@md.creator.prepared_by
            metadata(desc,id,info)
          end
          if defined? @md.creator.digitized_by \
          and @md.creator.digitized_by=~/\S+/
            desc,id,info=@translate.digitized_by,'designed_by',@md.creator.digitized_by
            metadata(desc,id,info)
          end
        end
        if defined? @md.rights
          if defined? @md.rights.all \
          and @md.rights.all=~/\S+/ #dc
            desc,id,info=@translate.rights,'rights',@md.rights.all
            metadata(desc,id,info)
          end
        end
        if defined? @md.date                                                    #%
          if defined? @md.date.published \
          and @md.date.published=~/\S+/ #dc
            desc,id,info=@translate.date,'date',@md.date.published
            metadata(desc,id,info)
          end
          if defined? @md.date.created \
          and @md.date.created=~/\S+/ #dc
            desc,id,info=@translate.date_created,'date_created',@md.date.created
            metadata(desc,id,info)
          end
          if defined? @md.date.issued \
          and @md.date.issued=~/\S+/ #dc
            desc,id,info=@translate.date_issued,'date_issued',@md.date.issued
            metadata(desc,id,info)
          end
          if defined? @md.date.available \
          and @md.date.available=~/\S+/ #dc
            desc,id,info=@translate.date_available,'date_available',@md.date.available
            metadata(desc,id,info)
          end
          if defined? @md.date.modified \
          and @md.date.modified=~/\S+/ #dc
            desc,id,info=@translate.date_modified,'date_modified',@md.date.modified
            metadata(desc,id,info)
          end
          if defined? @md.date.valid \
          and @md.date.valid=~/\S+/ #dc
            desc,id,info=@translate.date_valid,'date_valid',@md.date.valid
            metadata(desc,id,info)
          end
        end
        if defined? @md.publisher \
        and @md.publisher=~/\S+/ #dc
          desc,id,info=@translate.publisher,'publisher',@md.publisher
          metadata(desc,id,info)
        end
        if defined? @md.notes                                                   #%
          if defined? @md.notes.description \
          and @md.notes.description=~/\S+/
            desc,id,info=@translate.description,'description',@md.notes.description
            metadata(desc,id,info)
          end
          if defined? @md.notes.abstract \
          and @md.notes.abstract=~/\S+/
            desc,id,info=@translate.abstract,'abstract',@md.notes.abstract
            metadata(desc,id,info)
          end
          if defined? @md.notes.comment \
          and @md.notes.comment=~/\S+/
            desc,id,info=@translate.comments,'comment',@md.notes.comment
            metadata(desc,id,info)
          end
          if defined? @md.notes.prefix_a \
          and @md.notes.prefix_a=~/\S+/
            desc,id,info=@translate.prefix_a,'prefix',@md.notes.prefix_a
            metadata(desc,id,info)
          end
          if defined? @md.notes.prefix_b \
          and @md.notes.prefix_b=~/\S+/
            desc,id,info=@translate.prefix_b,'prefix_b',@md.notes.prefix_b
            metadata(desc,id,info)
          end
        end
        if defined? @md.title                                                   #%
          if defined? @md.title.language \
          and @md.title.language=~/\S+/
            desc,id,info=@translate.language,'language',@md.title.language
            metadata(desc,id,info)
          end
          if defined? @md.original.language \
          and @md.original.language=~/\S+/
            desc,id,info=@translate.language_original,'language_original',@md.original.language
            metadata(desc,id,info)
          end
        end
        if defined? @md.classify                                                #%
          if defined? @md.topic_register_array \
          and @md.topic_register_array.length > 0
            @manifest[:html] << %{<tr><th class="left"><p class="bold_left" id="topics">#{@translate.topic_register}:</p></th><td>\n}
            @md.topic_register_array.each do |t|
              t.each_with_index do |st,i|
                if st.is_a?(Array)
                  st.each do |v|
                    if v.is_a?(Array)
                      v.each do |w|
                        @manifest[:html] << %{<p class="it#{i}">#{w}</p>\n}
                      end
                    else
                      @manifest[:html] << %{<p class="it#{i}">#{v}</p>\n}
                    end
                  end
                else @manifest[:html] << %{<p class="it#{i}">#{st}</p>\n}
                end
              end
            end
            @manifest[:html] << %{</td></tr>\n}
          end
          if defined? @md.classify.subject \
          and @md.classify.subject=~/\S+/
            desc,id,info=@translate.subject,'subject',@md.classify.subject
            metadata(desc,id,info)
          end
          if defined? @md.classify.keywords \
          and @md.classify.keywords=~/\S+/
            desc,id,info=@translate.keywords,'keywords',@md.classify.keywords
            metadata(desc,id,info)
          end
          if defined? @md.classify.loc \
          and @md.classify.loc=~/\S+/
            desc,id,info=@translate.cls_loc,'loc',@md.classify.loc
            metadata(desc,id,info)
          end
          if defined? @md.classify.dewey \
          and @md.classify.dewey=~/\S+/
            desc,id,info=@translate.cls_dewey,'dewey',@md.classify.dewey
            metadata(desc,id,info)
          end
          if defined? @md.notes.coverage \
          and @md.notes.coverage=~/\S+/
            desc,id,info=@translate.coverage,'coverage',@md.notes.coverage
            metadata(desc,id,info)
          end
          if defined? @md.notes.relation \
          and @md.notes.relation=~/\S+/
            desc,id,info=@translate.relation,'relation',@md.notes.relation
            metadata(desc,id,info)
          end
          if defined? @md.notes.type \
          and @md.notes.type=~/\S+/ #dc
            desc,id,info=@translate.type,'type',@md.notes.type
            metadata(desc,id,info)
          end
          if defined? @md.notes.format \
          and @md.notes.format=~/\S+/
            desc,id,info=@transate.format,'format',@md.notes.format
            metadata(desc,id,info)
          end
        end
        if defined? @md.identifier                                              #%
          if defined? @md.identifier.oclc \
          and @md.identifier.oclc=~/\S+/
            desc,id,info=@translate.cls_oclc,'',@md.identifier.oclc
            @manifest[:html] << %{<tr><th class="left"><p class="bold_left">#{desc}:</p></th><td>\n}
            @manifest[:html] << %{<p class="left"><a href="http://worldcat.org/oclc/#{info}">#{info}</a></p>\n}
            @manifest[:html] << %{</td></tr>\n}
          end
          if defined? @md.identifier.pg \
          and @md.identifier.pg=~/\S+/
            desc,id,info=@translate.cls_gutenberg,'ocalc',@md.identifier.pg
            metadata(desc,id,info)
          end
          if defined? @md.identifier.isbn \
          and @md.identifier.isbn=~/\S+/
            desc,id,info=@translate.cls_isbn,'isbn',@md.identifier.isbn
            metadata(desc,id,info)
          end
        end
        if defined? @md.original.source \
        and @md.original.source=~/\S+/
          desc,id,info=@translate.source,'source_original',@md.original.source
          metadata(desc,id,info)
        end
        if @md.fns
          desc,id,info=@translate.sourcefile,'source_filename',@md.fns
          metadata(desc,id,info)
        end
        if @md.en[:mismatch] > 0
          desc,id,info='WARNING document error in endnote markup, number mismatch','',"endnotes: #{@md.en[:note]} != endnote reference marks: #{@md.en[:mark]} (difference = #{@md.en[:mismatch]})"
          metadata(desc,id,info)
        end
        if @md.wc_words
          desc,id,info=@translate.word_count,'wordcount',@md.wc_words
          metadata(desc,id,info)
        end
        if @md.dgst
          desc,id,info="#{@translate.sourcefile_digest} (#{@dg})",'digests',@md.dgst[1]
          metadata(desc,id,info)
        end
        if @md.sc_number
          desc,id,info=@translate.sc_number,'sc_number',@md.sc_number
          metadata(desc,id,info)
        end
        if @md.sc_date
          desc,id,info=@translate.sc_date,'sc_date',"#{@md.sc_date} at #{@md.sc_time}"
          metadata(desc,id,info)
        end
        if @md.generated
          desc,id,info=@translate.last_generated,'generated',@md.generated
          metadata(desc,id,info)
        end
        if @md.project_details
          desc,id,info=@translate.sisu_version,'project',"#{@md.project_details.project} #{@md.project_details.version} #{@md.project_details.date_stamp} (#{@md.project_details.date})#{@md.project_details.install_method}"
          metadata(desc,id,info)
        end
        if @md.ruby_version
          desc,id,info=@translate.ruby_version,'ruby',@md.ruby_version
          metadata(desc,id,info)
        end
      end
      def links_tests
        if defined? @md.lnk \
        and @md.lnk
          @md.lnk.each do |l|
            if defined? l[:say]
              target=(l[:url] !~/^\.(\.)?\//) \
              ? 'external'
              : '_top'
              url,lnk=l[:url],l[:say]
              unless url.nil? \
              or url.empty?
                links(url,lnk,target)
              end
            end
          end
        end
      end
      def check_output(data)
        begin
          make=SiSU_Env::ProcessingSettings.new(@md)
          minitoc=SiSU_HTML_MiniToc::TocMini.new(@md,data).songsheet.join("\n")
          format_head_toc=SiSU_HTML_Format::HeadToc.new(@md)
          @manifest[:html] <<<<WOK
<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<title>
SiSU manifest: #{@md.title.full}
</title>
<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
<meta name="sourcefile" content="#{@md.fns}" />
<link rel="generator" href="http://www.jus.uio.no/sisu" />
<link rel="shortcut icon" href="#{@f.path_rel_links.html_scroll_css}_sisu/image_sys/rb7.ico" />
#{@stylesheet.css_head}
</head>
<body lang="#{@md.opt.lng}">
#{format_head_toc.seg_head_navigation_band(:manifest)}
WOK
          if make.build.manifest_minitoc?
            if @o_str.dump_or_redirect?
            elsif @f.output_dir_structure.by_language_code? \
            or @f.output_dir_structure.by_filetype?
              minitoc=minitoc.gsub(/<a href="(\S+?)"/m,%{<a href="../html/#{@md.fnb}/\\1"}).
                gsub(/<a href="\.\.\/html\/#{@md.fnb}\/(?:sisu_manifest\.html|#{@f.base_filename.manifest})"/m,
              %{<a href="#{@f.base_filename.manifest}"})
            end
            @manifest[:html] <<<<WOK
<div class="toc">
#{minitoc.to_s}
</div>
<div class="content">
WOK
          else
            @manifest[:html] <<<<WOK
<div>
WOK
          end
          if @o_str.dump_or_redirect?
          elsif @f.output_dir_structure.by_language_code? \
          or @f.output_dir_structure.by_filetype?
            pth_local=@f.output_path.manifest.dir
            pth_rel='.'
          else
            pth_local=@f.output_path.base.dir
            pth_rel='..'
          end
          pth_rel_home=if @env.output_dir_structure.by? == :language
            '../..'
          elsif @env.output_dir_structure.by? == :filetype
            '..'
          elsif @env.output_dir_structure.by? == :filename
            '..'
          else '..'
          end
          output_organised_by="(output organised by #{@env.output_dir_structure.by?})"
          harvest=(FileTest.file?("#{pth_local}/authors#{@fn_lng}.html") \
          && FileTest.file?("#{pth_local}/topics#{@fn_lng}.html")) \
          ? %{<p class="small"><a href="#{pth_rel_home}/index.html">.:</a> other document manifests: [<a href="#{pth_rel}/authors#{@fn_lng}.html">authors</a>] [<a href="#{pth_rel}/topics#{@fn_lng}.html">topics</a>] #{output_organised_by}</p>}
          : %{<p class="small"><a href="#{pth_rel_home}">#{output_organised_by}</a></p>}
          manifest_title=%{<p class="bold">#{@translate.manifest_description}</p>#{harvest}}
          @manifest[:html] <<<<WOK
<div id="horizontal_links">
#{manifest_title}
</div>
<h1 class="small">#{@md.title.full}</h1>
<p class="bold">#{@md.author}</p>
<div id="horizontal_links"><p class="bold">
<p class="small">
&nbsp;&nbsp;<a href="#output">Document, Available Filetypes</a>
</p>
<p class="small">
&nbsp;&nbsp;<a href="#metadata">Document Metadata</a>
</p>
<p class="tiny">
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="#links">metadata suggested links (if any)</a>
</p>
</div>
<table summary="normal text css" width="100%" border="0" cellpadding="2" align="center">
WOK
          published_versions
          @manifest[:html] << '</table>'
          @manifest[:html] <<<<WOK
<h2 class="small"><a name="output">#{@translate.manifest_description_output}</a></h2>
<table summary="available output/filetypes" width="100%" border="0" cellpadding="2" align="center">
<tr> <th class="left"><p class="bold">#{@translate.filetype_description}</p></th><th class="left"><p class="bold">#{@translate.filename}</p></th><th class="right"><p class="right"><b>#{@translate.file_size}</b></p><p class="tiny_right">(kB)</p></th></tr>

WOK
          output_tests
          @manifest[:html] << '</table>'
          @manifest[:html] <<<<WOK
<table summary="normal text css" width="100%" border="0" cellpadding="2" align="center">
WOK
          source_tests
          @manifest[:html] << '</table>'
          @manifest[:html] <<<<WOK
<h2 class="small"><a name="metadata">#{@translate.manifest_description_metadata}</a></h2>
<table summary="document metadata" width="100%" border="0" cellpadding="2" align="center">
<tr> <th class="left"><p class="bold" id="metadata">#{@translate.metadata}</p></th><th class="left"><p class="bold">#{@translate.description}</p></th></tr>
WOK
          metadata_tests
          @manifest[:html] <<<<WOK
</table>
WOK
          @manifest[:html] <<<<WOK
<p class="bold"><a name="links">#{@translate.suggested_links}:</a></p>
<table summary="suggested links" width="100%" border="0" cellpadding="2" align="center">
WOK
          links_tests
          @manifest[:html] <<<<WOK
</table>
WOK
          @manifest[:html] <<<<WOK
<h2 class="small"><a name="languages">#{@translate.language_version_list}</a></h2>
<table summary="language versions" width="100%" border="0" cellpadding="2" align="center">
<tr> <th class="left"><p class="bold">#{@translate.filename}</p></th><th class="left"><p class="bold">#{@translate.description}</p></th><th class="right"><p class="right">&nbsp;</p></th></tr>

WOK
          language_versions
          qrc_image
          @manifest[:html] <<<<WOK
</table>
</div>
<div>
<br>
#{SiSU_Proj_HTML::Bits.new.credits_sisu_manifest}
</div>
</body>
</html>
WOK
          output
        rescue
          SiSU_Errors::Rescued.new($!,$@,@md.opt.selections.str,@md.fns).location do
            __LINE__.to_s + ':' + __FILE__
          end
        ensure
        end
      end
    end
  end
end
__END__
