//===----------------------------------------------------------------------===//
//
// This source file is part of the SwiftNIO open source project
//
// Copyright (c) 2017-2018 Apple Inc. and the SwiftNIO project authors
// Licensed under Apache License v2.0
//
// See LICENSE.txt for license information
// See CONTRIBUTORS.txt for the list of SwiftNIO project authors
//
// SPDX-License-Identifier: Apache-2.0
//
//===----------------------------------------------------------------------===//
//
// CircularBufferTests+XCTest.swift
//
import XCTest

///
/// NOTE: This file was generated by generate_linux_tests.rb
///
/// Do NOT edit this file directly as it will be regenerated automatically when needed.
///

extension CircularBufferTests {

   @available(*, deprecated, message: "not actually deprecated. Just deprecated to allow deprecated tests (which test deprecated functionality) without warnings")
   static var allTests : [(String, (CircularBufferTests) -> () throws -> Void)] {
      return [
                ("testTrivial", testTrivial),
                ("testAddRemoveInALoop", testAddRemoveInALoop),
                ("testAddAllRemoveAll", testAddAllRemoveAll),
                ("testRemoveAt", testRemoveAt),
                ("testRemoveAtLastPosition", testRemoveAtLastPosition),
                ("testRemoveAtTailIdx0", testRemoveAtTailIdx0),
                ("testRemoveAtFirstPosition", testRemoveAtFirstPosition),
                ("testHarderExpansion", testHarderExpansion),
                ("testCollection", testCollection),
                ("testReplaceSubrange5ElementsWith1", testReplaceSubrange5ElementsWith1),
                ("testReplaceSubrangeAllElementsWithFewerElements", testReplaceSubrangeAllElementsWithFewerElements),
                ("testReplaceSubrangeEmptyRange", testReplaceSubrangeEmptyRange),
                ("testReplaceSubrangeWithSubrangeLargerThanTargetRange", testReplaceSubrangeWithSubrangeLargerThanTargetRange),
                ("testReplaceSubrangeSameSize", testReplaceSubrangeSameSize),
                ("testReplaceSubrangeReplaceBufferWithEmptyArray", testReplaceSubrangeReplaceBufferWithEmptyArray),
                ("testRangeSubscriptExpanding", testRangeSubscriptExpanding),
                ("testWeCanDistinguishBetweenEmptyAndFull", testWeCanDistinguishBetweenEmptyAndFull),
                ("testExpandZeroBasedRingWorks", testExpandZeroBasedRingWorks),
                ("testExpandNonZeroBasedRingWorks", testExpandNonZeroBasedRingWorks),
                ("testEmptyingExpandedRingWorks", testEmptyingExpandedRingWorks),
                ("testChangeElements", testChangeElements),
                ("testSliceTheRing", testSliceTheRing),
                ("testCount", testCount),
                ("testFirst", testFirst),
                ("testLast", testLast),
                ("testRemoveLast", testRemoveLast),
                ("testRemoveLastCountElements", testRemoveLastCountElements),
                ("testRemoveLastElements", testRemoveLastElements),
                ("testOperateOnBothSides", testOperateOnBothSides),
                ("testPrependExpandBuffer", testPrependExpandBuffer),
                ("testRemoveAllKeepingCapacity", testRemoveAllKeepingCapacity),
                ("testRemoveAllNotKeepingCapacity", testRemoveAllNotKeepingCapacity),
                ("testBufferManaged", testBufferManaged),
                ("testDoesNotExpandCapacityNeedlesslyWhenInserting", testDoesNotExpandCapacityNeedlesslyWhenInserting),
                ("testDoesNotExpandCapacityNeedlesslyWhenAppending", testDoesNotExpandCapacityNeedlesslyWhenAppending),
                ("testExpandRemoveAllKeepingAndNotKeepingCapacityAndExpandAgain", testExpandRemoveAllKeepingAndNotKeepingCapacityAndExpandAgain),
                ("testRemoveAllNilsOutTheContents", testRemoveAllNilsOutTheContents),
                ("testIntIndexing", testIntIndexing),
                ("testIndexDistance", testIndexDistance),
                ("testIndexAdvancing", testIndexAdvancing),
                ("testPopFirst", testPopFirst),
                ("testSlicing", testSlicing),
                ("testRemoveInMiddle", testRemoveInMiddle),
                ("testLotsOfPrepending", testLotsOfPrepending),
                ("testLotsOfInsertAtStart", testLotsOfInsertAtStart),
                ("testLotsOfInsertAtEnd", testLotsOfInsertAtEnd),
                ("testPopLast", testPopLast),
                ("testModify", testModify),
                ("testEquality", testEquality),
                ("testHash", testHash),
                ("testArrayLiteralInit", testArrayLiteralInit),
                ("testFirstWorks", testFirstWorks),
                ("testReserveCapacityActuallyDoesSomething", testReserveCapacityActuallyDoesSomething),
           ]
   }
}

