/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.awt;

import edu.hws.jcm.awt.Computable;
import edu.hws.jcm.awt.Controller;
import edu.hws.jcm.awt.InputObject;
import edu.hws.jcm.awt.Tie;
import edu.hws.jcm.awt.Tieable;
import edu.hws.jcm.data.Constant;
import edu.hws.jcm.data.Value;
import edu.hws.jcm.data.Variable;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class Animator
extends Panel
implements Value,
Tieable,
InputObject,
ActionListener,
ItemListener,
Runnable {
    public static final int START_STOP_BUTTON = 1;
    public static final int START_BUTTON = 2;
    public static final int PAUSE_BUTTON = 4;
    public static final int STOP_BUTTON = 8;
    public static final int NEXT_BUTTON = 16;
    public static final int PREV_BUTTON = 32;
    public static final int SPEED_CHOICE = 64;
    public static final int LOOP_CHOICE = 128;
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL = 0;
    public static final int ONCE = 0;
    public static final int LOOP = 1;
    public static final int BACK_AND_FORTH = 2;
    private Button startStopButton;
    private Button startButton;
    private Button stopButton;
    private Button pauseButton;
    private Button nextButton;
    private Button prevButton;
    private Choice speedChoice;
    private Choice loopChoice;
    private int orientation;
    private String startButtonName = "Start";
    private String stopButtonName = "Stop";
    private volatile int loopStyle;
    private boolean runningBackwards;
    private volatile int millisPerFrame = 100;
    private volatile int frame;
    private int maxFrame;
    private double value;
    private volatile long serialNumber = 1L;
    private Computable onChange;
    private Value min;
    private Value max;
    private Value intervals;
    private boolean needsValueCheck = true;
    private double min_val;
    private double max_val;
    private int intervals_val;
    private static int START = 0;
    private static int PAUSE = 1;
    private static int NEXT = 2;
    private static int PREV = 3;
    private static int STOP = 4;
    private static int RUN = 5;
    private Thread runner;
    private volatile int status = STOP;
    private boolean undefinedWhenNotRunning;

    public Animator() {
        this(1, 0);
    }

    public Animator(int n) {
        this(n, 0, null, null, null);
    }

    public Animator(int n, int n2) {
        this(n, n2, null, null, null);
    }

    public Animator(int n, int n2, Value value, Value value2, Value value3) {
        this.min = value;
        this.max = value2;
        this.intervals = value3;
        this.orientation = n2;
        if (n2 == 1) {
            this.setLayout(new GridLayout(0, 1));
        } else {
            this.setLayout(new GridLayout(1, 0));
        }
        for (int i = 1; i <= 128; i <<= 1) {
            if ((i & n) == 0) continue;
            this.addControl(i);
        }
    }

    public Component getControl(int n) {
        switch (n) {
            case 1: {
                if (this.startStopButton == null) {
                    this.startStopButton = new Button(this.startButtonName);
                    this.startStopButton.setBackground(Color.lightGray);
                    this.startStopButton.addActionListener(this);
                }
                return this.startStopButton;
            }
            case 2: {
                if (this.startButton == null) {
                    this.startButton = new Button(this.startButtonName);
                    this.startButton.setBackground(Color.lightGray);
                    this.startButton.addActionListener(this);
                }
                return this.startButton;
            }
            case 8: {
                if (this.stopButton == null) {
                    this.stopButton = new Button(this.stopButtonName);
                    this.stopButton.setBackground(Color.lightGray);
                    this.stopButton.addActionListener(this);
                    this.stopButton.setEnabled(false);
                }
                return this.stopButton;
            }
            case 4: {
                if (this.pauseButton == null) {
                    this.pauseButton = new Button("Pause");
                    this.pauseButton.setBackground(Color.lightGray);
                    this.pauseButton.addActionListener(this);
                    this.pauseButton.setEnabled(false);
                }
                return this.pauseButton;
            }
            case 16: {
                if (this.nextButton == null) {
                    this.nextButton = new Button("Next");
                    this.nextButton.setBackground(Color.lightGray);
                    this.nextButton.addActionListener(this);
                }
                return this.nextButton;
            }
            case 32: {
                if (this.prevButton == null) {
                    this.prevButton = new Button("Prev");
                    this.prevButton.setBackground(Color.lightGray);
                    this.prevButton.addActionListener(this);
                }
                return this.prevButton;
            }
            case 64: {
                if (this.speedChoice == null) {
                    this.speedChoice = new Choice();
                    this.speedChoice.add("Fastest");
                    this.speedChoice.add("Fast");
                    this.speedChoice.add("Moderate");
                    this.speedChoice.add("Slow");
                    this.speedChoice.add("Slower");
                    this.speedChoice.select(2);
                    this.speedChoice.addItemListener(this);
                }
                return this.speedChoice;
            }
            case 128: {
                if (this.loopChoice == null) {
                    this.loopChoice = new Choice();
                    this.loopChoice.add("Play Once");
                    this.loopChoice.add("Loop");
                    this.loopChoice.add("Back and Forth");
                    this.loopChoice.addItemListener(this);
                }
                return this.loopChoice;
            }
        }
        return null;
    }

    public Component addControl(int n) {
        Component component = this.getControl(n);
        if (component == null) {
            return null;
        }
        this.add(component);
        return component;
    }

    public void setStartButtonName(String string) {
        if (string != null) {
            this.startButtonName = string;
            if (this.startStopButton != null) {
                this.startStopButton.setLabel(string);
            }
            if (this.startButton != null) {
                this.startButton.setLabel(string);
            }
        }
    }

    public void setStopButtonName(String string) {
        if (string != null) {
            this.stopButtonName = string;
            if (this.stopButton != null) {
                this.stopButton.setLabel(string);
            }
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        if (n != this.orientation && (n == 0 || n == 1)) {
            this.orientation = n;
            if (n == 1) {
                this.setLayout(new GridLayout(0, 1));
            } else {
                this.setLayout(new GridLayout(1, 0));
            }
            this.validate();
        }
    }

    public Value getMax() {
        return this.max;
    }

    public void setMax(Value value) {
        this.max = value;
        this.needsValueCheck = true;
    }

    public void setMax(double d) {
        this.setMax(new Constant(d));
    }

    public Value getMin() {
        return this.min;
    }

    public void setMin(Value value) {
        this.min = value;
        this.needsValueCheck = true;
    }

    public void setMin(double d) {
        this.setMin(new Constant(d));
    }

    public Value getIntervals() {
        return this.intervals;
    }

    public void setIntervals(Value value) {
        this.intervals = value;
        this.needsValueCheck = true;
    }

    public void setIntervals(int n) {
        this.setIntervals(new Constant(n));
    }

    public int getMillisPerFrame() {
        return this.millisPerFrame;
    }

    public void setMillisPerFrame(int n) {
        this.millisPerFrame = n;
    }

    public int getLoopStyle() {
        return this.loopStyle;
    }

    public void setLoopStyle(int n) {
        if (n >= 0 && n <= 2 && n != this.loopStyle) {
            this.loopStyle = n;
            if (this.loopChoice != null) {
                this.loopChoice.select(n);
            }
            this.runningBackwards = false;
        }
    }

    public synchronized void setVal(double d) {
        if (this.needsValueCheck) {
            this.checkValue();
        }
        this.value = d;
        ++this.serialNumber;
        this.needsValueCheck = false;
        if (!Double.isNaN(d)) {
            if (this.min == null || this.max == null) {
                this.frame = (int)Math.round(d);
            } else if (!Double.isNaN(this.min_val) && !Double.isNaN(this.max_val) && this.min_val != this.max_val) {
                this.frame = (int)Math.round((d - this.min_val) / (this.max_val - this.min_val) * (double)this.maxFrame);
            }
            if (this.frame < 0) {
                this.frame = 0;
            } else if (this.maxFrame > 0 && this.frame > this.maxFrame) {
                this.frame = this.maxFrame;
            }
        }
    }

    @Override
    public double getVal() {
        if (this.needsValueCheck) {
            this.checkValue();
        }
        return this.value;
    }

    public Variable getValueAsVariable() {
        return this.getValueAsVariable("k");
    }

    public Variable getValueAsVariable(String string) {
        return new Variable(string){

            @Override
            public void setVal(double d) {
                Animator.this.setVal(d);
            }

            @Override
            public double getVal() {
                return Animator.this.getVal();
            }
        };
    }

    public Computable getOnChange() {
        return this.onChange;
    }

    public void setOnChange(Computable computable) {
        this.onChange = computable;
    }

    @Override
    public void notifyControllerOnChange(Controller controller) {
        this.setOnChange(controller);
    }

    public boolean getUndefinedWhenNotRunning() {
        return this.undefinedWhenNotRunning;
    }

    public void setUndefinedWhenNotRunning(boolean bl) {
        this.undefinedWhenNotRunning = bl;
    }

    public synchronized void start() {
        if (this.runner != null && this.runner.isAlive() && this.status == STOP) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.runner != null && this.runner.isAlive()) {
                this.runner.interrupt();
                this.runner = null;
            }
        }
        if (this.runner == null || !this.runner.isAlive()) {
            this.runner = new Thread(this);
            this.status = START;
            this.runner.start();
        } else if (this.status != RUN) {
            this.status = START;
            this.notify();
        }
    }

    public synchronized void pause() {
        if (this.status == RUN) {
            this.status = PAUSE;
            this.notify();
        }
    }

    public synchronized void next() {
        if (this.runner == null || !this.runner.isAlive()) {
            this.runner = new Thread(this);
            this.status = NEXT;
            this.runner.start();
        } else if (this.status == PAUSE) {
            this.status = NEXT;
            this.notify();
        }
    }

    public synchronized void prev() {
        if (this.runner == null || !this.runner.isAlive()) {
            this.runner = new Thread(this);
            this.status = PREV;
            this.runner.start();
        } else if (this.status == PAUSE) {
            this.status = PREV;
            this.notify();
        }
    }

    public synchronized void stop() {
        this.status = STOP;
        if (this.runner == null || !this.runner.isAlive()) {
            return;
        }
        this.notify();
    }

    @Override
    public synchronized void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == null) {
            return;
        }
        if (object == this.startStopButton) {
            if (this.status == RUN) {
                this.stop();
            } else {
                this.start();
            }
        } else if (object == this.startButton) {
            this.start();
        } else if (object == this.stopButton) {
            this.stop();
        } else if (object == this.nextButton) {
            this.next();
        } else if (object == this.prevButton) {
            this.prev();
        } else if (object == this.pauseButton) {
            this.pause();
        }
    }

    @Override
    public synchronized void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.loopChoice && this.loopChoice != null) {
            this.setLoopStyle(this.loopChoice.getSelectedIndex());
        } else if (itemEvent.getSource() == this.speedChoice && this.speedChoice != null) {
            switch (this.speedChoice.getSelectedIndex()) {
                case 0: {
                    this.millisPerFrame = 0;
                    break;
                }
                case 1: {
                    this.millisPerFrame = 30;
                    break;
                }
                case 2: {
                    this.millisPerFrame = 100;
                    break;
                }
                case 3: {
                    this.millisPerFrame = 500;
                    break;
                }
                case 4: {
                    this.millisPerFrame = 2000;
                }
            }
        }
    }

    @Override
    public void checkInput() {
        this.needsValueCheck = true;
    }

    @Override
    public long getSerialNumber() {
        if (this.needsValueCheck) {
            this.checkValue();
        }
        return this.serialNumber;
    }

    @Override
    public void sync(Tie tie, Tieable tieable) {
        if (tieable != this) {
            if (!(tieable instanceof Value)) {
                throw new IllegalArgumentException("Internal Error:  An Animator can only sync with Value objects.");
            }
            this.setVal(((Value)((Object)tieable)).getVal());
            this.serialNumber = tieable.getSerialNumber();
        }
    }

    private synchronized void checkValue() {
        double d;
        double d2;
        if (this.min != null) {
            this.min_val = this.min.getVal();
        }
        if (this.max != null) {
            this.max_val = this.max.getVal();
        }
        this.intervals_val = this.intervals == null ? 0 : (Double.isNaN(d2 = this.intervals.getVal()) || d2 <= 0.5 ? 0 : (d2 > 100000.0 ? 100000 : (int)Math.round(d2)));
        this.maxFrame = this.intervals_val;
        if (this.min == null || this.max == null) {
            d = this.frame;
        } else if (Double.isNaN(this.min_val) || Double.isNaN(this.max_val) || Double.isInfinite(this.min_val) || Double.isInfinite(this.max_val)) {
            d = Double.NaN;
        } else if (this.intervals_val > 0) {
            d = this.min_val + (double)this.frame * (this.max_val - this.min_val) / (double)this.intervals_val;
        } else {
            this.maxFrame = 100;
            d = this.min_val + (double)this.frame * (this.max_val - this.min_val) / 100.0;
        }
        if (this.undefinedWhenNotRunning && this.status == STOP) {
            d = Double.NaN;
        }
        this.value = d;
        this.needsValueCheck = false;
    }

    private void doControlStatus(int n) {
        if (this.startStopButton != null) {
            this.startStopButton.setLabel(n == START ? this.stopButtonName : this.startButtonName);
        }
        if (this.startButton != null) {
            this.startButton.setEnabled(n != START);
        }
        if (this.stopButton != null) {
            this.stopButton.setEnabled(n != STOP);
        }
        if (this.nextButton != null) {
            this.nextButton.setEnabled(n != START);
        }
        if (this.prevButton != null) {
            this.prevButton.setEnabled(n != START);
        }
        if (this.pauseButton != null) {
            this.pauseButton.setEnabled(n == START);
        }
    }

    private void doAdvanceFrame(int n) {
        ++this.serialNumber;
        this.frame = this.loopStyle == 2 && this.runningBackwards ? (this.frame -= n) : (this.frame += n);
        if (this.frame < 0) {
            if (this.loopStyle == 1) {
                this.frame = this.maxFrame;
            } else if (this.loopStyle == 2) {
                this.frame = 1;
                this.runningBackwards = n != 1;
            } else {
                this.frame = 0;
            }
        } else if (this.maxFrame > 0 && this.frame > this.maxFrame) {
            if (this.loopStyle == 1) {
                this.frame = 1;
            } else {
                if (this.loopStyle == 0) {
                    this.frame = this.maxFrame;
                    this.status = STOP;
                    return;
                }
                this.frame = this.maxFrame - 1;
                this.runningBackwards = n == 1;
            }
        }
        if (this.onChange != null) {
            this.onChange.compute();
        } else {
            this.needsValueCheck = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Animator animator;
        int n = this.status;
        long l = 0L;
        this.runningBackwards = false;
        if (this.frame != 0 || this.undefinedWhenNotRunning) {
            this.frame = 0;
            ++this.serialNumber;
            l = System.currentTimeMillis();
            if (this.onChange != null) {
                this.onChange.compute();
            } else {
                this.needsValueCheck = true;
            }
            if (this.status == PREV || this.status == NEXT) {
                this.status = PAUSE;
            }
        }
        try {
            while (true) {
                animator = this;
                synchronized (animator) {
                    while (this.status == PAUSE) {
                        if (n != PAUSE) {
                            this.doControlStatus(PAUSE);
                            n = PAUSE;
                        }
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.status == STOP) {
                        break;
                    }
                    n = this.status;
                    if (this.needsValueCheck) {
                        this.checkValue();
                    }
                }
                if (n == START) {
                    this.doControlStatus(START);
                    n = this.status = RUN;
                }
                if (n == RUN) {
                    long l2 = System.currentTimeMillis() - l;
                    long l3 = (long)this.millisPerFrame - l2;
                    if (l3 <= 5L) {
                        l3 = 5L;
                    }
                    try {
                        Animator animator2 = this;
                        synchronized (animator2) {
                            this.wait(l3);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    l = System.currentTimeMillis();
                    if (this.status != RUN) continue;
                    this.doAdvanceFrame(1);
                    continue;
                }
                if (n == NEXT) {
                    this.doAdvanceFrame(1);
                    if (this.status == STOP) continue;
                    this.status = n = PAUSE;
                    continue;
                }
                if (n != PREV) continue;
                this.doAdvanceFrame(-1);
                if (this.status == STOP) continue;
                this.status = n = PAUSE;
            }
        }
        finally {
            animator = this;
            synchronized (animator) {
                this.status = STOP;
                this.doControlStatus(STOP);
                this.frame = 0;
                ++this.serialNumber;
                if (this.onChange != null) {
                    this.onChange.compute();
                } else {
                    this.needsValueCheck = true;
                }
                this.runner = null;
                this.notify();
            }
        }
    }
}

