/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultMemoryStat;
import com.nvidia.viper.jni.MemoryChartMetricType;
import com.nvidia.viper.jni.NativeMemoryChart;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.ui.analysis.AnalysisResultControl;
import com.nvidia.viper.ui.analysis.MemoryChartCanvas;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class MemoryChartControl
extends AnalysisResultControl {
    private long qtHandle;

    public MemoryChartControl(Composite parent, AnalysisResult result, Session session) {
        super(parent, result, session);
    }

    private AnalysisResultMemoryStat getMemoryChartResult() {
        return (AnalysisResultMemoryStat)this.result;
    }

    @Override
    protected void createExtension(Composite parent) {
        TimelineIntervalKernel kernel = this.getMemoryChartResult().getKernel();
        MemoryChartCanvas canvas = new MemoryChartCanvas(parent, 0, kernel);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.heightHint = 200;
        canvas.setLayoutData(layoutData);
    }

    private void addQtBasedControl(Composite parent, TimelineIntervalKernel kernel) {
        NativeMemoryChart.setKernelName(kernel.getDisplayName());
        NativeMemoryChart.setMetric(MemoryChartMetricType.ReqTexture.ordinal(), MemoryChartMetricType.MetricUnit.Instructions.ordinal(), 0.0);
        NativeMemoryChart.setMetric(MemoryChartMetricType.ReqLocal.ordinal(), MemoryChartMetricType.MetricUnit.Instructions.ordinal(), 162350.0);
        NativeMemoryChart.setMetric(MemoryChartMetricType.ReqGlobal.ordinal(), MemoryChartMetricType.MetricUnit.Instructions.ordinal(), 60000.0);
        NativeMemoryChart.setMetric(MemoryChartMetricType.ReqShared.ordinal(), MemoryChartMetricType.MetricUnit.Instructions.ordinal(), 48270.0);
        NativeMemoryChart.setMetric(MemoryChartMetricType.LoadTexture.ordinal(), MemoryChartMetricType.MetricUnit.Requests.ordinal(), 0.0);
        NativeMemoryChart.setMetric(MemoryChartMetricType.LoadLocal.ordinal(), MemoryChartMetricType.MetricUnit.Requests.ordinal(), 10000.0);
        NativeMemoryChart.setMetric(MemoryChartMetricType.StoreLocal.ordinal(), MemoryChartMetricType.MetricUnit.Requests.ordinal(), 9870.0);
        NativeMemoryChart.setMetric(MemoryChartMetricType.LoadGlobal.ordinal(), MemoryChartMetricType.MetricUnit.Requests.ordinal(), 5320.0);
        NativeMemoryChart.setMetric(MemoryChartMetricType.StoreGlobal.ordinal(), MemoryChartMetricType.MetricUnit.Requests.ordinal(), 2000.0);
        NativeMemoryChart.setMetric(MemoryChartMetricType.LoadShared.ordinal(), MemoryChartMetricType.MetricUnit.Requests.ordinal(), 4450.0);
        NativeMemoryChart.setMetric(MemoryChartMetricType.StoreShared.ordinal(), MemoryChartMetricType.MetricUnit.Requests.ordinal(), 7300.0);
        NativeMemoryChart.setMetric(MemoryChartMetricType.LoadUnifiedCache.ordinal(), MemoryChartMetricType.MetricUnit.Bytes.ordinal(), 2740000.0);
        NativeMemoryChart.setMetric(MemoryChartMetricType.StoreUnifiedCache.ordinal(), MemoryChartMetricType.MetricUnit.Bytes.ordinal(), 5000000.0);
        NativeMemoryChart.setMetric(MemoryChartMetricType.LoadL2SysMem.ordinal(), MemoryChartMetricType.MetricUnit.Bytes.ordinal(), 10.0);
        NativeMemoryChart.setMetric(MemoryChartMetricType.StoreL2SysMem.ordinal(), MemoryChartMetricType.MetricUnit.Bytes.ordinal(), 22.0);
        NativeMemoryChart.setMetric(MemoryChartMetricType.LoadL2DeviceMem.ordinal(), MemoryChartMetricType.MetricUnit.Bytes.ordinal(), 4620000.0);
        NativeMemoryChart.setMetric(MemoryChartMetricType.StoreL2DeviceMem.ordinal(), MemoryChartMetricType.MetricUnit.Bytes.ordinal(), 3345200.0);
        NativeMemoryChart.setMetric(MemoryChartMetricType.LoadSurface.ordinal(), MemoryChartMetricType.MetricUnit.Requests.ordinal(), 444654.0);
        NativeMemoryChart.setMetric(MemoryChartMetricType.StoreSurface.ordinal(), MemoryChartMetricType.MetricUnit.Requests.ordinal(), 5676575.0);
        NativeMemoryChart.setMetric(MemoryChartMetricType.UnifiedCacheHitRate.ordinal(), MemoryChartMetricType.MetricUnit.Percent.ordinal(), 67.0);
        NativeMemoryChart.setMetric(MemoryChartMetricType.L2CacheHitRate.ordinal(), MemoryChartMetricType.MetricUnit.Percent.ordinal(), 89.0);
        long embeddedHandle = this.getEmbededHandle(parent);
        if (embeddedHandle == 0L) {
            return;
        }
        String strHandle = Long.toString(embeddedHandle);
        this.qtHandle = NativeMemoryChart.embedMemoryView(strHandle);
    }

    @Override
    public boolean grabsVerticalSpace() {
        return true;
    }

    @Override
    protected boolean hasExtension() {
        return true;
    }

    private long getEmbededHandle(Composite parent) {
        long embeddedHandle;
        block5: {
            embeddedHandle = 0L;
            Composite host = null;
            Class<?> compositeClass = null;
            Object compositeObj = null;
            try {
                compositeClass = Class.forName("org.eclipse.swt.widgets.Composite");
                Class[] partypes = new Class[]{Composite.class, Integer.TYPE};
                Constructor<?> ct = compositeClass.getConstructor(partypes);
                Object[] arglist = new Object[]{parent, 0x1040000};
                compositeObj = ct.newInstance(arglist);
                host = compositeObj;
                if (host instanceof Composite) {
                    GridData layoutData = new GridData(4, 4, true, true);
                    host.setLayoutData((Object)layoutData);
                    host.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            NativeMemoryChart.disposeWidget(MemoryChartControl.this.qtHandle);
                        }
                    });
                }
                Field field = compositeClass.getDeclaredField("embeddedHandle");
                embeddedHandle = (Long)field.get(compositeObj);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                if (host == null || compositeClass == null || compositeObj == null) break block5;
                try {
                    Field field = compositeClass.getDeclaredField("handle");
                    embeddedHandle = (Long)field.get(compositeObj);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {}
            }
        }
        return embeddedHandle;
    }
}

