/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.core.parser.OffsetLimitReachedException;
import org.eclipse.cdt.core.parser.util.CharArrayIntMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.parser.scanner.AbstractCharArray;
import org.eclipse.cdt.internal.core.parser.scanner.ILexerLog;
import org.eclipse.cdt.internal.core.parser.scanner.Lexer;
import org.eclipse.cdt.internal.core.parser.scanner.Token;

public class IncludeGuardDetection {
    public static char[] detectIncludeGuard(AbstractCharArray content, Lexer.LexerOptions lexOptions, CharArrayIntMap ppKeywords) {
        Lexer l = new Lexer(content, lexOptions, ILexerLog.NULL, null);
        char[] guard = IncludeGuardDetection.findIncludeGuard(l, ppKeywords);
        if (guard != null && IncludeGuardDetection.currentIfSpansFile(l, ppKeywords)) {
            return guard;
        }
        return null;
    }

    private static char[] findIncludeGuard(Lexer l, CharArrayIntMap ppKeywords) {
        try {
            Token t;
            if (IncludeGuardDetection.skipAll(l, -99).getType() == 138 && (t = l.nextToken()).getType() == 1) {
                char[] guard = null;
                switch (ppKeywords.get(t.getCharImage())) {
                    case 2: {
                        t = l.nextToken();
                        if (t.getType() != 1) break;
                        guard = t.getCharImage();
                        break;
                    }
                    case 0: {
                        guard = IncludeGuardDetection.findNotDefined(l);
                    }
                }
                if (guard != null) {
                    l.consumeLine(2);
                    if (IncludeGuardDetection.skipAll(l, -99).getType() == 138 && IncludeGuardDetection.checkToken(l.nextToken(), Keywords.cDEFINE) && IncludeGuardDetection.checkToken(l.nextToken(), guard)) {
                        l.consumeLine(2);
                        return guard;
                    }
                }
            }
        }
        catch (OffsetLimitReachedException offsetLimitReachedException) {}
        return null;
    }

    private static char[] findNotDefined(Lexer l) throws OffsetLimitReachedException {
        if (IncludeGuardDetection.skipAll(l, 8).getType() == 36 && IncludeGuardDetection.checkToken(IncludeGuardDetection.skipAll(l, 8), Keywords.cDEFINED)) {
            Token t = l.nextToken();
            if (t.getType() == 8) {
                t = l.nextToken();
            }
            if (t.getType() == 1) {
                char[] guard = t.getCharImage();
                if (IncludeGuardDetection.skipAll(l, 9).getType() == -99) {
                    return guard;
                }
            }
        }
        return null;
    }

    private static boolean checkToken(Token t, char[] image) throws OffsetLimitReachedException {
        return CharArrayUtils.equals(t.getCharImage(), image);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean currentIfSpansFile(Lexer l, CharArrayIntMap ppKeywords) {
        try {
            int nesting = 1;
            while (nesting > 0) {
                Token t = l.nextDirective();
                if (t.getType() == 144) {
                    return true;
                }
                switch (ppKeywords.get(l.nextToken().getCharImage())) {
                    case 0: 
                    case 1: 
                    case 2: {
                        ++nesting;
                        break;
                    }
                    case 5: {
                        --nesting;
                        break;
                    }
                }
            }
            l.consumeLine(2);
            return IncludeGuardDetection.skipAll(l, -99).getType() == 144;
        }
        catch (OffsetLimitReachedException offsetLimitReachedException) {
            return true;
        }
    }

    private static Token skipAll(Lexer l, int kind) throws OffsetLimitReachedException {
        Token t = l.nextToken();
        while (t.getType() == kind) {
            t = l.nextToken();
        }
        return t;
    }

    public static boolean detectIncludeEndif(Lexer l) {
        l.saveState();
        try {
            boolean bl = IncludeGuardDetection.findIncludeEndif(l);
            return bl;
        }
        catch (OffsetLimitReachedException offsetLimitReachedException) {
        }
        finally {
            l.restoreState();
        }
        return false;
    }

    private static boolean findIncludeEndif(Lexer l) throws OffsetLimitReachedException {
        if (IncludeGuardDetection.skipAll(l, -99).getType() != 138) {
            return false;
        }
        if (!IncludeGuardDetection.checkToken(l.nextToken(), Keywords.cINCLUDE)) {
            return false;
        }
        l.consumeLine(2);
        if (IncludeGuardDetection.skipAll(l, -99).getType() != 138) {
            return false;
        }
        return IncludeGuardDetection.checkToken(l.nextToken(), Keywords.cENDIF);
    }

    public static char[] detectIfNotDefinedIncludeEndif(Lexer l) {
        l.saveState();
        try {
            char[] guard = IncludeGuardDetection.findNotDefined(l);
            if (guard != null && IncludeGuardDetection.findIncludeEndif(l)) {
                char[] cArray = guard;
                return cArray;
            }
        }
        catch (OffsetLimitReachedException offsetLimitReachedException) {
        }
        finally {
            l.restoreState();
        }
        return null;
    }
}

